/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:11 $
 * $Revision: 1.14 $
 */

/*******************************************************************************/
/*  Project...: C++ and ANSI-C Compiler Environment                     ********/
/*  Purpose...: Printing function for SIOUX for Windows			    	********/
/*******************************************************************************/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <commdlg.h>
#include <winspool.h>
#include <stdio.h>
#include <stdlib.h>						/*- mm 990520 -*/
#include <WinSIOUX.h>

#define IDD_FNAME	10
extern FILE* dbgfile;

BOOL CALLBACK PrintDialogProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK AbortProc(HDC, int);
BOOL WinSIOUXprint(HINSTANCE, HWND, PSTR, tSIOUXBuffer);
HDC  GetPrinterDeviceContext(HWND);

BOOL UserAbortFlag;
HWND PrintDialogHandle;

BOOL WinSIOUXprint(HINSTANCE ThisInst, HWND WindowHandle, LPSTR TitleName, 
					tSIOUXBuffer SIOUXBuffer)
{
	static DOCINFO  di = {sizeof(DOCINFO), "WinSIOUX.out", NULL };
	static PRINTDLG pd;
	BOOL            SuccessFlag;
	char			*textptr;
	int             CharHeight, 
					CharsPerLine,
					LinesPerPage,
					TotalPages,
					FirstPageNumber,
					LastPageNumber,
					Page,
					CorrectedLineCount,      /*- mm 990507 -*/
					Line,
					LineNum;
	TEXTMETRIC      tm;
	POINT			Point;
	WORD            ColCopy,
					NoColCopy;
	char            temptext[256];
	int             i, charcount;
	
	pd.lStructSize         = sizeof(PRINTDLG);
	pd.hwndOwner           = WindowHandle;
	pd.hDevMode            = NULL;
	pd.hDevNames           = NULL;
	pd.hDC                 = NULL;				/*- mm 990507 -*/
	pd.Flags               = PD_ALLPAGES | PD_COLLATE | PD_RETURNDC | PD_NOSELECTION;
	pd.nFromPage           = 1;					/*- mm 990507 -*/
	pd.nToPage             = 0xffff;			/*- mm 990507 -*/
	pd.nMinPage            = 1;
	pd.nMaxPage            = 0xffff;			/*- mm 990507 -*/
	pd.nCopies             = 1;
	pd.hInstance           = NULL;
	pd.lCustData           = 0L;
	pd.lpfnPrintHook       = NULL;
	pd.lpfnSetupHook       = NULL;
	pd.lpPrintTemplateName = NULL;
	pd.lpSetupTemplateName = NULL;
	pd.hPrintTemplate      = NULL;
	pd.hSetupTemplate      = NULL;

	if (!PrintDlg(&pd))									/*- mm 990507 -*/
		return TRUE;									/*- mm 990507 -*/

	if (pd.hDC == NULL) 								/*- mm 990507 -*/
		pd.hDC = GetPrinterDeviceContext(WindowHandle);	/*- mm 990507 -*/

	if (pd.hDC != NULL)
	{
		GetTextMetrics (pd.hDC, &tm);
		CharHeight   = tm.tmHeight + tm.tmExternalLeading;
		LinesPerPage = (GetDeviceCaps (pd.hDC, VERTRES) / CharHeight)-2;
		pd.nMaxPage  = (SIOUXBuffer.numlines + LinesPerPage - 1) / LinesPerPage;
	}

	if (SIOUXBuffer.startpos == SIOUXBuffer.endpos)			/*- mm 990507 -*/
	{														/*- mm 990507 -*/
		MessageBox(WindowHandle, "nothing to print", "WinSIOUX", MB_OK | MB_ICONEXCLAMATION);/*- mm 990507 -*/
		return TRUE;										/*- mm 990507 -*/
	}														/*- mm 990507 -*/
	CorrectedLineCount = SIOUXBuffer.numlines;				/*- mm 990507 -*/
	if (*SIOUXBuffer.endpos != '\r' && *SIOUXBuffer.endpos != '\n')/*- mm 990507 -*/
		CorrectedLineCount++;								/*- mm 990507 -*/
															/*- mm 990507 -*/
	/*  Get new set of TextMetrics in case user changed printer during dialog */
	GetTextMetrics (pd.hDC, &tm);
	CharHeight = tm.tmHeight + tm.tmExternalLeading;

	CharsPerLine = GetDeviceCaps(pd.hDC, HORZRES) / tm.tmAveCharWidth;
	LinesPerPage = (GetDeviceCaps(pd.hDC, VERTRES) / CharHeight)-2;
	TotalPages   = (CorrectedLineCount + LinesPerPage - 1) / LinesPerPage;	/*- mm 990507 -*/
	EnableWindow(WindowHandle, FALSE);

	SuccessFlag   = TRUE;
	UserAbortFlag = FALSE;

	if (pd.Flags & PD_PAGENUMS)
	{
		FirstPageNumber = pd.nFromPage;
		LastPageNumber  = pd.nToPage;
	}
	else
	{
		FirstPageNumber = 1;
		LastPageNumber  = TotalPages;
	}
	

	PrintDialogHandle = CreateDialog(ThisInst, (LPCTSTR)"PrintDlgBox", WindowHandle, 
																PrintDialogProc);
	SetDlgItemText(PrintDialogHandle, IDD_FNAME, TitleName);

	SetAbortProc(pd.hDC, AbortProc);

	if (StartDoc(pd.hDC, &di) > 0)
	{
		for (ColCopy = 0;
			 ColCopy < ((WORD)pd.Flags & PD_COLLATE ? pd.nCopies : 1);
			 ColCopy++)
		{
			textptr = SIOUXBuffer.startpos;
			for (Page = 1; Page <= LastPageNumber; Page++)
    		{
    			for (NoColCopy = 0;
         			 NoColCopy < (pd.Flags & PD_COLLATE ? 1 : pd.nCopies);
         			 NoColCopy++)
         		{

					/* If page number within printing range, print header */
              		if (Page >= FirstPageNumber)
              		{
	         			if (StartPage(pd.hDC) < 0)
	              		{
	              			SuccessFlag = FALSE;
	              			break;
	              		}
	              		if (TitleName[0] == '\0')
	              		{
	              			strcpy(temptext, "WinSIOUX.out");
	              			TextOut(pd.hDC, 0, 0, temptext, strlen(temptext));
	              		}
	              		else
	              			TextOut(pd.hDC, 0, 0, TitleName, strlen(TitleName));
              		
	              		sprintf(temptext, "Page %i", Page);
	              		TextOut(pd.hDC, (CharsPerLine - strlen(temptext)) * tm.tmAveCharWidth,
	              		                                    0, temptext, strlen(temptext));
	              		MoveToEx(pd.hDC, 0, CharHeight, &Point);
	              		LineTo(pd.hDC, CharsPerLine * tm.tmAveCharWidth, CharHeight);
	              	}
	              
         			for (Line = 0; Line < LinesPerPage; Line++)
              		{
              			LineNum = LinesPerPage * (Page - 1) + Line;

              			if (LineNum > CorrectedLineCount)				/*- mm 990507 -*/
                   			break;
						
						charcount = 0;
						while ((*textptr != '\n') && (*textptr != '\r') &&
						       (textptr < SIOUXBuffer.endpos) &&
						       (charcount <= CharsPerLine))
						{
							temptext[charcount] = *textptr;
							textptr++;
							charcount++;
						}
						i = 0;
						while((i < 2) && ((*textptr == '\n') || (*textptr == '\r')))
						{
							textptr++;
							i++;
						}

              			if ((Page >= FirstPageNumber) && (charcount > 0))
              				TextOut(pd.hDC, 0, CharHeight * (Line+2), temptext, charcount);
              		}

               		if (Page >= FirstPageNumber)
               		{
	        			if (EndPage (pd.hDC) < 0)
	              		{
	              			SuccessFlag = FALSE;
	              			break;
	              		}
	              	}
 
			        if (UserAbortFlag)
              			break;
         		}

    			if (!SuccessFlag || UserAbortFlag)
         			break;
    		}

			if (!SuccessFlag || UserAbortFlag)
    			break;
		}
	}
	else
		SuccessFlag = FALSE;

	if (SuccessFlag)
		EndDoc(pd.hDC);

	if (!UserAbortFlag)
	{
		EnableWindow(WindowHandle, TRUE);
		DestroyWindow(PrintDialogHandle);
	}

	DeleteDC (pd.hDC);

	return SuccessFlag && !UserAbortFlag;
}

BOOL CALLBACK PrintDialogProc(HWND DialogHandle, UINT msg, WPARAM /* wParam */, LPARAM /*lParam */)
{
	switch(msg)
	{
		case WM_INITDIALOG:
		   EnableMenuItem(GetSystemMenu(DialogHandle, FALSE), SC_CLOSE, MF_GRAYED);
		   return TRUE;
		
		case WM_COMMAND:
		   UserAbortFlag = TRUE;
		   EnableWindow(GetParent(DialogHandle), TRUE);
		   DestroyWindow(DialogHandle);
		   PrintDialogHandle = 0;
		   return TRUE;
	}
	return FALSE;
}          

BOOL CALLBACK AbortProc(HDC /* hPrinterDC */, int /* iCode */)
{
	MSG msg;
	
	while (!UserAbortFlag && PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
	{
		if (!PrintDialogHandle || !IsDialogMessage(PrintDialogHandle, &msg))
	   {
		   TranslateMessage(&msg);
		   DispatchMessage(&msg);
	   }
	}
	return !UserAbortFlag;
}

HDC GetPrinterDeviceContext(HWND WindowHandle)
{
	PRINTER_INFO_4  * PrinterInfo4;				/*- mm 990507 -*/
	PRINTER_INFO_5  * PrinterInfo5;				/*- mm 990507 -*/
	DWORD			BytesCopied, StructuresCopied;
	char			Msg[]  = "Default printer not found";
	HDC				hdc;
	/*- mm 990507 -*/
	if (GetVersion() & 0x80000000)  /*  Windows 98  */
	{

		EnumPrinters(PRINTER_ENUM_DEFAULT, NULL, 5, NULL, 0, &BytesCopied,  &StructuresCopied);

		PrinterInfo5 = (PRINTER_INFO_5 *)malloc(BytesCopied);

		if (EnumPrinters(PRINTER_ENUM_DEFAULT, NULL, 5, (PBYTE) PrinterInfo5,
							BytesCopied, &BytesCopied, &StructuresCopied))
		{
			hdc = CreateDC(NULL, PrinterInfo5->pPrinterName, NULL, NULL);
			free(PrinterInfo5);
		} 
		else 
		{

			MessageBox(WindowHandle, Msg, "WinSIOUX",
							MB_OK | MB_ICONEXCLAMATION);
			return (0);
		}

	} 
	else 
	{  /*  Windows NT || Windows 95 */

		EnumPrinters(PRINTER_ENUM_LOCAL, NULL, 4, NULL, 0, &BytesCopied, &StructuresCopied);

		PrinterInfo4 = (PRINTER_INFO_4 *)malloc(BytesCopied);

		if (EnumPrinters(PRINTER_ENUM_LOCAL, NULL, 4, (PBYTE) PrinterInfo4,
							BytesCopied, &BytesCopied, &StructuresCopied))
		{
			hdc = CreateDC(NULL, PrinterInfo4->pPrinterName, NULL, NULL);
			free(PrinterInfo4);
		
		} 
		else 
		{

			MessageBox(WindowHandle, Msg, "WinSIOUX",
							MB_OK | MB_ICONEXCLAMATION);
			return (0);
		}
	}
	/*- mm 990507 -*/

	return(hdc);
}													

/* Change record:
 * mm  980219 First version
 * mm  980411 Second version, printing selected pages added
 * mm  990507 Corrections to allow printing on Windows 98 and NT
 * mm  990520 Inserted missing #include for stdlib.h to get malloc.	 
 * cc  000518 fixed #include 
 */
