/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:49 $
 * $Revision: 1.6 $
 */
 
/*
 *		support for direct hardware access
 */

#ifndef _WIN32
#define _WIN32
#endif


#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <conio.h> 
#include <stdio.h>

unsigned char __declspec(naked) _MSL_CDECL _inp(unsigned short port) _MSL_CANT_THROW
{
  asm {
    mov dx, port
    in al, dx
    ret
  }
}

unsigned short __declspec(naked) _MSL_CDECL _inpw(unsigned short port) _MSL_CANT_THROW
{
  asm {
    mov dx, port
    in ax, dx
    ret
  }
}

unsigned long __declspec(naked) _MSL_CDECL _inpd(unsigned short port) _MSL_CANT_THROW
{
  asm {
    mov dx, port
    in eax, dx
    ret
  }
}

void __declspec(naked) _MSL_CDECL _outp(unsigned short port, unsigned char val) _MSL_CANT_THROW
{
  asm { 
    mov dx, port
    mov al, val
    out dx, al
    ret
  }
}

void __declspec(naked) _MSL_CDECL _outpw(unsigned short port, unsigned short val) _MSL_CANT_THROW
{
  asm { 
    mov dx, port
    mov ax, val
    out dx, ax
    ret
  }
}

void __declspec(naked) _MSL_CDECL _outpd(unsigned short port, unsigned long val) _MSL_CANT_THROW
{
  asm {
    mov dx, port
    mov eax, val
    out dx, eax
    ret
  }
}

unsigned char _MSL_CDECL inp(unsigned short port) _MSL_CANT_THROW
{
	return _inp(port);
}

unsigned short _MSL_CDECL inpw(unsigned short port) _MSL_CANT_THROW
{
	return _inpw(port);
}

unsigned long _MSL_CDECL inpd(unsigned short port) _MSL_CANT_THROW
{
	return _inpd(port);
}

void _MSL_CDECL outp(unsigned short port, unsigned char val) _MSL_CANT_THROW
{
	_outp(port,val);
}

void _MSL_CDECL outpw(unsigned short port, unsigned short val) _MSL_CANT_THROW
{
	_outpw(port,val);
}

void _MSL_CDECL outpd(unsigned short port, unsigned long val) _MSL_CANT_THROW
{
	_outpd(port,val);
}

// returns true if characters waiting in input queue for console application
// it has the side effect of eating any non-keyboard input records in the
// console input queue
int _MSL_CDECL _kbhit(void) _MSL_CANT_THROW
{
	INPUT_RECORD in[256];
	int idx;
	DWORD numRead;
	HANDLE hnd = GetStdHandle(STD_INPUT_HANDLE);
	DWORD oldflags;
	int hit = 0;
	
	// clear current flags and inhibit echoing and non-keyboard events
	GetConsoleMode(hnd, &oldflags);
	SetConsoleMode(hnd, 0);
	
	// peek at a large number of input records.
	// any keypress should be one of them, but
	// don't throw them away!
	
	if (PeekConsoleInput(hnd, in, 256, &numRead))
	{
		for (idx = 0; idx < numRead; idx++)
		{
			if (in[idx].EventType == KEY_EVENT 
			&& 	in[idx].Event.KeyEvent.bKeyDown)
			{
				hit = 1;
				break;
			}
		}
	}
	
	// reset console flags
	SetConsoleMode(hnd, oldflags);

	return hit;
}


int _MSL_CDECL kbhit(void) _MSL_CANT_THROW
{
	return _kbhit();
}

// get a keyboard character without echo
int _MSL_CDECL _getch(void) _MSL_CANT_THROW
{
	HANDLE hnd = GetStdHandle(STD_INPUT_HANDLE);
	char ch;
	DWORD numRead;
	DWORD oldflags;
	
	// clear current flags and inhibit echoing and non-keyboard events
	GetConsoleMode(hnd, &oldflags);
	SetConsoleMode(hnd, 0);
	
	ReadConsole(hnd, &ch, 1, &numRead, NULL);

	// reset console flags
	SetConsoleMode(hnd, oldflags);
	return ch;
}

int _MSL_CDECL getch(void) _MSL_CANT_THROW
{
	return _getch();
} 

// get a keyboard character with echo
int _MSL_CDECL _getche(void) _MSL_CANT_THROW
{
	char ch;
	HANDLE hnd = GetStdHandle(STD_INPUT_HANDLE);
	DWORD numRead;
	DWORD oldflags;
	
	// clear current flags and allow echoing
	GetConsoleMode(hnd, &oldflags);
	SetConsoleMode(hnd, ENABLE_LINE_INPUT | ENABLE_ECHO_INPUT);

	ReadConsole(hnd, &ch, 1, &numRead, NULL);
	
	// reset console flags
	SetConsoleMode(hnd, oldflags);
	return ch;
}

int _MSL_CDECL getche(void) _MSL_CANT_THROW
{
	return _getche();
}



/*
 *  console emulation functions
 *  (these act a lot like the functions with similar names in
 *  Borland/Inprise's old compilers, but work in Win32 console
 *  windows)
 *
 *  some functions (gettext, puttext) aren't implemented because
 *  the model used for the Win32 screen buffer isn't compatible
 *  with the model used by those functions -- getting characters
 *  from the screen in Win32 returns an array of PCHARINFO types
 *  which can hold either 1-byte or 2-byte characters.
 *
 *  gettextinfo doesn't work because we don't have window()
 *  support
 *
 *	There is no need to call __initscr() unless you have a GUI
 *	app (subsystem Windows GUI), where no console is available
 *	at runtime.
 */

// set up standard 80x25 console with no scrolling region
void _MSL_CDECL _initscr(void) _MSL_CANT_THROW
{
	HANDLE hnd = GetStdHandle(STD_OUTPUT_HANDLE);
	COORD c;
	SMALL_RECT sr;
	
	c.X = 80;
	c.Y = 25;
	
	sr.Top = 0;	sr.Bottom = 24;
	sr.Left = 0; sr.Right = 79;
	
	SetConsoleScreenBufferSize(hnd, c);
	SetConsoleWindowInfo(hnd, TRUE, &sr);
}

// Clears console window
void _MSL_CDECL _clrscr(void) _MSL_CANT_THROW
{
	CONSOLE_SCREEN_BUFFER_INFO info;
	HANDLE hnd = GetStdHandle(STD_OUTPUT_HANDLE);
	COORD c;
	DWORD cellsWritten;
	int width, height;
	
	c.X = 0;
	c.Y = 0;
	
	GetConsoleScreenBufferInfo(hnd, &info);

	width = info.dwMaximumWindowSize.X;
	height = info.dwMaximumWindowSize.Y;

	FillConsoleOutputCharacter(hnd, ' ', width * height, c, &cellsWritten);
	FillConsoleOutputAttribute(hnd, info.wAttributes, width * height, 
		c, &cellsWritten);
}

// Position cursor in console window
void _MSL_CDECL _gotoxy(int x, int y) _MSL_CANT_THROW
{
	HANDLE hnd = GetStdHandle(STD_OUTPUT_HANDLE);
	COORD c;
	
	fflush(stdout);												/*- cc 010717 -*/
	c.X = x; 
	c.Y = y;	
	SetConsoleCursorPosition(hnd, c);
}

// return cursor x position
int _MSL_CDECL _wherex(void) _MSL_CANT_THROW
{
	CONSOLE_SCREEN_BUFFER_INFO info;
	HANDLE hnd = GetStdHandle(STD_OUTPUT_HANDLE);
	GetConsoleScreenBufferInfo(hnd, &info);
	return info.dwCursorPosition.X;
}

// return cursor y position
int _MSL_CDECL _wherey(void) _MSL_CANT_THROW
{
	CONSOLE_SCREEN_BUFFER_INFO info;
	HANDLE hnd = GetStdHandle(STD_OUTPUT_HANDLE);
	GetConsoleScreenBufferInfo(hnd, &info);
	return info.dwCursorPosition.Y;
}

void _MSL_CDECL _textattr(int newattr) _MSL_CANT_THROW
{
	HANDLE hnd = GetStdHandle(STD_OUTPUT_HANDLE);
	SetConsoleTextAttribute(hnd, newattr);
}

void _MSL_CDECL _textcolor(int newcolor) _MSL_CANT_THROW
{
	CONSOLE_SCREEN_BUFFER_INFO info;
	HANDLE hnd = GetStdHandle(STD_OUTPUT_HANDLE);

	GetConsoleScreenBufferInfo(hnd, &info);
	_textattr(info.wAttributes & ~0x0F | newcolor);
}

void _MSL_CDECL _textbackground(int newcolor) _MSL_CANT_THROW
{
	CONSOLE_SCREEN_BUFFER_INFO info;
	HANDLE hnd = GetStdHandle(STD_OUTPUT_HANDLE);

	GetConsoleScreenBufferInfo(hnd, &info);
	_textattr(info.wAttributes & ~0xF0 | (newcolor << 4));
}

/* Change record:
 * cc  000515 Fixed #include
 * ejs 010227 Fixed broken __getch()/__getche()
 * ejs 010419 Removed extra leading underscores for console functions
 * cc  010713 Added non-underscore version of outx and inx
 * cc  010713 Added non-underscore version of kbhit, getch and getche
 * ejs 010714 Remove unnecessary pushes/pops in inp/outp, and make underscored versions faster
 * cc  010717 Added fflush call to _gotoxy and #include of stdio.h
 * cc  011203 Added _MSL_CDECL for new name mangling 
 */
