/* Metrowerks x86 Runtime Support Library 
 * Copyright  1995-2003 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/05/13 16:09:01 $
 * $Revision: 1.1 $
 */

#include <CPlusLibX86.h>
#include <stdlib.h>

/* VC++ code sometimes has calls to these two functions
	inserted by the compiler, so we need the entry points available. */

__declspec(naked) void * __cdecl _chkstk(void)
{
    asm
    {
			// save edx to restore before returning
			push    edx

    		// start edx just before return address and stored edx
    		lea		edx, [esp+8]
    		
    		// Now, allocate the space in 4K chunks, probing each time, to make 
    		// sure the system allocates each of the new pages needed
    		
    next_four_k:
    		cmp		eax, 0x1000			// less than 0x1000 to go?
    		jb		last_one			// if so, see the last one
    		sub		edx, 0x1000			// if not, add a page
    		or		dword ptr[edx], 0	// touch the memory
    		sub		eax, 0x1000			// decrement memory count
    		jmp		next_four_k			// and do it again
    		
    last_one:
    		sub		edx, eax			// now, just finish off the allocation
    		mov		eax, esp			// save sp to we can restore context
    		mov		esp, edx			// store new SP into the real SP
    		mov		edx, [eax]			// restore edx
    		or		dword ptr[esp], 0	// touch the memory
			push	[eax+4]				// setup return addr
			lea		eax, [esp+4]		// store new ESP into eax for return value
    		ret							// and return to the caller
    }
}

// Stack allocation with probing every 4K so that new stack space will be allocated as needed
// blame this on Microsoft

__declspec(naked) void * __cdecl _stack_alloc(void)
{
    asm
    {
    		// First make it round
    		add		eax, 3
    		and		eax, 0xfffffffc

    		jmp		_chkstk					// allocate and probe the stack
    }
}

__declspec(naked) void * __cdecl _alloca_probe(void)
{
    asm
    {
	    	jmp		_chkstk
    }
}

// variable length array support

// Note, the compiler inlines these functions
// for VLA allocations outside of loops, where we don't
// bother to free the arrays.  Inside loops, this runtime
// code is called instead, since we want to free the space.

void *__cdecl __vla_alloc(size_t size)
{
	return (void*)malloc(size);
}

void __cdecl __vla_free(void *buffer)
{
	free(buffer);
}


/*
 * Change Record
 * hh  971207 Added _stack_alloc prototype
 * blc 990409 Fixed to only destroy value of EAX while in _chkstk
 * ejs 030226 Added variable length array support
 * ejs 030423 Modify VLA to use malloc/free
 */
