/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.imaker.ant.taskdefs;

import com.nokia.helium.core.plexus.AntStreamConsumer;
import com.nokia.helium.imaker.IMaker;
import com.nokia.helium.imaker.IMakerException;
import com.nokia.helium.imaker.ant.Command;
import com.nokia.helium.imaker.ant.Engine;
import com.nokia.helium.imaker.ant.IMakerCommandSet;
import com.nokia.helium.imaker.ant.engines.JavaEngine;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class IMakerTask
extends Task {
    private File epocroot;
    private boolean verbose;
    private boolean failOnError = true;
    private List<IMakerCommandSet> commandSets = new ArrayList<IMakerCommandSet>();
    private String engineRefId;
    private AntStreamConsumer stdout = new AntStreamConsumer((Task)this);
    private AntStreamConsumer stderr = new AntStreamConsumer((Task)this, 0);
    private File output;

    public void add(IMakerCommandSet cmdSet) {
        this.commandSets.add(cmdSet);
    }

    public void setEngineRefId(String engineRefId) {
        this.engineRefId = engineRefId;
    }

    protected Engine getEngine() {
        if (this.engineRefId == null) {
            this.log("Using default engine (Java threading)");
            JavaEngine engine = new JavaEngine();
            engine.setProject(this.getProject());
            engine.setTask(this);
            return engine;
        }
        try {
            Engine engine = (Engine)this.getProject().getReference(this.engineRefId);
            engine.setTask(this);
            return engine;
        }
        catch (ClassCastException e) {
            throw new BuildException("Reference '" + this.engineRefId + "' is not referencing an Engine configuration.");
        }
    }

    public File getEpocroot() {
        File epocroot = this.epocroot;
        if (epocroot == null) {
            epocroot = new File(System.getenv("EPOCROOT"));
            if (epocroot == null) {
                throw new BuildException("'epocroot' attribute has not been defined.");
            }
            this.log("Using EPOCROOT: " + epocroot.getAbsolutePath());
        }
        if (!epocroot.exists() || !epocroot.isDirectory()) {
            throw new BuildException("Invalid epocroot directory: " + epocroot);
        }
        return epocroot;
    }

    public void setEpocroot(File epocroot) {
        this.epocroot = epocroot;
    }

    public void execute() {
        try {
            IMaker imaker = this.getIMaker();
            this.log("Using iMaker: " + imaker.getVersion());
            this.build();
        }
        catch (IMakerException e) {
            if (this.shouldFailOnError()) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
            this.log(e.getMessage(), 0);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    protected void build() throws IMakerException {
        ArrayList<List<Command>> cmds = new ArrayList<List<Command>>();
        for (IMakerCommandSet cmdSet : this.commandSets) {
            DataType dataType;
            if (cmdSet instanceof DataType && (dataType = (DataType)cmdSet).isReference()) {
                cmdSet = (IMakerCommandSet)dataType.getRefid().getReferencedObject();
            }
            cmds.addAll(cmdSet.getCommands(this.getIMaker()));
        }
        if (cmds.size() > 0) {
            this.getEngine().build(cmds);
        } else {
            this.log("Nothing to build.");
        }
    }

    public IMaker getIMaker() {
        return this.getIMaker(this.verbose, true);
    }

    public IMaker getIMaker(boolean verbose, boolean verboseError) {
        IMaker imaker = new IMaker(this.getEpocroot());
        if (verbose) {
            imaker.addOutputLineHandler((StreamConsumer)this.stdout);
        }
        if (verboseError) {
            imaker.addErrorLineHandler((StreamConsumer)this.stderr);
        }
        return imaker;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean shouldFailOnError() {
        return this.failOnError;
    }
}

