/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.xml.parser;

import java.util.Vector;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContentHandler
implements ContentHandler {
    private static final String NAMESPACE_URI = "http://java.sun.com/xml/ns/persistence";
    private static final String ELEMENT_PERSISTENCE_UNIT = "persistence-unit";
    private static final String ELEMENT_PROVIDER = "provider";
    private static final String ELEMENT_JTA_DATA_SOURCE = "jta-data-source";
    private static final String ELEMENT_NON_JTA_DATA_SOURCE = "non-jta-data-source";
    private static final String ELEMENT_MAPPING_FILE = "mapping-file";
    private static final String ELEMENT_JAR_FILE = "jar-file";
    private static final String ELEMENT_CLASS = "class";
    private static final String ELEMENT_EXCLUDE_UNLISTED_CLASSES = "exclude-unlisted-classes";
    private static final String ELEMENT_CACHING = "shared-cache-mode";
    private static final String ELEMENT_VALIDATION_MODE = "validation-mode";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_TRANSACTION_TYPE = "transaction-type";
    private SEPersistenceUnitInfo persistenceUnitInfo;
    private Vector<SEPersistenceUnitInfo> persistenceUnits;
    private StringBuffer stringBuffer = new StringBuffer();
    private boolean readCharacters = false;

    public PersistenceContentHandler() {
        this.persistenceUnits = new Vector();
    }

    public Vector<SEPersistenceUnitInfo> getPersistenceUnits() {
        return this.persistenceUnits;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (NAMESPACE_URI.equals(namespaceURI)) {
            if (ELEMENT_PERSISTENCE_UNIT.equals(localName)) {
                this.persistenceUnitInfo = new SEPersistenceUnitInfo();
                this.persistenceUnitInfo.setPersistenceUnitName(atts.getValue(ATTRIBUTE_NAME));
                String transactionType = atts.getValue(ATTRIBUTE_TRANSACTION_TYPE);
                if (transactionType != null) {
                    this.persistenceUnitInfo.setTransactionType(PersistenceUnitTransactionType.valueOf((String)transactionType));
                }
                return;
            }
            if (ELEMENT_PROPERTY.equals(localName)) {
                String name = atts.getValue(ATTRIBUTE_NAME);
                String value = atts.getValue(ATTRIBUTE_VALUE);
                this.persistenceUnitInfo.getProperties().setProperty(name, value);
            } else {
                if (ELEMENT_PROVIDER.equals(localName)) {
                    this.readCharacters = true;
                    return;
                }
                if (ELEMENT_JTA_DATA_SOURCE.equals(localName)) {
                    this.readCharacters = true;
                    return;
                }
                if (ELEMENT_NON_JTA_DATA_SOURCE.equals(localName)) {
                    this.readCharacters = true;
                    return;
                }
                if (ELEMENT_MAPPING_FILE.equals(localName)) {
                    this.readCharacters = true;
                    return;
                }
                if (ELEMENT_JAR_FILE.equals(localName)) {
                    this.readCharacters = true;
                    return;
                }
                if (ELEMENT_EXCLUDE_UNLISTED_CLASSES.equals(localName)) {
                    this.readCharacters = true;
                    return;
                }
                if (ELEMENT_CACHING.equals(localName)) {
                    this.readCharacters = true;
                    return;
                }
                if (ELEMENT_VALIDATION_MODE.equals(localName)) {
                    this.readCharacters = true;
                    return;
                }
                if (ELEMENT_CLASS.equals(localName)) {
                    this.readCharacters = true;
                    return;
                }
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String string = this.stringBuffer.toString().trim();
        this.stringBuffer.delete(0, this.stringBuffer.length());
        this.readCharacters = false;
        if (NAMESPACE_URI.equals(namespaceURI)) {
            if (ELEMENT_PROVIDER.equals(localName)) {
                this.persistenceUnitInfo.setPersistenceProviderClassName(string);
                return;
            }
            if (ELEMENT_JTA_DATA_SOURCE.equals(localName)) {
                this.persistenceUnitInfo.setJtaDataSource(new DataSourceImpl(string, null, null, null));
                return;
            }
            if (ELEMENT_NON_JTA_DATA_SOURCE.equals(localName)) {
                this.persistenceUnitInfo.setNonJtaDataSource(new DataSourceImpl(string, null, null, null));
                return;
            }
            if (ELEMENT_MAPPING_FILE.equals(localName)) {
                this.persistenceUnitInfo.getMappingFileNames().add(string);
                return;
            }
            if (ELEMENT_JAR_FILE.equals(localName)) {
                this.persistenceUnitInfo.getJarFiles().add(string);
                return;
            }
            if (ELEMENT_CLASS.equals(localName)) {
                this.persistenceUnitInfo.getManagedClassNames().add(string);
                return;
            }
            if (ELEMENT_EXCLUDE_UNLISTED_CLASSES.equals(localName)) {
                if (string.equals("true") || string.equals("1")) {
                    this.persistenceUnitInfo.setExcludeUnlistedClasses(true);
                } else {
                    this.persistenceUnitInfo.setExcludeUnlistedClasses(false);
                }
                return;
            }
            if (ELEMENT_CACHING.equals(localName)) {
                this.persistenceUnitInfo.setSharedCacheMode(string);
            } else if (ELEMENT_VALIDATION_MODE.equals(localName)) {
                this.persistenceUnitInfo.setValidationMode(string);
            } else if (ELEMENT_PERSISTENCE_UNIT.equals(localName) && this.persistenceUnitInfo != null) {
                this.persistenceUnits.add(this.persistenceUnitInfo);
                this.persistenceUnitInfo = null;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.readCharacters) {
            this.stringBuffer.append(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }
}

