/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.ant.FileTask;
import com.vladium.emma.ant.SuppressableTask;
import com.vladium.emma.report.IReportEnums;
import com.vladium.emma.report.IReportProperties;
import com.vladium.emma.report.ReportCfg;
import com.vladium.emma.report.ReportProcessor;
import com.vladium.util.IProperties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public final class reportTask
extends FileTask
implements IReportProperties,
IReportEnums {
    private ReportCfg m_reportCfg;

    public reportTask(SuppressableTask parent) {
        super(parent);
    }

    public void init() throws BuildException {
        super.init();
        this.m_reportCfg = new ReportCfg(this.getProject(), this);
    }

    public void execute() throws BuildException {
        if (this.isEnabled()) {
            String[] reportTypes = this.m_reportCfg.getReportTypes();
            if (reportTypes == null || reportTypes.length == 0) {
                throw (BuildException)reportTask.newBuildException(this.getTaskName() + ": no report types specified: provide at least one of <txt>, <html>, <xml> nested elements", this.location).fillInStackTrace();
            }
            String[] files = this.getDataPath(true);
            if (files == null || files.length == 0) {
                throw (BuildException)reportTask.newBuildException(this.getTaskName() + ": no valid input data files have been specified", this.location).fillInStackTrace();
            }
            Path srcpath = this.m_reportCfg.getSourcepath();
            IProperties taskSettings = this.getTaskSettings();
            IProperties reportSettings = this.m_reportCfg.getReportSettings();
            IProperties settings = IProperties.Factory.combine((IProperties)reportSettings, (IProperties)taskSettings);
            ReportProcessor processor = ReportProcessor.create();
            processor.setDataPath(files);
            files = null;
            processor.setSourcePath(srcpath != null ? srcpath.list() : null);
            processor.setReportTypes(reportTypes);
            processor.setPropertyOverrides(settings);
            processor.run();
        }
    }

    public void setSourcepath(Path path) {
        this.m_reportCfg.setSourcepath(path);
    }

    public void setSourcepathRef(Reference ref) {
        this.m_reportCfg.setSourcepathRef(ref);
    }

    public Path createSourcepath() {
        return this.m_reportCfg.createSourcepath();
    }

    public ReportCfg.Element_TXT createTxt() {
        return this.m_reportCfg.createTxt();
    }

    public ReportCfg.Element_HTML createHtml() {
        return this.m_reportCfg.createHtml();
    }

    public ReportCfg.Element_XML createXml() {
        return this.m_reportCfg.createXml();
    }

    public void setUnits(IReportEnums.UnitsTypeAttribute units) {
        this.m_reportCfg.setUnits(units);
    }

    public void setDepth(IReportEnums.DepthAttribute depth) {
        this.m_reportCfg.setDepth(depth);
    }

    public void setColumns(String columns) {
        this.m_reportCfg.setColumns(columns);
    }

    public void setSort(String sort) {
        this.m_reportCfg.setSort(sort);
    }

    public void setMetrics(String metrics) {
        this.m_reportCfg.setMetrics(metrics);
    }

    public void setEncoding(String encoding) {
        this.m_reportCfg.setEncoding(encoding);
    }
}

