/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.metadata.ant.types.LogMetaDataInput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class TextLogMetaDataInput
extends LogMetaDataInput {
    private Logger log = Logger.getLogger(TextLogMetaDataInput.class);
    private int currentFileIndex;
    private int lineNumber;
    private BufferedReader currentReader;

    protected void setCurrentFileIndex(int fileIndex) {
        this.currentFileIndex = fileIndex;
    }

    protected void setLineNumber(int lineNo) {
        this.lineNumber = lineNo;
    }

    protected int getCurrentFileIndex() {
        return this.currentFileIndex;
    }

    protected int getLineNumber() {
        return this.lineNumber;
    }

    protected void setCurrentReader(BufferedReader reader) {
        this.currentReader = reader;
    }

    protected BufferedReader getCurrentReader() {
        return this.currentReader;
    }

    @Override
    public boolean isEntryAvailable() throws Exception {
        String exceptions = "";
        List<File> fileList = this.getFileList();
        int fileListSize = fileList.size();
        while (this.currentFileIndex < fileListSize) {
            try {
                File currentFile = fileList.get(this.currentFileIndex);
                if (this.currentReader == null) {
                    this.lineNumber = 0;
                    this.log.debug((Object)("Current Text log file name:" + currentFile));
                    this.log.info((Object)("Processing file: " + currentFile));
                    this.currentReader = new BufferedReader(new FileReader(currentFile));
                }
                String logText = null;
                while ((logText = this.currentReader.readLine()) != null) {
                    String severity = this.getSeverity(logText = logText.replaceFirst("^[ ]*\\[.+?\\][ ]*", ""));
                    if (severity != null) {
                        this.addEntry(severity, currentFile.getName(), currentFile.toString(), this.lineNumber, logText);
                        ++this.lineNumber;
                        return true;
                    }
                    ++this.lineNumber;
                }
                this.currentReader.close();
                this.currentReader = null;
                ++this.currentFileIndex;
            }
            catch (Exception ex) {
                this.log.debug((Object)"Exception in TextLogMetadata", (Throwable)ex);
                try {
                    this.currentReader.close();
                }
                catch (IOException iex) {
                    this.log.info((Object)"exception in closing reader");
                    this.log.debug((Object)"Exception in closing reader", (Throwable)iex);
                }
                this.currentReader = null;
                exceptions = exceptions + ex.getMessage() + "\n";
                return false;
            }
        }
        if (!exceptions.equals("")) {
            throw new Exception(exceptions);
        }
        return false;
    }
}

