/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.InternalClob;

final class ClobUpdatableReader
extends Reader {
    private Reader streamReader;
    private long pos;
    private long lastUpdateCount = -1L;
    private final EmbedClob clob;
    private InternalClob iClob;
    private final long maxPos;
    private volatile boolean closed = false;

    public ClobUpdatableReader(EmbedClob embedClob) throws IOException, SQLException {
        this(embedClob, 1L, Long.MAX_VALUE);
    }

    public ClobUpdatableReader(EmbedClob embedClob, long l, long l2) throws IOException, SQLException {
        this.clob = embedClob;
        this.iClob = embedClob.getInternalClob();
        this.pos = l;
        long l3 = l + l2;
        if (l3 < l2 || l3 < l) {
            l3 = Long.MAX_VALUE;
        }
        this.maxPos = l3;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        if (this.pos >= this.maxPos) {
            return -1;
        }
        this.updateReaderIfRequired();
        int n = this.streamReader.read();
        if (n > 0) {
            ++this.pos;
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        if (this.pos >= this.maxPos) {
            return -1;
        }
        this.updateReaderIfRequired();
        int n3 = (int)Math.min((long)n2, this.maxPos - this.pos);
        int n4 = this.streamReader.read(cArray, n, n3);
        if (n4 > 0) {
            this.pos += (long)n4;
        }
        return n4;
    }

    public long skip(long l) throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        if (this.pos >= this.maxPos) {
            return 0L;
        }
        this.updateReaderIfRequired();
        long l2 = Math.min(l, this.maxPos - this.pos);
        long l3 = this.streamReader.skip(l2);
        if (l3 > 0L) {
            this.pos += l3;
        }
        return l3;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.streamReader != null) {
                this.streamReader.close();
            }
        }
    }

    private void updateReaderIfRequired() throws IOException {
        if (this.iClob.isReleased()) {
            this.iClob = this.clob.getInternalClob();
            this.lastUpdateCount = -1L;
            if (this.iClob.isReleased()) {
                this.close();
                return;
            }
        }
        if (this.lastUpdateCount != this.iClob.getUpdateCount()) {
            this.lastUpdateCount = this.iClob.getUpdateCount();
            try {
                this.streamReader = this.iClob.getReader(this.pos);
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
    }
}

