/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.ExtendableItemHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlModuleDescriptorUpdater {
    private static final int MAX_HEADER_LENGTH = 10000;
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    private XmlModuleDescriptorUpdater() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(URL srcURL, File destFile, UpdateOptions options) throws IOException, SAXException {
        if (destFile.getParentFile() != null) {
            destFile.getParentFile().mkdirs();
        }
        FileOutputStream destStream = new FileOutputStream(destFile);
        try {
            XmlModuleDescriptorUpdater.update(srcURL, destStream, options);
        }
        finally {
            try {
                ((OutputStream)destStream).close();
            }
            catch (IOException e) {
                Message.warn("failed to close a stream : " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(URL srcURL, OutputStream destFile, UpdateOptions options) throws IOException, SAXException {
        InputStream in = srcURL.openStream();
        try {
            XmlModuleDescriptorUpdater.update(srcURL, in, destFile, options);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                Message.warn("failed to close a stream : " + e.toString());
            }
            try {
                destFile.close();
            }
            catch (IOException e) {
                Message.warn("failed to close a stream : " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(InputStream in, Resource res, File destFile, UpdateOptions options) throws IOException, SAXException {
        if (destFile.getParentFile() != null) {
            destFile.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(destFile);
        try {
            URL inputStreamContext = null;
            if (res instanceof URLResource) {
                inputStreamContext = ((URLResource)res).getURL();
            } else if (res instanceof FileResource) {
                inputStreamContext = ((FileResource)res).getFile().toURI().toURL();
            }
            XmlModuleDescriptorUpdater.update(inputStreamContext, in, fos, options);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                Message.warn("failed to close a stream : " + e.toString());
            }
            try {
                ((OutputStream)fos).close();
            }
            catch (IOException e) {
                Message.warn("failed to close a stream : " + e.toString());
            }
        }
    }

    public static void update(URL inStreamCtx, InputStream inStream, OutputStream outStream, UpdateOptions options) throws IOException, SAXException {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(outStream, "UTF-8"));
        BufferedInputStream in = new BufferedInputStream(inStream);
        in.mark(10000);
        XmlModuleDescriptorUpdater.copyHeader(in, out);
        in.reset();
        try {
            UpdaterHandler updaterHandler = new UpdaterHandler(inStreamCtx, out, options);
            InputSource inSrc = new InputSource(in);
            if (inStreamCtx != null) {
                inSrc.setSystemId(inStreamCtx.toExternalForm());
            }
            XMLHelper.parse(inSrc, null, (DefaultHandler)updaterHandler, (LexicalHandler)updaterHandler);
        }
        catch (ParserConfigurationException e) {
            IllegalStateException ise = new IllegalStateException("impossible to update Ivy files: parser problem");
            ise.initCause(e);
            throw ise;
        }
    }

    private static void copyHeader(InputStream in, PrintWriter out) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        String line = r.readLine();
        if (line != null && line.startsWith("<?xml ")) {
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            line = line.substring(line.indexOf(">") + 1, line.length());
        }
        while (line != null) {
            int index = line.indexOf("<ivy-module");
            if (index != -1) {
                out.write(line.substring(0, index));
                break;
            }
            out.write(line);
            out.write(LINE_SEPARATOR);
            line = r.readLine();
        }
    }

    private static class ExtendedBuffer {
        private String context = null;
        private Boolean print = null;
        private boolean defaultPrint = false;
        private StringBuffer buffer = new StringBuffer();

        ExtendedBuffer(String context) {
            this.context = context;
        }

        boolean isPrint() {
            if (this.print == null) {
                return this.defaultPrint;
            }
            return this.print;
        }

        void setPrint(boolean print) {
            this.print = print;
        }

        void setDefaultPrint(boolean print) {
            this.defaultPrint = print;
        }

        StringBuffer getBuffer() {
            return this.buffer;
        }

        String getContext() {
            return this.context;
        }
    }

    private static class UpdaterHandler
    extends DefaultHandler
    implements LexicalHandler {
        private final ParserSettings settings;
        private final PrintWriter out;
        private final Map resolvedRevisions;
        private final String status;
        private final String revision;
        private final Date pubdate;
        private final Namespace ns;
        private final boolean replaceInclude;
        private final boolean generateRevConstraint;
        private boolean inHeader = true;
        private final List confs;
        private final URL relativePathCtx;
        private final UpdateOptions options;
        private String organisation = null;
        private String defaultConfMapping = null;
        private Boolean confMappingOverride = null;
        private String justOpen = null;
        private Stack context = new Stack();
        private Stack buffers = new Stack();
        private Stack confAttributeBuffers = new Stack();

        public UpdaterHandler(URL relativePathCtx, PrintWriter out, UpdateOptions options) {
            this.options = options;
            this.settings = options.getSettings();
            this.out = out;
            this.resolvedRevisions = options.getResolvedRevisions();
            this.status = options.getStatus();
            this.revision = options.getRevision();
            this.pubdate = options.getPubdate();
            this.ns = options.getNamespace();
            this.replaceInclude = options.isReplaceInclude();
            this.generateRevConstraint = options.isGenerateRevConstraint();
            this.relativePathCtx = relativePathCtx;
            this.confs = options.getConfsToExclude() != null ? Arrays.asList(options.getConfsToExclude()) : Collections.EMPTY_LIST;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.inHeader = false;
            if (this.justOpen != null) {
                this.write(">");
            }
            this.context.push(qName);
            if ("info".equals(qName)) {
                this.infoStarted(attributes);
            } else if (this.replaceInclude && "include".equals(qName) && this.context.contains("configurations")) {
                this.includeStarted(attributes);
            } else if ("ivy-module/dependencies/dependency".equals(this.getContext())) {
                this.startElementInDependency(attributes);
            } else if ("dependencies".equals(qName)) {
                this.startDependencies(attributes);
            } else if ("ivy-module/configurations/conf".equals(this.getContext())) {
                this.startElementInConfigurationsConf(qName, attributes);
            } else if ("ivy-module/publications/artifact/conf".equals(this.getContext()) || "ivy-module/dependencies/dependency/conf".equals(this.getContext()) || "ivy-module/dependencies/dependency/artifact/conf".equals(this.getContext())) {
                this.buffers.push(new ExtendedBuffer(this.getContext()));
                ((ExtendedBuffer)this.confAttributeBuffers.peek()).setDefaultPrint(false);
                String confName = this.substitute(this.settings, attributes.getValue("name"));
                if (!this.confs.contains(confName)) {
                    ((ExtendedBuffer)this.confAttributeBuffers.peek()).setPrint(true);
                    ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                    this.write("<" + qName);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                    }
                }
            } else if ("ivy-module/publications/artifact".equals(this.getContext()) || "ivy-module/dependencies/dependency/artifact".equals(this.getContext())) {
                ExtendedBuffer buffer = new ExtendedBuffer(this.getContext());
                this.buffers.push(buffer);
                this.confAttributeBuffers.push(buffer);
                this.write("<" + qName);
                buffer.setDefaultPrint(attributes.getValue("conf") == null);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attName = attributes.getQName(i);
                    if ("conf".equals(attName)) {
                        String confName = this.substitute(this.settings, attributes.getValue("conf"));
                        String newConf = this.removeConfigurationsFromList(confName, this.confs);
                        if (newConf.length() <= 0) continue;
                        this.write(" " + attributes.getQName(i) + "=\"" + newConf + "\"");
                        ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                        continue;
                    }
                    this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            } else {
                this.write("<" + qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            }
            this.justOpen = qName;
        }

        private void startElementInConfigurationsConf(String qName, Attributes attributes) {
            this.buffers.push(new ExtendedBuffer(this.getContext()));
            String confName = this.substitute(this.settings, attributes.getValue("name"));
            if (!this.confs.contains(confName)) {
                ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                String extend = this.substitute(this.settings, attributes.getValue("extends"));
                if (extend != null) {
                    StringTokenizer tok = new StringTokenizer(extend, ", ");
                    while (tok.hasMoreTokens()) {
                        String current = tok.nextToken();
                        if (!this.confs.contains(current)) continue;
                        throw new IllegalArgumentException("Cannot exclude a configuration which is extended.");
                    }
                }
                this.write("<" + qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            }
        }

        private void startDependencies(Attributes attributes) {
            String newMapping;
            this.write("<dependencies");
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getQName(i);
                if ("defaultconfmapping".equals(attName)) {
                    String newMapping2 = this.removeConfigurationsFromMapping(this.substitute(this.settings, attributes.getValue("defaultconfmapping")), this.confs);
                    if (newMapping2.length() <= 0) continue;
                    this.write(" " + attributes.getQName(i) + "=\"" + newMapping2 + "\"");
                    continue;
                }
                this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
            }
            if (this.defaultConfMapping != null && attributes.getValue("defaultconfmapping") == null && (newMapping = this.removeConfigurationsFromMapping(this.defaultConfMapping, this.confs)).length() > 0) {
                this.write(" defaultconfmapping=\"" + newMapping + "\"");
            }
            if (this.confMappingOverride != null && attributes.getValue("confmappingoverride") == null) {
                this.write(" confmappingoverride=\"" + this.confMappingOverride.toString() + "\"");
            }
        }

        private void startElementInDependency(Attributes attributes) {
            ExtendedBuffer buffer = new ExtendedBuffer(this.getContext());
            this.buffers.push(buffer);
            this.confAttributeBuffers.push(buffer);
            buffer.setDefaultPrint(attributes.getValue("conf") == null || attributes.getValue("conf").trim().length() == 0);
            this.write("<dependency");
            String org = this.substitute(this.settings, attributes.getValue("org"));
            org = org == null ? this.organisation : org;
            String module = this.substitute(this.settings, attributes.getValue("name"));
            String branch = this.substitute(this.settings, attributes.getValue("branch"));
            String branchConstraint = this.substitute(this.settings, attributes.getValue("branchConstraint"));
            String string = branchConstraint = branchConstraint == null ? branch : branchConstraint;
            if (branch == null) {
                ModuleId mid = ModuleId.newInstance(org, module);
                if (this.ns != null) {
                    mid = NameSpaceHelper.transform(mid, this.ns.getToSystemTransformer());
                }
                Iterator iter = this.resolvedRevisions.keySet().iterator();
                while (iter.hasNext()) {
                    ModuleRevisionId mrid = (ModuleRevisionId)iter.next();
                    if (!mrid.getModuleId().equals(mid)) continue;
                    branch = mrid.getBranch();
                    break;
                }
            }
            String revision = this.substitute(this.settings, attributes.getValue("rev"));
            String revisionConstraint = this.substitute(this.settings, attributes.getValue("revConstraint"));
            Map extraAttributes = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, XmlModuleDescriptorParser.DEPENDENCY_REGULAR_ATTRIBUTES);
            ModuleRevisionId localMrid = ModuleRevisionId.newInstance(org, module, branch, revision, extraAttributes);
            ModuleRevisionId systemMrid = this.ns == null ? localMrid : this.ns.getToSystemTransformer().transform(localMrid);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getQName(i);
                if ("rev".equals(attName)) {
                    String rev = (String)this.resolvedRevisions.get(systemMrid);
                    if (rev != null) {
                        this.write(" rev=\"" + rev + "\"");
                        if (attributes.getIndex("branchConstraint") == -1 && branchConstraint != null) {
                            this.write(" branchConstraint=\"" + branchConstraint + "\"");
                        }
                        if (!this.generateRevConstraint || attributes.getIndex("revConstraint") != -1 || rev.equals(systemMrid.getRevision())) continue;
                        this.write(" revConstraint=\"" + systemMrid.getRevision() + "\"");
                        continue;
                    }
                    this.write(" rev=\"" + systemMrid.getRevision() + "\"");
                    continue;
                }
                if ("revConstraint".equals(attName)) {
                    this.write(" revConstraint=\"" + revisionConstraint + "\"");
                    continue;
                }
                if ("org".equals(attName)) {
                    this.write(" org=\"" + systemMrid.getOrganisation() + "\"");
                    continue;
                }
                if ("name".equals(attName)) {
                    this.write(" name=\"" + systemMrid.getName() + "\"");
                    continue;
                }
                if ("branch".equals(attName)) {
                    this.write(" branch=\"" + systemMrid.getBranch() + "\"");
                    continue;
                }
                if ("branchConstraint".equals(attName)) {
                    this.write(" branchConstraint=\"" + branchConstraint + "\"");
                    continue;
                }
                if ("conf".equals(attName)) {
                    String newMapping;
                    String oldMapping = this.substitute(this.settings, attributes.getValue("conf"));
                    if (oldMapping.length() <= 0 || (newMapping = this.removeConfigurationsFromMapping(oldMapping, this.confs)).length() <= 0) continue;
                    this.write(" conf=\"" + newMapping + "\"");
                    ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                    continue;
                }
                this.write(" " + attName + "=\"" + this.substitute(this.settings, attributes.getValue(attName)) + "\"");
            }
            if (this.options.isUpdateBranch() && systemMrid.getBranch() != null && attributes.getIndex("branch") == -1) {
                this.write(" branch=\"" + systemMrid.getBranch() + "\"");
            }
        }

        private void includeStarted(Attributes attributes) throws SAXException {
            final ExtendedBuffer buffer = new ExtendedBuffer(this.getContext());
            this.buffers.push(buffer);
            try {
                URL url;
                if (this.settings != null) {
                    url = this.settings.getRelativeUrlResolver().getURL(this.relativePathCtx, this.settings.substitute(attributes.getValue("file")), this.settings.substitute(attributes.getValue("url")));
                } else {
                    String fileName = attributes.getValue("file");
                    if (fileName == null) {
                        String urlStr = attributes.getValue("url");
                        url = new URL(urlStr);
                    } else {
                        url = Checks.checkAbsolute(fileName, "settings.include").toURI().toURL();
                    }
                }
                XMLHelper.parse(url, null, new DefaultHandler(){
                    private boolean insideConfigurations = false;
                    private boolean doIndent = false;

                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if ("configurations".equals(qName)) {
                            String mappingOverride;
                            this.insideConfigurations = true;
                            String defaultconf = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("defaultconfmapping"));
                            if (defaultconf != null) {
                                UpdaterHandler.this.defaultConfMapping = defaultconf;
                            }
                            if ((mappingOverride = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("confmappingoverride"))) != null) {
                                UpdaterHandler.this.confMappingOverride = Boolean.valueOf(mappingOverride);
                            }
                        } else if ("conf".equals(qName) && this.insideConfigurations) {
                            String confName = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("name"));
                            if (!UpdaterHandler.this.confs.contains(confName)) {
                                String extend;
                                buffer.setPrint(true);
                                if (this.doIndent) {
                                    UpdaterHandler.this.write("/>\n\t\t");
                                }
                                if ((extend = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("extends"))) != null) {
                                    StringTokenizer tok = new StringTokenizer(extend, ", ");
                                    while (tok.hasMoreTokens()) {
                                        String current = tok.nextToken();
                                        if (!UpdaterHandler.this.confs.contains(current)) continue;
                                        throw new IllegalArgumentException("Cannot exclude a configuration which is extended.");
                                    }
                                }
                                UpdaterHandler.this.write("<" + qName);
                                for (int i = 0; i < attributes.getLength(); ++i) {
                                    UpdaterHandler.this.write(" " + attributes.getQName(i) + "=\"" + UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue(i)) + "\"");
                                }
                                this.doIndent = true;
                            }
                        }
                    }

                    public void endElement(String uri, String localName, String name) throws SAXException {
                        if ("configurations".equals(name)) {
                            this.insideConfigurations = false;
                        }
                    }
                });
            }
            catch (Exception e) {
                Message.warn("exception occured while importing configurations: " + e.getMessage());
                throw new SAXException(e);
            }
        }

        private void infoStarted(Attributes attributes) {
            String branch;
            this.organisation = this.substitute(this.settings, attributes.getValue("organisation"));
            String module = this.substitute(this.settings, attributes.getValue("module"));
            String rev = this.revision;
            if (rev == null) {
                rev = this.substitute(this.settings, attributes.getValue("revision"));
            }
            if ((branch = this.options.getBranch()) == null) {
                branch = this.substitute(this.settings, attributes.getValue("branch"));
            }
            ModuleRevisionId localMid = ModuleRevisionId.newInstance(this.organisation, module, branch, rev, ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"organisation", "module", "revision", "status", "publication", "namespace"}));
            ModuleRevisionId systemMid = this.ns == null ? localMid : this.ns.getToSystemTransformer().transform(localMid);
            this.write("<info organisation=\"" + XMLHelper.escape(systemMid.getOrganisation()) + "\" module=\"" + XMLHelper.escape(systemMid.getName()) + "\"");
            if (branch != null) {
                this.write(" branch=\"" + XMLHelper.escape(systemMid.getBranch()) + "\"");
            }
            if (systemMid.getRevision() != null) {
                this.write(" revision=\"" + XMLHelper.escape(systemMid.getRevision()) + "\"");
            }
            if (this.status != null) {
                this.write(" status=\"" + XMLHelper.escape(this.status) + "\"");
            } else {
                this.write(" status=\"" + this.substitute(this.settings, attributes.getValue("status")) + "\"");
            }
            if (this.pubdate != null) {
                this.write(" publication=\"" + Ivy.DATE_FORMAT.format(this.pubdate) + "\"");
            } else if (attributes.getValue("publication") != null) {
                this.write(" publication=\"" + this.substitute(this.settings, attributes.getValue("publication")) + "\"");
            }
            List<String> stdAtts = Arrays.asList("organisation", "module", "branch", "revision", "status", "publication", "namespace");
            if (attributes.getValue("namespace") != null) {
                this.write(" namespace=\"" + this.substitute(this.settings, attributes.getValue("namespace")) + "\"");
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (stdAtts.contains(attributes.getQName(i))) continue;
                this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
            }
        }

        private void write(String content) {
            if (this.buffers.isEmpty()) {
                this.out.print(content);
            } else {
                ExtendedBuffer buffer = (ExtendedBuffer)this.buffers.peek();
                buffer.getBuffer().append(content);
            }
        }

        private String getContext() {
            StringBuffer buf = new StringBuffer();
            Iterator iter = this.context.iterator();
            while (iter.hasNext()) {
                String ctx = (String)iter.next();
                buf.append(ctx).append("/");
            }
            if (buf.length() > 0) {
                buf.setLength(buf.length() - 1);
            }
            return buf.toString();
        }

        private String substitute(ParserSettings ivy, String value) {
            String result = ivy == null ? value : ivy.substitute(value);
            return XMLHelper.escape(result);
        }

        private String removeConfigurationsFromMapping(String mapping, List confsToRemove) {
            StringBuffer newMapping = new StringBuffer();
            String mappingSep = "";
            StringTokenizer tokenizer = new StringTokenizer(mapping, ";");
            while (tokenizer.hasMoreTokens()) {
                String current = tokenizer.nextToken();
                String[] ops = current.split("->");
                String[] lhs = ops[0].split(",");
                ArrayList<String> confsToWrite = new ArrayList<String>();
                for (int j = 0; j < lhs.length; ++j) {
                    if (this.confs.contains(lhs[j].trim())) continue;
                    confsToWrite.add(lhs[j]);
                }
                if (confsToWrite.isEmpty()) continue;
                newMapping.append(mappingSep);
                String sep = "";
                Iterator it = confsToWrite.iterator();
                while (it.hasNext()) {
                    newMapping.append(sep);
                    newMapping.append(it.next());
                    sep = ",";
                }
                if (ops.length == 2) {
                    newMapping.append("->");
                    newMapping.append(ops[1]);
                }
                mappingSep = ";";
            }
            return newMapping.toString();
        }

        private String removeConfigurationsFromList(String list, List confsToRemove) {
            StringBuffer newList = new StringBuffer();
            String listSep = "";
            StringTokenizer tokenizer = new StringTokenizer(list, ",");
            while (tokenizer.hasMoreTokens()) {
                String current = tokenizer.nextToken();
                if (confsToRemove.contains(current.trim())) continue;
                newList.append(listSep);
                newList.append(current);
                listSep = ",";
            }
            return newList.toString();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.justOpen != null) {
                this.write(">");
                this.justOpen = null;
            }
            this.write(String.valueOf(ch, start, length));
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            ExtendedBuffer buffer;
            if (qName.equals(this.justOpen)) {
                this.write("/>");
            } else {
                this.write("</" + qName + ">");
            }
            if (!this.buffers.isEmpty() && (buffer = (ExtendedBuffer)this.buffers.peek()).getContext().equals(this.getContext())) {
                this.buffers.pop();
                if (buffer.isPrint()) {
                    this.write(buffer.getBuffer().toString());
                }
            }
            if (!this.confAttributeBuffers.isEmpty() && (buffer = (ExtendedBuffer)this.confAttributeBuffers.peek()).getContext().equals(this.getContext())) {
                this.confAttributeBuffers.pop();
            }
            this.justOpen = null;
            this.context.pop();
        }

        public void endDocument() throws SAXException {
            this.out.print(LINE_SEPARATOR);
            this.out.flush();
            this.out.close();
        }

        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void endCDATA() throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.justOpen != null) {
                this.write(">");
                this.justOpen = null;
            }
            if (!this.inHeader) {
                StringBuffer comment = new StringBuffer();
                comment.append(ch, start, length);
                this.write("<!--");
                this.write(comment.toString());
                this.write("-->");
            }
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }
    }
}

