/*
 * Decompiled with CFR 0.152.
 */
package fmpp;

import fmpp.DataModelBuildingException;
import fmpp.Engine;
import fmpp.FmppOutputWriter;
import fmpp.LocalDataBuilder;
import fmpp.TemplateDataModelBuilder;
import fmpp.models.AddTransform;
import fmpp.models.ClearTransform;
import fmpp.models.CopyWritableVariableMethod;
import fmpp.models.NewWritableHashMethod;
import fmpp.models.NewWritableSequenceMethod;
import fmpp.models.RemoveTransform;
import fmpp.models.SetTransform;
import fmpp.models.TemplateModelUtils;
import fmpp.models.WritableHash;
import fmpp.tdd.DataLoader;
import fmpp.tdd.EvalException;
import fmpp.tdd.TddUtil;
import fmpp.util.FileUtil;
import fmpp.util.FreemarkerUtil;
import fmpp.util.StringUtil;
import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateTransformModel;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TemplateEnvironment {
    private static final ThreadLocal THREAD_LOCAL = new ThreadLocal();
    private final Engine eng;
    private final PPHash ppHash = new PPHash();
    private boolean externallyAccessible;
    private String ppOpDenialMessage;
    private FmppOutputWriter outputWriter;
    private File srcFile;
    private Template template;
    private Environment fmEnv;
    private Map localData;
    private Object xmlDocument;
    private TemplateNodeModel wrappedXmlDocument;

    TemplateEnvironment(Engine engine) {
        this.eng = engine;
        this.ppHash.put("changeOutputFile", (TemplateModel)new ChangeOutputFileTransform());
        this.ppHash.put("renameOutputFile", (TemplateModel)new RenameOutputFileTransform());
        this.ppHash.put("dropOutputFile", (TemplateModel)new DropOutputFileTransform());
        this.ppHash.put("restartOutputFile", (TemplateModel)new RestartOutputFileTransform());
        this.ppHash.put("nestOutputFile", (TemplateModel)new NestOutputFileTransform());
        this.ppHash.put("setOutputEncoding", (TemplateModel)new SetOutputEncodingTransform());
        this.ppHash.put("ignoreOutput", (TemplateModel)new IgnoreOutputTransform());
        this.ppHash.put("warning", (TemplateModel)new WarningTransform());
        this.ppHash.put("set", (TemplateModel)new SetTransform());
        this.ppHash.put("add", (TemplateModel)new AddTransform());
        this.ppHash.put("remove", (TemplateModel)new RemoveTransform());
        this.ppHash.put("clear", (TemplateModel)new ClearTransform());
        this.ppHash.put("realFileSize", (TemplateModel)new RealFileSizeMethod());
        this.ppHash.put("realFileLastModified", (TemplateModel)new RealFileLastModifiedMethod());
        this.ppHash.put("realFileExists", (TemplateModel)new RealFileExistsMethod());
        this.ppHash.put("sourceFileSize", (TemplateModel)new SourceFileSizeMethod());
        this.ppHash.put("sourceFileLastModified", (TemplateModel)new SourceFileLastModifiedMethod());
        this.ppHash.put("sourceFileExists", (TemplateModel)new SourceFileExistsMethod());
        this.ppHash.put("outputFileSize", (TemplateModel)new OutputFileSizeMethod());
        this.ppHash.put("outputFileLastModified", (TemplateModel)new OutputFileLastModifiedMethod());
        this.ppHash.put("outputFileExists", (TemplateModel)new OutputFileExistsMethod());
        this.ppHash.put("urlEnc", (TemplateModel)new UrlEncodeMethod());
        this.ppHash.put("urlPathEnc", (TemplateModel)new UrlPathEncodeMethod());
        this.ppHash.put("sourceRootRelativePath", (TemplateModel)new ToSourceRootRelativePathMethod());
        this.ppHash.put("outputRootRelativePath", (TemplateModel)new ToOutputRootRelativePathMethod());
        this.ppHash.put("pathTo", (TemplateModel)new PathToMethod());
        this.ppHash.put("sourcePathTo", (TemplateModel)new PathToSourceMethod());
        this.ppHash.put("newWritableSequence", (TemplateModel)new NewWritableSequenceMethod());
        this.ppHash.put("newWritableHash", (TemplateModel)new NewWritableHashMethod());
        this.ppHash.put("copyWritable", (TemplateModel)new CopyWritableVariableMethod());
        this.ppHash.put("loadData", (TemplateModel)new LoadDataMethod());
        this.ppHash.put("slash", File.separator);
        this.ppHash.put("version", Engine.getVersionNumber());
        this.ppHash.put("freemarkerVersion", Engine.getFreeMarkerVersionNumber());
        this.ppHash.put("outputFile", (TemplateModel)new OutputFileMethod());
        this.ppHash.put("outputDirectory", (TemplateModel)new OutputDirectoryMethod());
        this.ppHash.put("outputFileName", (TemplateModel)new OutputFileNameMethod());
        this.ppHash.put("realOutput", (TemplateModel)new RealOutputMethod());
        this.ppHash.put("realOutputDirectory", (TemplateModel)new RealOutputDirectoryMethod());
        this.ppHash.put("outputEncoding", (TemplateModel)new OutputEncodingMethod());
        this.ppHash.put("home", (TemplateModel)new HomeScalar());
        this.ppHash.put("locale", (TemplateModel)new LocaleMethod());
        this.ppHash.put("now", (TemplateModel)new NowScalar());
        this.ppHash.put("doc", (TemplateModel)new DocScalar());
    }

    public static TemplateEnvironment getCurrentInstance() {
        return (TemplateEnvironment)THREAD_LOCAL.get();
    }

    public Environment getFreemarkerEnvironment() {
        if (this.fmEnv == null) {
            throw new IllegalStateException("The FreeMarker environment is not available, because the template is not executing.");
        }
        return this.fmEnv;
    }

    public Engine getEngine() {
        return this.eng;
    }

    public Object getXmlDocument() {
        return this.xmlDocument;
    }

    public TemplateNodeModel getWrappedXmlDocument() {
        return this.wrappedXmlDocument;
    }

    public Object getData(String name) {
        Object o = this.localData.get(name);
        return o == null ? this.eng.getData(name) : o;
    }

    public File getSourceFile() {
        return this.srcFile;
    }

    public Template getTemplate() {
        return this.template;
    }

    public File getOutputFile() throws IOException {
        return this.outputWriter.getOutputFile();
    }

    public String getHomePath() throws IOException {
        File d = this.outputWriter.getOutputFile().getParentFile();
        File r = this.eng.getOutputRoot();
        String home = "";
        while (!d.equals(r)) {
            home = home + "../";
            d = d.getParentFile();
        }
        return home;
    }

    public String getOutputEncoding() throws IOException {
        return this.outputWriter.getOutputEncoding();
    }

    public void changeOutputFile(String name) throws IOException {
        this.checkPpOpsAllowed();
        this.outputWriter.changeOutputFile(name, false);
    }

    public void changeOutputFile(String name, boolean append) throws IOException {
        this.checkPpOpsAllowed();
        this.outputWriter.changeOutputFile(name, append);
    }

    public void renameOutputFile(String name) throws IOException {
        this.checkPpOpsAllowed();
        this.outputWriter.renameOutputFile(name);
    }

    public void dropOutputFile() throws IOException {
        this.checkPpOpsAllowed();
        this.outputWriter.dropOutputFile();
    }

    public void restartOutputFile() throws IOException {
        this.checkPpOpsAllowed();
        this.outputWriter.restartOutputFile();
    }

    public void beginNestedOutputFile(String name) throws IOException {
        this.checkPpOpsAllowed();
        this.outputWriter.nestOutputFileBegin(name, false);
    }

    public void beginNestedOutputFile(String name, boolean append) throws IOException {
        this.checkPpOpsAllowed();
        this.outputWriter.nestOutputFileBegin(name, append);
    }

    public void endNestedOutputFile() throws IOException {
        this.checkPpOpsAllowed();
        this.outputWriter.nestOutputFileEnd(false);
    }

    public void setOutputEncoding(String encoding) throws IOException {
        this.checkPpOpsAllowed();
        this.outputWriter.setOutputEncoding(encoding);
        this.fmEnv.setOutputEncoding(this.outputWriter.getOutputEncoding());
    }

    public void warning(String message) {
        this.eng.sendWarning(this.srcFile, message);
    }

    public File resolveSourcePath(String path) throws IOException {
        path = FileUtil.pathToUnixStyle(path);
        return FileUtil.resolveRelativeUnixPath(this.eng.getSourceRoot(), this.srcFile.getParentFile(), path);
    }

    public File resolveOutputPath(String path) throws IOException {
        path = FileUtil.pathToUnixStyle(path);
        return FileUtil.resolveRelativeUnixPath(this.eng.getOutputRoot(), this.getOutputFile().getParentFile(), path);
    }

    public String toSourceRootRelativePath(String path) throws IOException {
        File f = this.resolveSourcePath(path);
        return FileUtil.pathToUnixStyle(FileUtil.getRelativePath(this.eng.getSourceRoot(), f));
    }

    public String toSourceRootRelativePath(File f) throws IOException {
        return FileUtil.pathToUnixStyle(FileUtil.getRelativePath(this.eng.getSourceRoot(), f));
    }

    public String toOutputRelatitvePath(String path) throws IOException {
        File f = this.resolveOutputPath(path);
        return FileUtil.pathToUnixStyle(FileUtil.getRelativePath(this.eng.getOutputRoot(), f));
    }

    public String toOutputRootRelativePath(File f) throws IOException {
        return FileUtil.pathToUnixStyle(FileUtil.getRelativePath(this.eng.getOutputRoot(), f));
    }

    public String getPathTo(String dst) throws IOException {
        boolean slashEnd = dst.endsWith("/") || dst.endsWith(File.separator);
        File f = this.resolveOutputPath(dst);
        String res = FileUtil.pathToUnixStyle(FileUtil.getRelativePath(this.getOutputFile().getParentFile(), f));
        if (res.endsWith("/")) {
            res = res.substring(0, res.length() - 1);
        }
        return slashEnd && res.length() != 0 ? res + "/" : res;
    }

    public String getSourcePathTo(String dst) throws IOException {
        boolean slashEnd = dst.endsWith("/") || dst.endsWith(File.separator);
        File f = this.resolveSourcePath(dst);
        String res = FileUtil.pathToUnixStyle(FileUtil.getRelativePath(this.srcFile.getParentFile(), f));
        if (res.endsWith("/")) {
            res = res.substring(0, res.length() - 1);
        }
        return slashEnd && res.length() != 0 ? res + "/" : res;
    }

    boolean isExternallyAccessible() {
        return this.externallyAccessible;
    }

    void setupForSession() {
        this.ppHash.put("s", new WritableHash());
        this.ppHash.put("sessionStart", (TemplateModel)new SimpleDate(new Date(), 3));
    }

    void cleanAfterSession() {
        this.ppHash.remove("s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(Template template, FmppOutputWriter out, File srcFile, Object xmlDocument, TemplateNodeModel wrappedXmlDocument, List xmlldbs) throws DataModelBuildingException, TemplateException, IOException {
        try {
            Map builtData;
            int i;
            this.outputWriter = out;
            this.srcFile = srcFile;
            this.template = template;
            this.xmlDocument = xmlDocument;
            this.wrappedXmlDocument = wrappedXmlDocument;
            this.localData = new HashMap();
            this.ppHash.put("sourceRoot", TemplateEnvironment.fixedDirPath(this.eng.getSourceRoot()));
            this.ppHash.put("outputRoot", TemplateEnvironment.fixedDirPath(this.eng.getOutputRoot()));
            this.ppHash.put("realSource", TemplateEnvironment.fixedFilePath(srcFile));
            this.ppHash.put("sourceFile", FileUtil.pathToUnixStyle(FileUtil.getRelativePath(this.eng.getSourceRoot(), srcFile)));
            this.ppHash.put("sourceFileName", srcFile.getName());
            this.ppHash.put("realSourceDirectory", TemplateEnvironment.fixedDirPath(srcFile.getParentFile()));
            this.ppHash.put("sourceDirectory", FileUtil.pathToUnixStyle(TemplateEnvironment.fixedDirPath(FileUtil.getRelativePath(this.eng.getSourceRoot(), srcFile.getParentFile()))));
            this.ppHash.put("sourceEncoding", template.getEncoding());
            this.ppOpDenialMessage = "You are not allowed to do this operation while building the local data model.";
            List ldbs = this.eng.getLocalDataBuildersForFile(srcFile);
            int ln = ldbs.size();
            for (i = ln - 1; i >= 0; --i) {
                LocalDataBuilder ldb = (LocalDataBuilder)ldbs.get(i);
                try {
                    builtData = ldb.build(this.eng, this);
                }
                catch (Throwable e) {
                    throw new DataModelBuildingException("Failed to build local data.", e);
                }
                if (builtData == null) continue;
                this.localData.putAll(builtData);
            }
            if (xmlldbs != null) {
                ln = xmlldbs.size();
                for (i = 0; i < ln; ++i) {
                    try {
                        builtData = ((LocalDataBuilder)xmlldbs.get(i)).build(this.eng, this);
                    }
                    catch (Throwable e) {
                        throw new DataModelBuildingException("Failed to build local data with the local data builder specified by the XML rendering configuration.", e);
                    }
                    if (builtData == null) continue;
                    this.localData.putAll(builtData);
                }
            }
            Object lastThreadLocal = THREAD_LOCAL.get();
            THREAD_LOCAL.set(this);
            try {
                this.externallyAccessible = true;
                try {
                    TemplateDataModelBuilder tdmBuilder = this.eng.getTemplateDataModelBuilder();
                    if (tdmBuilder != null) {
                        Map td;
                        try {
                            td = tdmBuilder.build(this.eng, template, srcFile);
                        }
                        catch (Throwable e) {
                            throw new DataModelBuildingException("Failed to build template specific data. (at builder of class " + tdmBuilder.getClass().getName() + ")", e);
                        }
                        if (td != null) {
                            this.localData.putAll(td);
                        }
                    }
                    this.localData.put("pp", this.ppHash);
                    this.ppOpDenialMessage = null;
                    this.fmEnv = template.createProcessingEnvironment((Object)this.localData, (Writer)this.outputWriter);
                    this.fmEnv.setOutputEncoding(this.outputWriter.getOutputEncoding());
                    this.fmEnv.process();
                }
                finally {
                    this.externallyAccessible = false;
                }
            }
            finally {
                THREAD_LOCAL.set(lastThreadLocal);
            }
        }
        finally {
            this.execute_clean();
        }
    }

    private void execute_clean() {
        this.outputWriter = null;
        this.srcFile = null;
        this.template = null;
        this.fmEnv = null;
        this.localData = null;
        this.xmlDocument = null;
        this.wrappedXmlDocument = null;
    }

    private void checkPpOpsAllowed() {
        if (this.ppOpDenialMessage != null) {
            throw new IllegalStateException(this.ppOpDenialMessage);
        }
    }

    private String getCurrentUrlEncodingCharset() {
        String s = this.fmEnv.getURLEscapingCharset();
        return s != null ? s : this.fmEnv.getOutputEncoding();
    }

    private static String fixedFilePath(File f) throws IOException {
        return f.getCanonicalPath();
    }

    private static String fixedDirPath(File f) throws IOException {
        return TemplateEnvironment.fixedDirPath(f.getCanonicalPath());
    }

    private static String fixedDirPath(String s) throws IOException {
        if (s.length() > 0 && !s.endsWith(File.separator) && !s.endsWith("/")) {
            s = s + File.separator;
        }
        return s;
    }

    private class LoadDataMethod
    implements TemplateMethodModelEx {
        private LoadDataMethod() {
        }

        public Object exec(List args) throws TemplateModelException {
            DataLoader dl;
            int ln = args.size();
            if (ln < 1) {
                throw new TemplateModelException("loadData needs at least 1 argument");
            }
            Object o = args.get(0);
            if (!(o instanceof TemplateScalarModel)) {
                throw new TemplateModelException("The first argument to loadData must be a string");
            }
            ArrayList<Object> args2 = new ArrayList<Object>(ln - 1);
            for (int i = 1; i < ln; ++i) {
                args2.add(FreemarkerUtil.ftlVarToCoreJavaObject((TemplateModel)args.get(i)));
            }
            String dlName = ((TemplateScalarModel)o).getAsString();
            try {
                dl = TddUtil.getDataLoaderInstance(TemplateEnvironment.this.eng, dlName);
            }
            catch (EvalException e) {
                throw new TemplateModelException("Failed to get data loader.", (Exception)e);
            }
            try {
                return TemplateEnvironment.this.eng.wrap(dl.load(TemplateEnvironment.this.eng, args2));
            }
            catch (Exception exc) {
                throw new TemplateModelException("Error runing data loader " + StringUtil.jQuote(dlName) + ".", exc);
            }
        }
    }

    private class LocaleMethod
    extends LiveString {
        private LocaleMethod() {
        }

        String getName() {
            return "locale";
        }

        String getStringValue() {
            return Environment.getCurrentEnvironment().getLocale().toString();
        }
    }

    private class DocScalar
    extends LiveScalar {
        private DocScalar() {
        }

        String getName() {
            return "doc";
        }

        TemplateModel getValue() {
            return TemplateEnvironment.this.wrappedXmlDocument;
        }
    }

    private class NowScalar
    extends LiveScalar {
        private NowScalar() {
        }

        String getName() {
            return "now";
        }

        TemplateModel getValue() {
            return new SimpleDate(new Date(), 3);
        }
    }

    private class HomeScalar
    extends LiveString {
        private HomeScalar() {
        }

        String getName() {
            return "home";
        }

        String getStringValue() throws IOException {
            return TemplateEnvironment.this.getHomePath();
        }
    }

    private class OutputFileNameMethod
    extends LiveString {
        private OutputFileNameMethod() {
        }

        String getName() {
            return "outputFile";
        }

        String getStringValue() {
            return TemplateEnvironment.this.outputWriter.getOutputFile().getName();
        }
    }

    private class OutputDirectoryMethod
    extends LiveString {
        private OutputDirectoryMethod() {
        }

        String getName() {
            return "outputDirectory";
        }

        String getStringValue() throws IOException {
            return FileUtil.pathToUnixStyle(TemplateEnvironment.fixedDirPath(FileUtil.getRelativePath(TemplateEnvironment.this.eng.getOutputRoot(), TemplateEnvironment.this.outputWriter.getOutputFile().getParentFile())));
        }
    }

    private class RealOutputDirectoryMethod
    extends LiveString {
        private RealOutputDirectoryMethod() {
        }

        String getName() {
            return "realOutputDirectory";
        }

        String getStringValue() throws IOException {
            return TemplateEnvironment.fixedDirPath(TemplateEnvironment.this.outputWriter.getOutputFile().getParentFile());
        }
    }

    private class OutputFileMethod
    extends LiveString {
        private OutputFileMethod() {
        }

        String getName() {
            return "outputFile";
        }

        String getStringValue() throws IOException {
            return FileUtil.pathToUnixStyle(FileUtil.getRelativePath(TemplateEnvironment.this.eng.getOutputRoot(), TemplateEnvironment.this.outputWriter.getOutputFile()));
        }
    }

    private class RealOutputMethod
    extends LiveString {
        private RealOutputMethod() {
        }

        String getName() {
            return "realOutput";
        }

        String getStringValue() throws IOException {
            return TemplateEnvironment.this.outputWriter.getOutputFile().getCanonicalPath();
        }
    }

    private class OutputEncodingMethod
    extends LiveString {
        private OutputEncodingMethod() {
        }

        String getName() {
            return "outputEncoding";
        }

        String getStringValue() {
            return TemplateEnvironment.this.outputWriter.getOutputEncoding();
        }
    }

    private abstract class LiveString
    extends LiveScalar {
        private LiveString() {
        }

        TemplateModel getValue() throws IOException {
            return new SimpleScalar(this.getStringValue());
        }

        abstract String getStringValue() throws IOException;
    }

    private abstract class LiveScalar
    implements TemplateMethodModelEx {
        private LiveScalar() {
        }

        abstract String getName();

        abstract TemplateModel getValue() throws IOException;

        public Object exec(List args) throws TemplateModelException {
            if (args.size() != 0) {
                throw new TemplateModelException(this.getFullName() + " does not support parameters.");
            }
            try {
                return this.getValue();
            }
            catch (IOException exc) {
                throw new TemplateModelException(this.getFullName() + " failed", (Exception)exc);
            }
        }

        private String getFullName() {
            return "pp.get" + this.getName().substring(0, 1).toUpperCase() + this.getName().substring(1) + "()";
        }
    }

    private class PathToMethod
    implements TemplateMethodModel {
        private PathToMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("pathTo needs 1 argument");
            }
            try {
                return new SimpleScalar(TemplateEnvironment.this.getPathTo((String)arguments.get(0)));
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to transform path" + StringUtil.jQuote((String)arguments.get(0)), (Exception)exc);
            }
        }
    }

    private class PathToSourceMethod
    implements TemplateMethodModel {
        private PathToSourceMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("pathToSource needs 1 argument");
            }
            try {
                return new SimpleScalar(TemplateEnvironment.this.getSourcePathTo((String)arguments.get(0)));
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to transform path" + StringUtil.jQuote((String)arguments.get(0)), (Exception)exc);
            }
        }
    }

    private class ToOutputRootRelativePathMethod
    implements TemplateMethodModel {
        private ToOutputRootRelativePathMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("outputRootRelativePath needs 1 argument");
            }
            try {
                return new SimpleScalar(TemplateEnvironment.this.toOutputRelatitvePath((String)arguments.get(0)));
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to transform path" + StringUtil.jQuote((String)arguments.get(0)), (Exception)exc);
            }
        }
    }

    private class ToSourceRootRelativePathMethod
    implements TemplateMethodModel {
        private ToSourceRootRelativePathMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("sourceRootRelativePath needs 1 argument");
            }
            try {
                return new SimpleScalar(TemplateEnvironment.this.toSourceRootRelativePath((String)arguments.get(0)));
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to transform path" + StringUtil.jQuote((String)arguments.get(0)), (Exception)exc);
            }
        }
    }

    private class UrlPathEncodeMethod
    implements TemplateMethodModel {
        private UrlPathEncodeMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("urlEncode needs 1 argument");
            }
            try {
                String s = (String)arguments.get(0);
                s = s.replace('\\', '/');
                s = s.replace(File.separatorChar, '/');
                return new SimpleScalar(StringUtil.urlPathEnc(s, TemplateEnvironment.this.getCurrentUrlEncodingCharset()));
            }
            catch (IOException exc) {
                throw new TemplateModelException("URL path encoding failed", (Exception)exc);
            }
        }
    }

    private class UrlEncodeMethod
    implements TemplateMethodModel {
        private UrlEncodeMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("urlEncode needs 1 argument");
            }
            try {
                return new SimpleScalar(StringUtil.urlEnc((String)arguments.get(0), TemplateEnvironment.this.getCurrentUrlEncodingCharset()));
            }
            catch (IOException exc) {
                throw new TemplateModelException("URL encoding failed", (Exception)exc);
            }
        }
    }

    private class OutputFileExistsMethod
    implements TemplateMethodModel {
        private OutputFileExistsMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("outputFileExists needs 1 argument: file name");
            }
            try {
                File f = TemplateEnvironment.this.resolveOutputPath((String)arguments.get(0));
                return f.exists() ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to check if the file exists", (Exception)exc);
            }
        }
    }

    private class OutputFileLastModifiedMethod
    implements TemplateMethodModel {
        private OutputFileLastModifiedMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("outputFileLastModified needs 1 argument: file name");
            }
            try {
                File f = TemplateEnvironment.this.resolveOutputPath((String)arguments.get(0));
                long l = f.lastModified();
                if (l == 0L) {
                    throw new TemplateModelException("Can't query last modification date, because the file does not exist: " + f.getAbsolutePath());
                }
                return new SimpleDate(new Date(l), 3);
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to query last modification date", (Exception)exc);
            }
        }
    }

    private class OutputFileSizeMethod
    implements TemplateMethodModel {
        private OutputFileSizeMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("outputFileSize needs 1 argument: file name");
            }
            try {
                File f = TemplateEnvironment.this.resolveOutputPath((String)arguments.get(0));
                return new SimpleNumber(f.length());
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to query file size", (Exception)exc);
            }
        }
    }

    private class SourceFileExistsMethod
    implements TemplateMethodModel {
        private SourceFileExistsMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("sourceFileExists needs 1 argument: file name");
            }
            try {
                File f = TemplateEnvironment.this.resolveSourcePath((String)arguments.get(0));
                return f.exists() ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to check if the file exists", (Exception)exc);
            }
        }
    }

    private class SourceFileLastModifiedMethod
    implements TemplateMethodModel {
        private SourceFileLastModifiedMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("sourceFileLastModified needs 1 argument: file name");
            }
            try {
                File f = TemplateEnvironment.this.resolveSourcePath((String)arguments.get(0));
                long l = f.lastModified();
                if (l == 0L) {
                    throw new TemplateModelException("Can't query last modification date, because the file does not exist: " + f.getAbsolutePath());
                }
                return new SimpleDate(new Date(l), 3);
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to query last modification date", (Exception)exc);
            }
        }
    }

    private class SourceFileSizeMethod
    implements TemplateMethodModel {
        private SourceFileSizeMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("sourceFileSize needs 1 argument: file name");
            }
            try {
                File f = TemplateEnvironment.this.resolveSourcePath((String)arguments.get(0));
                return new SimpleNumber(f.length());
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to query file size", (Exception)exc);
            }
        }
    }

    private class RealFileExistsMethod
    implements TemplateMethodModel {
        private RealFileExistsMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("realFileExists needs 1 argument: file name");
            }
            File f = new File((String)arguments.get(0));
            return f.exists() ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    private class RealFileLastModifiedMethod
    implements TemplateMethodModel {
        private RealFileLastModifiedMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("realFileLastModified needs 1 argument: file name");
            }
            File f = new File((String)arguments.get(0));
            long l = f.lastModified();
            if (l == 0L) {
                throw new TemplateModelException("Can't query last modification date, because the file does not exist: " + f.getAbsolutePath());
            }
            return new SimpleDate(new Date(l), 3);
        }
    }

    private class RealFileSizeMethod
    implements TemplateMethodModel {
        private RealFileSizeMethod() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("realFileSize needs 1 argument: file name");
            }
            File f = new File((String)arguments.get(0));
            return new SimpleNumber(f.length());
        }
    }

    private class IgnoreOutputTransform
    extends TemplateModelUtils
    implements TemplateTransformModel {
        private IgnoreOutputTransform() {
        }

        public Writer getWriter(final Writer out, Map params) throws TemplateModelException {
            if (params != null && params.size() != 0) {
                throw new TemplateModelException("This transform does no support parameters.");
            }
            return new Writer(){

                public void close() throws IOException {
                }

                public void flush() throws IOException {
                    out.flush();
                }

                public void write(char[] arg0, int arg1, int arg2) throws IOException {
                }

                public void write(String str) throws IOException {
                }
            };
        }
    }

    private class WarningTransform
    extends TemplateModelUtils
    implements TemplateTransformModel {
        private WarningTransform() {
        }

        public Writer getWriter(Writer out, Map params) throws TemplateModelException {
            String message = null;
            Iterator it = params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String pname = (String)e.getKey();
                Object pvalue = e.getValue();
                if ("message".equals(pname)) {
                    message = this.strParam(pvalue, pname);
                    continue;
                }
                this.dieWithUnknownParam(pname);
            }
            if (message == null) {
                this.dieWithMissingParam("message");
            }
            TemplateEnvironment.this.eng.sendWarning(TemplateEnvironment.this.srcFile, message);
            return null;
        }
    }

    class SetOutputEncodingTransform
    extends TemplateModelUtils
    implements TemplateTransformModel {
        SetOutputEncodingTransform() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Writer getWriter(Writer out, Map params) throws TemplateModelException {
            String encoding = null;
            try {
                TemplateEnvironment.this.outputWriter.setIgnoreFlush(true);
                try {
                    out.flush();
                }
                finally {
                    TemplateEnvironment.this.outputWriter.setIgnoreFlush(false);
                }
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to set output encoding", (Exception)exc);
            }
            Iterator it = params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String pname = (String)e.getKey();
                Object pvalue = e.getValue();
                if ("encoding".equals(pname)) {
                    encoding = this.strParam(pvalue, pname);
                    continue;
                }
                this.dieWithUnknownParam(pname);
            }
            if (encoding == null) {
                this.dieWithMissingParam("encoding");
            }
            try {
                if (encoding.equals("source")) {
                    encoding = TemplateEnvironment.this.template.getEncoding();
                }
                TemplateEnvironment.this.setOutputEncoding(encoding);
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to set output encoding", (Exception)exc);
            }
            return null;
        }
    }

    private class NestOutputFileTransform
    extends TemplateModelUtils
    implements TemplateTransformModel {
        private NestOutputFileTransform() {
        }

        public Writer getWriter(final Writer out, Map params) throws TemplateModelException {
            String name = null;
            boolean append = false;
            try {
                out.flush();
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to nest output file", (Exception)exc);
            }
            Iterator it = params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String pname = (String)e.getKey();
                Object pvalue = e.getValue();
                if ("name".equals(pname)) {
                    name = this.strParam(pvalue, pname);
                    continue;
                }
                if ("append".equals(pname)) {
                    append = this.boolParam(pvalue, pname);
                    continue;
                }
                this.dieWithUnknownParam(pname);
            }
            if (name == null) {
                this.dieWithMissingParam("name");
            }
            try {
                TemplateEnvironment.this.outputWriter.nestOutputFileBegin(name, append);
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to nest output file", (Exception)exc);
            }
            return new Writer(){

                public void write(String data) throws IOException {
                    out.write(data);
                }

                public void write(char[] cbuf, int off, int len) throws IOException {
                    out.write(cbuf, off, len);
                }

                public void flush() throws IOException {
                    out.flush();
                }

                public void close() throws IOException {
                    TemplateEnvironment.this.outputWriter.nestOutputFileEnd(false);
                }
            };
        }
    }

    private class RestartOutputFileTransform
    extends TemplateModelUtils
    implements TemplateTransformModel {
        private RestartOutputFileTransform() {
        }

        public Writer getWriter(Writer out, Map params) throws TemplateModelException {
            if (params != null && params.size() != 0) {
                this.dieWithParamsNotAllowed();
            }
            try {
                TemplateEnvironment.this.outputWriter.restartOutputFile();
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to reset the output file", (Exception)exc);
            }
            return null;
        }
    }

    private class DropOutputFileTransform
    extends TemplateModelUtils
    implements TemplateTransformModel {
        private DropOutputFileTransform() {
        }

        public Writer getWriter(Writer out, Map params) throws TemplateModelException {
            if (params != null && params.size() != 0) {
                this.dieWithParamsNotAllowed();
            }
            try {
                TemplateEnvironment.this.outputWriter.dropOutputFile();
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to drop the output file", (Exception)exc);
            }
            return null;
        }
    }

    private class RenameOutputFileTransform
    extends TemplateModelUtils
    implements TemplateTransformModel {
        private RenameOutputFileTransform() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Writer getWriter(Writer out, Map params) throws TemplateModelException {
            String name = null;
            String extension = null;
            try {
                TemplateEnvironment.this.outputWriter.setIgnoreFlush(true);
                try {
                    out.flush();
                }
                finally {
                    TemplateEnvironment.this.outputWriter.setIgnoreFlush(false);
                }
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to rename the output file", (Exception)exc);
            }
            Iterator it = params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String pname = (String)e.getKey();
                Object pvalue = e.getValue();
                if ("name".equals(pname)) {
                    name = this.strParam(pvalue, pname);
                    continue;
                }
                if ("extension".equals(pname)) {
                    extension = this.strParam(pvalue, pname);
                    continue;
                }
                this.dieWithUnknownParam(pname);
            }
            if (name == null) {
                if (extension == null) {
                    throw new TemplateModelException("You must specify on of parameters \"name\" and \"extension\".");
                }
                try {
                    name = TemplateEnvironment.this.getOutputFile().getName();
                }
                catch (IOException exc) {
                    throw new TemplateModelException("Failed to rename the output file", (Exception)exc);
                }
                int i = name.lastIndexOf(46);
                name = i != -1 ? name.substring(0, i + 1) + extension : name + "." + extension;
            } else if (extension != null) {
                throw new TemplateModelException("You can't specify both parameters \"name\" and \"extension\".");
            }
            try {
                TemplateEnvironment.this.outputWriter.renameOutputFile(name);
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to rename the output file", (Exception)exc);
            }
            return null;
        }
    }

    private class ChangeOutputFileTransform
    extends TemplateModelUtils
    implements TemplateTransformModel {
        private ChangeOutputFileTransform() {
        }

        public Writer getWriter(Writer out, Map params) throws TemplateModelException {
            String name = null;
            boolean append = false;
            try {
                out.flush();
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to change the outout file", (Exception)exc);
            }
            Iterator it = params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String pname = (String)e.getKey();
                Object pvalue = e.getValue();
                if ("name".equals(pname)) {
                    name = this.strParam(pvalue, pname);
                    continue;
                }
                if ("append".equals(pname)) {
                    append = this.boolParam(pvalue, pname);
                    continue;
                }
                this.dieWithUnknownParam(pname);
            }
            if (name == null) {
                this.dieWithMissingParam("name");
            }
            try {
                TemplateEnvironment.this.outputWriter.changeOutputFile(name, append);
            }
            catch (IOException exc) {
                throw new TemplateModelException("Failed to change the outout file", (Exception)exc);
            }
            return null;
        }
    }

    private class PPHash
    implements TemplateHashModelEx {
        private Map map = new HashMap();

        private PPHash() {
        }

        public int size() throws TemplateModelException {
            return this.map.size();
        }

        public TemplateCollectionModel keys() throws TemplateModelException {
            return new SimpleCollection(this.map.keySet(), ObjectWrapper.SIMPLE_WRAPPER);
        }

        public TemplateCollectionModel values() throws TemplateModelException {
            return new SimpleCollection(this.map.values(), ObjectWrapper.SIMPLE_WRAPPER);
        }

        public TemplateModel get(String key) throws TemplateModelException {
            Object o = this.map.get(key);
            if (o instanceof LiveScalar) {
                return (TemplateModel)((LiveScalar)o).exec(Collections.EMPTY_LIST);
            }
            return (TemplateModel)o;
        }

        public boolean isEmpty() throws TemplateModelException {
            return this.map.isEmpty();
        }

        public void put(String name, TemplateModel value) {
            this.map.put(name, value);
        }

        public void put(String name, String value) {
            this.map.put(name, new SimpleScalar(value));
        }

        public void remove(String name) {
            this.map.remove(name);
        }
    }
}

