/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaBuilderImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.FromImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;
import org.eclipse.persistence.internal.jpa.querydef.SubQueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryImpl<T>
implements AbstractQuery<T>,
Serializable {
    protected Metamodel metamodel;
    protected Set<Root<?>> roots = new HashSet();
    protected Expression<Boolean> where;
    protected ResultType queryResult;
    protected CriteriaBuilderImpl queryBuilder;
    protected boolean distinct;
    protected Class queryType;
    protected Predicate havingClause;
    protected List<Expression<?>> groupBy;

    public AbstractQueryImpl(Metamodel metamodel, ResultType queryResult, CriteriaBuilderImpl queryBuilder, Class<T> resultType) {
        this.metamodel = metamodel;
        this.queryResult = queryResult;
        this.queryBuilder = queryBuilder;
        this.queryType = resultType;
    }

    @Override
    public <X> Root<X> from(EntityType<X> entity) {
        RootImpl root = new RootImpl(entity, this.metamodel, entity.getBindableJavaType(), (org.eclipse.persistence.expressions.Expression)new ExpressionBuilder(entity.getBindableJavaType()), entity);
        this.integrateRoot(root);
        return root;
    }

    @Override
    public <X> Root<X> from(Class<X> entityClass) {
        EntityType<X> entity = this.metamodel.entity(entityClass);
        return this.from(entity);
    }

    @Override
    public Class<T> getResultType() {
        return this.queryType;
    }

    @Override
    public Set<Root<?>> getRoots() {
        return this.roots;
    }

    @Override
    public AbstractQuery<T> where(Expression<Boolean> restriction) {
        this.findRootAndParameters(restriction);
        this.where = restriction;
        return this;
    }

    @Override
    public AbstractQuery<T> where(Predicate ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            this.where = null;
        }
        Predicate predicate = this.queryBuilder.and(restrictions);
        this.findRootAndParameters(predicate);
        this.where = predicate;
        return this;
    }

    @Override
    public AbstractQuery<T> groupBy(List<Expression<?>> grouping) {
        this.groupBy = grouping;
        return this;
    }

    @Override
    public AbstractQuery<T> groupBy(Expression<?> ... grouping) {
        this.groupBy = new ArrayList();
        for (Expression<?> exp : grouping) {
            this.groupBy.add(exp);
        }
        return this;
    }

    @Override
    public AbstractQuery<T> having(Expression<Boolean> restriction) {
        this.havingClause = ((InternalExpression)((Object)restriction)).isCompoundExpression() || ((InternalExpression)((Object)restriction)).isPredicate() ? (Predicate)restriction : this.queryBuilder.isTrue(restriction);
        return this;
    }

    @Override
    public AbstractQuery<T> having(Predicate ... restrictions) {
        if (restrictions != null && restrictions.length > 0) {
            Predicate conjunction = this.queryBuilder.conjunction();
            for (Predicate predicate : restrictions) {
                conjunction = this.queryBuilder.and((Expression<Boolean>)conjunction, (Expression<Boolean>)predicate);
            }
            this.havingClause = conjunction;
        }
        return this;
    }

    public abstract void addParameter(ParameterExpression<?> var1);

    public abstract void addJoin(FromImpl var1);

    @Override
    public AbstractQuery<T> distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @Override
    public List<Expression<?>> getGroupList() {
        return this.groupBy;
    }

    @Override
    public Predicate getRestriction() {
        if (((ExpressionImpl)this.where).isPredicate()) {
            return (Predicate)this.where;
        }
        return this.queryBuilder.isTrue(this.where);
    }

    @Override
    public Predicate getGroupRestriction() {
        return this.havingClause;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public <U> Subquery<U> subquery(Class<U> type) {
        return new SubQueryImpl(this.metamodel, type, this.queryBuilder, this);
    }

    protected abstract void integrateRoot(RootImpl var1);

    protected void findRootAndParameters(Expression<?> predicate) {
        ((InternalSelection)((Object)predicate)).findRootAndParameters(this);
    }

    protected void findRootAndParameters(Selection<?> selection) {
        if (selection.isCompoundSelection()) {
            for (Selection<?> subSelection : selection.getCompoundSelectionItems()) {
                this.findRootAndParameters(subSelection);
            }
        }
    }

    protected void findJoins(FromImpl root) {
        root.findJoins(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ResultType {
        UNKNOWN,
        OBJECT_ARRAY,
        PARTIAL,
        TUPLE,
        ENTITY,
        CONSTRUCTOR,
        OTHER;

    }
}

