/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb.many;

import java.util.Map;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.jaxb.many.MapEntry;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class MapValueAttributeAccessor
extends AttributeAccessor {
    private AttributeAccessor nestedAccessor;
    private String mapClassName;
    private Class mapClass;
    private ContainerPolicy containerPolicy;
    private Class generatedEntryClass;

    public MapValueAttributeAccessor(AttributeAccessor nestedAccessor, ContainerPolicy cp, Class generatedEntryClass, String mapClassName) {
        this.nestedAccessor = nestedAccessor;
        this.mapClassName = mapClassName;
        this.containerPolicy = cp;
        this.generatedEntryClass = generatedEntryClass;
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        Object value = this.nestedAccessor.getAttributeValueFromObject(object);
        if (null == value) {
            return null;
        }
        Object results = this.containerPolicy.containerInstance(((Map)value).size());
        for (Object nextKey : ((Map)value).keySet()) {
            MapEntry nextEntry;
            Object nextValue = ((Map)value).get(nextKey);
            try {
                nextEntry = (MapEntry)this.generatedEntryClass.newInstance();
            }
            catch (Exception e) {
                return null;
            }
            nextEntry.setKey(nextKey);
            nextEntry.setValue(nextValue);
            this.containerPolicy.addInto((Object)nextEntry, results, null);
        }
        return results;
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        Map mapValue = null;
        try {
            mapValue = (Map)this.mapClass.newInstance();
        }
        catch (InstantiationException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (IllegalAccessException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        Object iterator = this.containerPolicy.iteratorFor(value);
        while (this.containerPolicy.hasNext(iterator)) {
            Object next = this.containerPolicy.next(iterator, null);
            Object nextKey = ((MapEntry)next).getKey();
            Object nextValue = ((MapEntry)next).getValue();
            mapValue.put(nextKey, nextValue);
        }
        this.nestedAccessor.setAttributeValueInObject(object, mapValue);
    }

    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        this.nestedAccessor.initializeAttributes(theJavaClass);
        if (this.mapClassName.equals("java.util.Map")) {
            this.mapClassName = "java.util.HashMap";
        } else if (this.mapClassName.equals("java.util.concurrent.ConcurrentMap")) {
            this.mapClassName = "java.util.concurrent.ConcurrentHashMap";
        } else if (this.mapClassName.equals("java.util.SortedMap")) {
            this.mapClassName = "java.util.TreeMap";
        }
        try {
            this.mapClass = PrivilegedAccessHelper.getClassForName(this.mapClassName);
        }
        catch (ClassNotFoundException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }
}

