/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.conditions;

import com.nokia.helium.core.ant.types.ConditionType;
import com.nokia.helium.metadata.db.MetaDataDb;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;

public class MetaDataLogCondition
extends ConditionType {
    private String severity;
    private String logFile;
    private File fileName;

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public void setDb(File file) {
        this.fileName = file;
    }

    public void setLog(String log) {
        this.logFile = log;
    }

    public int getSeverity() {
        if (this.fileName == null || !this.fileName.exists() || this.logFile == null) {
            return -1;
        }
        if (this.severity == null) {
            throw new BuildException("'severity' attribute is not defined");
        }
        MetaDataDb.Priority prty = null;
        if (this.severity.equalsIgnoreCase("ERROR")) {
            prty = MetaDataDb.Priority.ERROR;
        } else if (this.severity.equalsIgnoreCase("WARNING")) {
            prty = MetaDataDb.Priority.WARNING;
        } else if (this.severity.equalsIgnoreCase("FATAL")) {
            prty = MetaDataDb.Priority.FATAL;
        } else if (this.severity.equalsIgnoreCase("INFO")) {
            prty = MetaDataDb.Priority.INFO;
        } else if (this.severity.equalsIgnoreCase("REMARK")) {
            prty = MetaDataDb.Priority.REMARK;
        } else {
            throw new BuildException("'severity' attribute is not valid");
        }
        MetaDataDb db = new MetaDataDb(this.fileName.getAbsolutePath());
        String sql = "select count(data) as COUNT from metadata INNER JOIN logfiles ON logfiles.id=metadata.logpath_id where path like '%" + this.logFile + "' and priority_id = " + prty.getValue();
        List<Map<String, Object>> records = db.getRecords(sql);
        Iterator<Map<String, Object>> i$ = records.iterator();
        if (i$.hasNext()) {
            Map<String, Object> map = i$.next();
            return (Integer)map.get("COUNT");
        }
        return 0;
    }

    public boolean eval() {
        int severity = this.getSeverity();
        if (severity < 0) {
            return false;
        }
        return severity > 0;
    }
}

