/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.taskdefs;

import com.nokia.helium.metadata.db.MetaDataDb;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class MetaDataDelete
extends Task {
    private static Logger log = Logger.getLogger(MetaDataDelete.class);
    private String database;
    private boolean failOnError = true;
    private Vector<FileSet> fileSetList = new Vector();

    public void setDatabase(String dbFile) {
        this.database = dbFile;
    }

    public void setFailOnError(String failNotify) {
        if (failNotify.equals("false")) {
            this.failOnError = false;
        }
    }

    private List<String> getFileListFromFileSet() {
        ArrayList<String> fileList = new ArrayList<String>();
        for (FileSet fs : this.fileSetList) {
            String[] includedFiles;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            for (String file : includedFiles = ds.getIncludedFiles()) {
                fileList.add(file);
                log.debug((Object)("includedfiles: " + file));
            }
        }
        log.debug((Object)("fileList.size" + fileList.size()));
        return fileList;
    }

    public void add(FileSet fileSet) {
        this.fileSetList.add(fileSet);
    }

    public String getDatabase() {
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        MetaDataDb metadataDb = null;
        try {
            log.debug((Object)("Initializing DB: " + this.database + "to delete"));
            this.log("time before removing entries from db" + new Date());
            metadataDb = new MetaDataDb(this.database);
            metadataDb.removeEntries(this.getFileListFromFileSet());
            this.log("time after removing entries from db" + new Date());
        }
        catch (BuildException ex1) {
            if (this.failOnError) {
                throw ex1;
            }
        }
        catch (Exception ex) {
            if (this.failOnError) {
                throw new BuildException("Failed during writing data to db");
            }
        }
        finally {
            log.debug((Object)("finalizing DB: " + this.database));
            if (metadataDb != null) {
                metadataDb.finalizeDB();
            }
        }
    }
}

