/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.jpa;

import com.nokia.helium.jpa.ORMCommitCount;
import com.nokia.helium.jpa.entity.Version;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;

public class ORMEntityManager {
    private static Logger log = Logger.getLogger(ORMEntityManager.class);
    private EntityManager entityManager;
    private ORMCommitCount commitCountObject;

    public ORMEntityManager(String urlPath) throws Exception {
        Hashtable<String, String> persistProperties;
        String name;
        block8: {
            name = "metadata";
            persistProperties = new Hashtable<String, String>();
            persistProperties.put("javax.persistence.jdbc.driver", "org.apache.derby.jdbc.EmbeddedDriver");
            persistProperties.put("javax.persistence.jdbc.url", "jdbc:derby:" + urlPath);
            persistProperties.put("eclipselink.persistence-context.close-on-commit", "false");
            persistProperties.put("eclipselink.persistence-context.reference-mode", "WEAK");
            persistProperties.put("eclipselink.jdbc.batch-writing", "JDBC");
            persistProperties.put("eclipselink.read-only", "true");
            persistProperties.put("eclipselink.logging.level", "warning");
            File dbFile = new File(urlPath);
            this.commitCountObject = new ORMCommitCount();
            if (dbFile.exists()) {
                try {
                    log.debug((Object)("checking db integrity for :" + urlPath));
                    if (!this.checkDatabaseIntegrity(urlPath)) {
                        log.debug((Object)"db integrity failed cleaning up old db");
                        try {
                            log.debug((Object)("deleting the url path" + urlPath));
                            FileUtils.forceDelete((File)dbFile);
                            log.debug((Object)("successfully removed the urlpath" + urlPath));
                            break block8;
                        }
                        catch (IOException iex) {
                            log.debug((Object)"deleting the db directory failed", (Throwable)iex);
                            throw new BuildException("failed deleting corrupted db", (Throwable)iex);
                        }
                    }
                    log.debug((Object)"db exists and trying to create entity manager");
                    EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)name, persistProperties);
                    this.entityManager = factory.createEntityManager();
                    this.entityManager.getTransaction().begin();
                    return;
                }
                catch (Exception ex) {
                    log.debug((Object)"Failed to open the database, might be corrupted, creating new db", (Throwable)ex);
                    try {
                        FileUtils.deleteDirectory((File)dbFile);
                    }
                    catch (IOException iex) {
                        log.debug((Object)"deleting the db directory failed");
                        throw iex;
                    }
                }
            }
        }
        log.debug((Object)("url path not exists" + urlPath + "creating it"));
        persistProperties.put("javax.persistence.jdbc.url", "jdbc:derby:" + urlPath + ";create=true");
        persistProperties.put("eclipselink.ddl-generation", "create-tables");
        persistProperties.put("eclipselink.ddl-generation.output-mode", "database");
        persistProperties.put("eclipselink.persistence-context.close-on-commit", "false");
        persistProperties.put("eclipselink.persistence-context.reference-mode", "WEAK");
        persistProperties.put("eclipselink.jdbc.batch-writing", "JDBC");
        persistProperties.put("eclipselink.read-only", "true");
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)name, persistProperties);
        this.entityManager = factory.createEntityManager();
        this.entityManager.getTransaction().begin();
        this.entityManager.persist((Object)new Version());
        this.entityManager.getTransaction().commit();
        this.entityManager.clear();
        this.entityManager.getTransaction().begin();
    }

    public EntityManager getEntityManager() {
        log.debug((Object)("ORMEntityManager: getEntityManager: " + this.entityManager));
        return this.entityManager;
    }

    public ORMCommitCount getCommitCountObject() {
        return this.commitCountObject;
    }

    public void commitToDB() {
        log.debug((Object)"commitToDB");
        if (this.entityManager.getTransaction().isActive() && this.commitCountObject.isDatatoCommit()) {
            this.entityManager.getTransaction().commit();
            this.commitCountObject.reset();
            this.entityManager.clear();
            this.entityManager.getTransaction().begin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeEntityManager() {
        log.debug((Object)("finalizeEntitymanager:" + this.entityManager));
        if (this.entityManager != null) {
            log.debug((Object)"finalizeEntitymanager: isactive1");
            if (this.entityManager.getTransaction().isActive()) {
                log.debug((Object)"finalizeEntitymanager: isactive2");
                try {
                    this.entityManager.getTransaction().commit();
                }
                catch (Exception ex) {
                    log.debug((Object)"exception during commit", (Throwable)ex);
                }
                finally {
                    log.debug((Object)("cleaning up entity manager instance" + this.entityManager));
                    if (this.commitCountObject != null) {
                        this.commitCountObject.reset();
                    }
                    if (this.entityManager != null) {
                        this.entityManager.clear();
                        this.entityManager.close();
                        this.entityManager = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDatabaseIntegrity(String urlPath) {
        boolean result = false;
        this.loadDriver();
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:derby:" + urlPath);
            if (connection != null) {
                Statement stmt = connection.createStatement();
                ResultSet rs = stmt.executeQuery("select version from version");
                int version = -1;
                log.debug((Object)"result set executed");
                if (rs.next()) {
                    version = rs.getInt(1);
                }
                log.debug((Object)("result set executed : " + version));
                rs.close();
                stmt.close();
                if (version == 2) {
                    result = true;
                } else {
                    DriverManager.getConnection("jdbc:derby:;shutdown= true");
                }
            }
        }
        catch (Exception ex) {
            log.debug((Object)"exception while checking database integrity: ", (Throwable)ex);
            log.debug((Object)"shutting down embedded db");
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown= true");
            }
            catch (SQLException sex) {
                log.debug((Object)"normal exception during db shutdown");
            }
        }
        finally {
            try {
                log.debug((Object)"closing the connection");
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sex) {
                log.debug((Object)"normal exception during db shutdown");
            }
            connection = null;
        }
        return result;
    }

    private void loadDriver() {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("JDBC Driver could not be found");
        }
    }
}

