/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FileProperties {
    private File propertyFile;
    private Properties originalProperties;
    private List lineList;
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public FileProperties(File pFile) throws IOException {
        if (pFile == null) {
            throw new IOException("Invalid file");
        }
        this.propertyFile = pFile;
        this.originalProperties = new Properties();
        this.lineList = new ArrayList();
        if (pFile.exists()) {
            String line;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(pFile));
            this.originalProperties.load(bis);
            bis.close();
            BufferedReader br = new BufferedReader(new FileReader(pFile));
            while ((line = br.readLine()) != null) {
                this.lineList.add(line);
            }
        }
    }

    public void store(Properties p) throws IOException {
        if (p == null) {
            return;
        }
        Set<Map.Entry<Object, Object>> set = p.entrySet();
        Iterator<Map.Entry<Object, Object>> iter = set.iterator();
        if (!iter.hasNext()) {
            return;
        }
        block0: while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (this.originalProperties.containsKey(key)) {
                for (int currentLineNumber = 0; currentLineNumber < this.lineList.size(); ++currentLineNumber) {
                    String lineKey;
                    String line = (String)this.lineList.get(currentLineNumber);
                    int equalIndex = line.indexOf(61);
                    if (equalIndex == -1 || !(lineKey = line.substring(0, equalIndex).trim()).equals(this.convert(key, true))) continue;
                    StringBuffer sb = new StringBuffer(line);
                    sb.replace(equalIndex, line.length(), "=" + this.convert(value, false));
                    this.lineList.set(currentLineNumber, sb.toString());
                    continue block0;
                }
                continue;
            }
            this.lineList.add(this.convert(key, true) + "=" + this.convert(value, false));
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.propertyFile));
        for (int i = 0; i < this.lineList.size(); ++i) {
            bw.write((String)this.lineList.get(i));
            bw.newLine();
        }
        bw.close();
    }

    private String convert(String str, boolean escapeSpace) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = str.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(FileProperties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(FileProperties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(FileProperties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(FileProperties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static void main(String[] args) {
        try {
            FileProperties fp = new FileProperties(new File("test.properties"));
            Properties p = new Properties();
            p.put("gc.home.dir", "d:/java dev/src\\GenCommons");
            p.put("gc.debug", "false");
            p.put("gc.xxx", "   br");
            p.put("gc.zzz", " abcd  etytut");
            p.put("gc.AAA", "hello");
            fp.store(p);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

