/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.listener.internaldata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;

public class EmailDataSender {
    public static final String TO_EMAIL = "helium.internaldata@nokia.com";
    public static final String LDAP_URL = "ldap://nedi.europe.nokia.com:389/o=Nokia";
    public static final String SMTP_SERVER = "smtp.nokia.com";
    private String smtpServer;
    private Logger log = Logger.getLogger(EmailDataSender.class);

    public void setSMTPServer(String address) {
        this.smtpServer = address;
    }

    public String getSMTPServer() {
        if (this.smtpServer != null) {
            return this.smtpServer;
        }
        return SMTP_SERVER;
    }

    public void sendData(String data) {
        try {
            String email = this.getUserEmail();
            Properties props = new Properties();
            props.setProperty("mail.smtp.host", this.getSMTPServer());
            Session mailSession = Session.getDefaultInstance((Properties)props, null);
            MimeMessage message = new MimeMessage(mailSession);
            message.setSubject("[HELIUM]: internal data");
            MimeMultipart multipart = new MimeMultipart("related");
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            String htmlText = "<H1>Internal data</H1>";
            messageBodyPart.setContent((Object)htmlText, "text/html");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            messageBodyPart = new MimeBodyPart();
            ByteArrayDataSource dataSrc = this.gzip(data, "data.xml");
            messageBodyPart.setFileName(dataSrc.getName());
            messageBodyPart.setDataHandler(new DataHandler((DataSource)dataSrc));
            messageBodyPart.setHeader("Content-ID", "<data>");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)multipart);
            message.setFrom((Address)new InternetAddress(email));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(TO_EMAIL));
            this.log.debug((Object)"Sending data.");
            Transport.send((Message)message);
        }
        catch (Exception e) {
            this.log.error((Object)("Internal data failure: " + e.getMessage()));
        }
    }

    protected ByteArrayDataSource gzip(String data, String filename) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gz = new GZIPOutputStream(out);
        gz.write(data.getBytes());
        gz.close();
        out.close();
        ByteArrayDataSource dataSrc = new ByteArrayDataSource(out.toByteArray(), "application/x-gzip");
        dataSrc.setName(filename + ".gz");
        return dataSrc;
    }

    protected String getUserEmail() throws Exception {
        String username = System.getProperty("user.name");
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", LDAP_URL);
        InitialDirContext ctx = new InitialDirContext(env);
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        NamingEnumeration<SearchResult> en = ctx.search("", "uid=" + username, controls);
        if (en.hasMore()) {
            SearchResult sr = en.next();
            String email = (String)sr.getAttributes().get("mail").get();
            return email;
        }
        throw new Exception("Could not find user email in LDAP.");
    }
}

