/*
 * Decompiled with CFR 0.152.
 */
package com.kirkk.analyzer.framework.bcelbundle;

import com.kirkk.analyzer.framework.Jar;
import com.kirkk.analyzer.framework.JarClass;
import com.kirkk.analyzer.framework.JarMetrics;
import com.kirkk.analyzer.framework.JarPackage;
import com.kirkk.analyzer.framework.bcelbundle.JarMetricsImpl;
import com.kirkk.analyzer.framework.bcelbundle.JarPackageImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JarImpl
implements Jar {
    public List packages = new ArrayList();
    private List dependentJars = new ArrayList();
    private List incomingDependencies = new ArrayList();
    private List cyclicJars = new ArrayList();
    private boolean containsCycles = false;
    private String jarFileName;

    public JarImpl(String string) {
        this.jarFileName = string;
    }

    public List getAllContainedPackages() {
        return this.packages;
    }

    public void addOutgoingDependency(Jar jar) {
        if (!this.dependentJars.contains(jar)) {
            this.dependentJars.add(jar);
        }
        if (jar.getOutgoingDependencies().contains(this) && !this.cyclicJars.contains(jar)) {
            jar.addCyclicJar(this);
            this.addCyclicJar(jar);
        }
        if (!jar.getIncomingDependencies().contains(this)) {
            jar.addIncomingDependency(this);
        }
    }

    public void addIncomingDependency(Jar jar) {
        this.incomingDependencies.add(jar);
    }

    public void addCyclicJar(Jar jar) {
        if (this.cyclicJars == null) {
            this.cyclicJars = new ArrayList();
        }
        if (!this.cyclicJars.contains(jar)) {
            this.cyclicJars.add(jar);
        }
        this.containsCycles = true;
    }

    public boolean hasCycles() {
        return this.containsCycles;
    }

    public List getCyclicJars() {
        return this.cyclicJars;
    }

    public List getOutgoingDependencies() {
        return this.dependentJars;
    }

    public List getIncomingDependencies() {
        return this.incomingDependencies;
    }

    public List getAllExternallyReferencedPackages() {
        Iterator iterator = this.getAllContainedPackages().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            JarPackage jarPackage = (JarPackage)iterator.next();
            Iterator iterator2 = jarPackage.getImportedPackageNames().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                if (this.containsPackage(string) || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public List getAllUnidentifiableExternallyReferencedPackages() {
        Iterator iterator = this.getAllExternallyReferencedPackages().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = this.dependentJars.iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                Jar jar = (Jar)iterator2.next();
                if (!jar.containsPackage(string)) continue;
                bl = true;
            }
            if (bl || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public int getPackageCount() {
        return this.packages.size();
    }

    public String getJarFileName() {
        return this.jarFileName.substring(this.jarFileName.lastIndexOf(System.getProperty("file.separator")) + 1, this.jarFileName.length());
    }

    public String getFullyQualifiedJarFileName() {
        return this.jarFileName;
    }

    public int getClassCount() {
        Iterator iterator = this.packages.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JarPackage jarPackage = (JarPackage)iterator.next();
            n += jarPackage.getClassCount();
        }
        return n;
    }

    public int getAbstractClassCount() {
        Iterator iterator = this.packages.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JarPackage jarPackage = (JarPackage)iterator.next();
            Iterator iterator2 = jarPackage.getClasses().iterator();
            while (iterator2.hasNext()) {
                JarClass jarClass = (JarClass)iterator2.next();
                if (!jarClass.isAbstract() && !jarClass.isInterface()) continue;
                ++n;
            }
        }
        return n;
    }

    public void addPackage(JarPackage jarPackage) {
        this.packages.add(jarPackage);
    }

    public JarPackage getPackage(String string) {
        JarPackageImpl jarPackageImpl = new JarPackageImpl(string);
        int n = this.packages.indexOf(jarPackageImpl);
        return (JarPackage)this.packages.get(n);
    }

    public boolean containsPackage(String string) {
        if (this.packages == null) {
            return false;
        }
        JarPackageImpl jarPackageImpl = new JarPackageImpl(string);
        return this.packages.contains(jarPackageImpl);
    }

    public JarMetrics calculateMetrics() {
        JarMetricsImpl jarMetricsImpl = new JarMetricsImpl(this);
        return jarMetricsImpl;
    }
}

