/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint.checks;

import com.nokia.helium.antlint.checks.AbstractScriptCheck;
import java.util.List;
import org.dom4j.Element;

public class CheckJepJythonScript
extends AbstractScriptCheck {
    @Override
    public void run(Element node) {
        if (node.getName().equals("target")) {
            this.checkScripts(node);
        }
        if (node.getName().equals("scriptdef")) {
            String scriptdefname = node.attributeValue("name");
            String language = node.attributeValue("language");
            if (language.equals("jep") || language.equals("jython")) {
                this.writeJepFile(scriptdefname, node.getText());
            }
        }
    }

    private void checkScripts(Element node) {
        String target = node.attributeValue("name");
        List scriptList = node.selectNodes("//target[@name='" + target + "']/descendant::script");
        for (Element scriptElement : scriptList) {
            String language = scriptElement.attributeValue("language");
            if (!language.equals("jep") && !language.equals("jython")) continue;
            this.writeJepFile("target_" + target, scriptElement.getText());
        }
    }
}

