/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.metadata.ant.types.XMLLogMetaDataInput;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class SBSLogMetaDataInput
extends XMLLogMetaDataInput {
    private Logger log = Logger.getLogger(SBSLogMetaDataInput.class);
    private String currentComponent;
    private String logTextInfo = "";
    private int lineNumber;
    private boolean recordText;

    private String getComponent(XMLStreamReader streamReader) {
        int count = streamReader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!streamReader.getAttributeLocalName(i).equals("bldinf")) continue;
            return streamReader.getAttributeValue(i);
        }
        return null;
    }

    @Override
    public boolean characters(XMLStreamReader streamReader) {
        if (this.recordText) {
            this.logTextInfo = this.logTextInfo + streamReader.getText();
        }
        return false;
    }

    @Override
    public boolean startElement(XMLStreamReader streamReader) throws Exception {
        try {
            String tagName = streamReader.getLocalName();
            if (tagName.equalsIgnoreCase("buildlog")) {
                this.log.debug((Object)"starting with buildlog");
            }
            if (tagName.equalsIgnoreCase("recipe")) {
                this.lineNumber = streamReader.getLocation().getLineNumber();
                this.recordText = true;
                this.currentComponent = this.getComponent(streamReader);
            } else if (tagName.equalsIgnoreCase("error") || tagName.equalsIgnoreCase("warning")) {
                this.lineNumber = streamReader.getLocation().getLineNumber();
                this.recordText = true;
            } else if (tagName.equalsIgnoreCase("whatlog")) {
                this.currentComponent = this.getComponent(streamReader);
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"exception in startelement", (Throwable)ex);
            throw ex;
        }
        return false;
    }

    @Override
    public boolean endElement(XMLStreamReader streamReader) throws Exception {
        try {
            String tagName = streamReader.getLocalName();
            if (tagName.equalsIgnoreCase("recipe")) {
                this.recordText = false;
                if (this.logTextInfo != null) {
                    boolean entryCreated = this.findAndAddEntries(this.logTextInfo, this.currentComponent, this.getCurrentFile().toString(), this.lineNumber);
                    this.logTextInfo = "";
                    if (entryCreated) {
                        return true;
                    }
                }
            } else {
                if (tagName.equalsIgnoreCase("error") || tagName.equalsIgnoreCase("warning")) {
                    this.recordText = false;
                    this.addEntry(tagName, "general", this.getCurrentFile().toString(), this.lineNumber, this.logTextInfo);
                    this.logTextInfo = "";
                    return true;
                }
                if (tagName.equalsIgnoreCase("whatlog")) {
                    this.addEntry("default", this.currentComponent, this.getCurrentFile().toString(), -1, "");
                }
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"Exception while processing for sbs metadata input", (Throwable)ex);
            throw ex;
        }
        return false;
    }
}

