/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.sort.ModuleDescriptorSorter;
import org.apache.ivy.core.sort.NonMatchingVersionReporter;
import org.apache.ivy.core.sort.SilentNonMatchingVersionReporter;
import org.apache.ivy.core.sort.SortEngineSettings;
import org.apache.ivy.plugins.circular.CircularDependencyException;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;

public class SortEngine {
    private SortEngineSettings settings;

    public SortEngine(SortEngineSettings settings) {
        if (settings == null) {
            throw new NullPointerException("SortEngine.settings can not be null");
        }
        this.settings = settings;
    }

    public List sortNodes(Collection nodes) throws CircularDependencyException {
        LinkedHashMap<ModuleDescriptor, ArrayList<IvyNode>> dependenciesMap = new LinkedHashMap<ModuleDescriptor, ArrayList<IvyNode>>();
        ArrayList<IvyNode> nulls = new ArrayList<IvyNode>();
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (node.getDescriptor() == null) {
                nulls.add(node);
                continue;
            }
            ArrayList<IvyNode> n = (ArrayList<IvyNode>)dependenciesMap.get(node.getDescriptor());
            if (n == null) {
                n = new ArrayList<IvyNode>();
                dependenciesMap.put(node.getDescriptor(), n);
            }
            n.add(node);
        }
        List list = this.sortModuleDescriptors(dependenciesMap.keySet(), new SilentNonMatchingVersionReporter());
        double adjustFactor = 1.3;
        ArrayList<IvyNode> ret = new ArrayList<IvyNode>((int)((double)list.size() * 1.3 + (double)nulls.size()));
        for (int i = 0; i < list.size(); ++i) {
            ModuleDescriptor md = (ModuleDescriptor)list.get(i);
            List n = (List)dependenciesMap.get(md);
            ret.addAll(n);
        }
        ret.addAll(0, nulls);
        return ret;
    }

    public List sortModuleDescriptors(Collection moduleDescriptors, NonMatchingVersionReporter nonMatchingVersionReporter) throws CircularDependencyException {
        if (nonMatchingVersionReporter == null) {
            throw new NullPointerException("nonMatchingVersionReporter can not be null");
        }
        ModuleDescriptorSorter sorter = new ModuleDescriptorSorter(moduleDescriptors, this.getVersionMatcher(), nonMatchingVersionReporter, this.getCircularStrategy());
        return sorter.sortModuleDescriptors();
    }

    protected CircularDependencyStrategy getCircularStrategy() {
        return this.settings.getCircularDependencyStrategy();
    }

    protected VersionMatcher getVersionMatcher() {
        return this.settings.getVersionMatcher();
    }
}

