/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.sbs.ant.types;

import com.nokia.helium.core.ant.VariableIFImpl;
import com.nokia.helium.core.ant.types.Variable;
import com.nokia.helium.core.ant.types.VariableSet;
import com.nokia.helium.sbs.ant.types.SBSMakeOptions;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;

public class SBSInput
extends VariableIFImpl {
    private static Logger log = Logger.getLogger(SBSInput.class);
    private Vector<VariableSet> sbsOptions = new Vector();
    private Vector<SBSMakeOptions> sbsMakeOptions = new Vector();
    private Vector<SBSInput> sbsInputList = new Vector();

    public VariableSet createSBSOptions() {
        SBSInput sbsInput = new SBSInput();
        VariableSet varSet = new VariableSet();
        sbsInput.addSBSOptions(varSet);
        this.sbsInputList.add(sbsInput);
        return varSet;
    }

    public void addSBSOptions(VariableSet varSet) {
        this.sbsOptions.add(varSet);
    }

    public VariableSet createSBSMakeOptions() {
        SBSInput sbsInput = new SBSInput();
        SBSMakeOptions varSet = new SBSMakeOptions();
        sbsInput.addSBSMakeOptions(varSet);
        this.sbsInputList.add(sbsInput);
        return varSet;
    }

    public void addSBSMakeOptions(SBSMakeOptions varSet) {
        this.sbsMakeOptions.add(varSet);
    }

    public SBSInput createSBSInput() {
        SBSInput sbsInput = new SBSInput();
        this.sbsInputList.add(sbsInput);
        return sbsInput;
    }

    public Vector<VariableSet> getSBSOptions() {
        return this.sbsOptions;
    }

    public Vector<SBSMakeOptions> getSBSMakeOptions() {
        return this.sbsMakeOptions;
    }

    private void validateInput() {
        if (!(this.getRefid() == null || this.sbsMakeOptions.isEmpty() && this.sbsOptions.isEmpty())) {
            throw new BuildException("SBSInput with refid should not have sbsoptions / sbsmakeoptions");
        }
    }

    private Vector<VariableSet> getSBSOptions(SBSInput sbsInput) {
        Vector<VariableSet> optionsList;
        Vector<VariableSet> fullList = null;
        sbsInput.validateInput();
        Reference refId = sbsInput.getRefid();
        Object sbsInputObject = null;
        if (refId != null) {
            VariableSet options;
            try {
                sbsInputObject = refId.getReferencedObject();
            }
            catch (Exception ex) {
                throw new BuildException("Reference id (" + refId.getRefId() + ") of sbsinput list is not valid");
            }
            if (sbsInputObject != null && sbsInputObject instanceof SBSInput && (options = ((SBSInput)((Object)sbsInputObject)).getFullSBSOptions()) != null) {
                if (fullList == null) {
                    fullList = new Vector();
                }
                fullList.add(options);
            }
        }
        if ((optionsList = sbsInput.getSBSOptions()) != null) {
            if (fullList == null) {
                fullList = new Vector<VariableSet>();
            }
            fullList.addAll(optionsList);
        }
        return fullList;
    }

    private Vector<SBSMakeOptions> getSBSMakeOptions(SBSInput sbsInput) {
        Object options;
        Vector<Vector<SBSMakeOptions>> sbsMakeOptionsList = null;
        Reference refId = sbsInput.getRefid();
        Object sbsInputObject = null;
        if (refId != null) {
            try {
                sbsInputObject = refId.getReferencedObject();
            }
            catch (Exception ex) {
                throw new BuildException("Reference id (" + refId.getRefId() + ") of sbsinput list is not valid");
            }
            if (sbsInputObject != null && sbsInputObject instanceof SBSInput && (options = ((SBSInput)((Object)sbsInputObject)).getFullSBSMakeOptions()) != null) {
                if (sbsMakeOptionsList == null) {
                    sbsMakeOptionsList = new Vector();
                }
                sbsMakeOptionsList.add((Vector<SBSMakeOptions>)options);
            }
        }
        if ((options = sbsInput.getSBSMakeOptions()) != null) {
            if (sbsMakeOptionsList == null) {
                sbsMakeOptionsList = new Vector<Vector<SBSMakeOptions>>();
            }
            sbsMakeOptionsList.addAll((Collection<Vector<SBSMakeOptions>>)options);
        }
        return sbsMakeOptionsList;
    }

    public VariableSet getFullSBSOptions() {
        Vector<VariableSet> fullList = null;
        VariableSet resultSet = null;
        Vector<VariableSet> currentOptions = this.getSBSOptions(this);
        if (currentOptions != null && !currentOptions.isEmpty()) {
            if (fullList == null) {
                fullList = new Vector<VariableSet>();
            }
            fullList.addAll(currentOptions);
        }
        for (SBSInput sbsInput : this.sbsInputList) {
            Vector<VariableSet> options = this.getSBSOptions(sbsInput);
            if (options == null || options.isEmpty()) continue;
            if (fullList == null) {
                fullList = new Vector();
            }
            fullList.addAll(options);
        }
        if (fullList != null) {
            for (VariableSet varSet : fullList) {
                for (Variable var : varSet.getVariables()) {
                    if (resultSet == null) {
                        resultSet = new VariableSet();
                    }
                    resultSet.add(var);
                }
            }
        }
        return resultSet;
    }

    public SBSMakeOptions getFullSBSMakeOptions() {
        Vector<SBSMakeOptions> sbsMakeOptionsList = null;
        SBSMakeOptions resultSet = null;
        Vector<SBSMakeOptions> currentOptions = this.getSBSMakeOptions(this);
        if (currentOptions != null && !currentOptions.isEmpty()) {
            if (sbsMakeOptionsList == null) {
                sbsMakeOptionsList = new Vector<SBSMakeOptions>();
            }
            sbsMakeOptionsList.addAll(currentOptions);
        }
        for (SBSInput sbsInput : this.sbsInputList) {
            Vector<SBSMakeOptions> options = this.getSBSMakeOptions(sbsInput);
            if (options == null || options.isEmpty()) continue;
            if (sbsMakeOptionsList == null) {
                sbsMakeOptionsList = new Vector();
            }
            sbsMakeOptionsList.addAll(options);
        }
        if (sbsMakeOptionsList != null) {
            String engine = null;
            String ppThreads = null;
            for (SBSMakeOptions varSet : sbsMakeOptionsList) {
                String currentEngine = varSet.getEngine();
                String currentThread = varSet.getPPThreads();
                if (currentEngine != null) {
                    if (engine == null) {
                        engine = currentEngine;
                        if (resultSet == null) {
                            resultSet = new SBSMakeOptions();
                        }
                        resultSet.setEngine(currentEngine);
                    } else if (!engine.equals(currentEngine)) {
                        throw new BuildException("inheriting engine types mismatch: " + engine + " != " + currentEngine);
                    }
                }
                if (resultSet == null) {
                    resultSet = new SBSMakeOptions();
                }
                if (ppThreads == null && currentThread != null) {
                    ppThreads = currentThread;
                    resultSet.setPPThreads(ppThreads);
                }
                for (Variable var : varSet.getVariables()) {
                    resultSet.add(var);
                }
            }
        }
        return resultSet;
    }

    public Collection<Variable> getVariables() {
        Collection varList = null;
        VariableSet options = this.getFullSBSOptions();
        if (options != null) {
            varList = options.getVariables();
        }
        return varList;
    }
}

