/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.jetty.deployer;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.resource.Resource;

public class WebAppDeployer
extends AbstractLifeCycle {
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private HandlerContainer contexts;
    private String webAppDir;
    private String defaultsDescriptor;
    private String[] configurationClasses;
    private boolean extract;
    private boolean parentLoaderPriority;
    private boolean allowDuplicates;
    private ArrayList<WebAppContext> deployed;
    private String extraClasspath;

    public String[] getConfigurationClasses() {
        return this.configurationClasses;
    }

    public void setConfigurationClasses(String[] configurationClasses) {
        this.configurationClasses = configurationClasses;
    }

    public HandlerContainer getContexts() {
        return this.contexts;
    }

    public void setContexts(HandlerContainer contexts) {
        this.contexts = contexts;
    }

    public String getDefaultsDescriptor() {
        return this.defaultsDescriptor;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this.defaultsDescriptor = defaultsDescriptor;
    }

    public boolean isExtract() {
        return this.extract;
    }

    public void setExtract(boolean extract) {
        this.extract = extract;
    }

    public boolean isParentLoaderPriority() {
        return this.parentLoaderPriority;
    }

    public void setParentLoaderPriority(boolean parentPriorityClassLoading) {
        this.parentLoaderPriority = parentPriorityClassLoading;
    }

    public String getWebAppDir() {
        return this.webAppDir;
    }

    public void setWebAppDir(String dir) {
        this.webAppDir = dir;
    }

    public boolean getAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setExtraClasspath(String extraClasspath) {
        this.extraClasspath = extraClasspath;
    }

    public String getExtraClasspath() {
        return this.extraClasspath;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public void doStart() throws Exception {
        this.deployed = new ArrayList();
        this.scan();
    }

    public void scan() throws Exception {
        if (this.contexts == null) {
            throw new IllegalArgumentException("No HandlerContainer");
        }
        Resource r = Resource.newResource((String)this.webAppDir);
        if (!r.exists()) {
            throw new IllegalArgumentException("No such webapps resource " + r);
        }
        if (!r.isDirectory()) {
            throw new IllegalArgumentException("Not directory webapps resource " + r);
        }
        String[] files = r.list();
        block2: for (int f = 0; files != null && f < files.length; ++f) {
            Resource unpacked;
            String context = files[f];
            if (context.equalsIgnoreCase("CVS/") || context.equalsIgnoreCase("CVS") || context.startsWith(".")) continue;
            Resource app = r.addPath(r.encode(context));
            if (!context.toLowerCase().endsWith(".war") && !context.toLowerCase().endsWith(".jar") ? !app.isDirectory() : (unpacked = r.addPath(context = context.substring(0, context.length() - 4))) != null && unpacked.exists() && unpacked.isDirectory()) continue;
            context = context.equalsIgnoreCase("root") || context.equalsIgnoreCase("root/") ? "/" : "/" + context;
            if (context.endsWith("/") && context.length() > 0) {
                context = context.substring(0, context.length() - 1);
            }
            if (!this.allowDuplicates) {
                Handler[] installed = this.contexts.getChildHandlersByClass(ContextHandler.class);
                for (int i = 0; i < installed.length; ++i) {
                    String path;
                    ContextHandler c = (ContextHandler)installed[i];
                    if (context.equals(c.getContextPath())) continue block2;
                    if (c instanceof WebAppContext) {
                        path = ((WebAppContext)c).getWar();
                    } else {
                        String string = path = c.getBaseResource() == null ? "" : c.getBaseResource().getFile().getAbsolutePath();
                    }
                    if (path.equals(app.getFile().getAbsolutePath())) continue block2;
                }
            }
            WebAppContext wah = null;
            if (this.contexts instanceof ContextHandlerCollection && WebAppContext.class.isAssignableFrom(((ContextHandlerCollection)this.contexts).getContextClass())) {
                try {
                    wah = (WebAppContext)((ContextHandlerCollection)this.contexts).getContextClass().newInstance();
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            } else {
                wah = new WebAppContext();
            }
            wah.setContextPath(context);
            if (this.configurationClasses != null) {
                wah.setConfigurationClasses(this.configurationClasses);
            }
            if (this.defaultsDescriptor != null) {
                wah.setDefaultsDescriptor(this.defaultsDescriptor);
            }
            wah.setExtractWAR(this.extract);
            wah.setWar(app.toString());
            wah.setParentLoaderPriority(this.parentLoaderPriority);
            this.log.info((Object)"Adding additional path to the WebAppContext");
            if (this.extraClasspath != null) {
                this.log.info((Object)("Adding additional path to the WebAppContext: " + this.extraClasspath));
                System.out.println("Adding additional path to the WebAppContext: " + this.extraClasspath);
                wah.setExtraClasspath(this.extraClasspath);
            }
            this.contexts.addHandler((Handler)wah);
            this.deployed.add(wah);
            if (!this.contexts.isStarted()) continue;
            this.contexts.start();
        }
    }

    public void doStop() throws Exception {
        int i = this.deployed.size();
        while (i-- > 0) {
            ContextHandler wac = (ContextHandler)this.deployed.get(i);
            wac.stop();
        }
    }
}

