/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint;

import com.nokia.helium.antlint.checks.Check;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class AntLintHandler
extends DefaultHandler {
    private int indentLevel;
    private int indentSpace;
    private Locator locator;
    private boolean textElement;
    private int currentLine;
    private StringBuffer strBuff = new StringBuffer();
    private boolean indentationCheck;
    private boolean tabCharacterCheck;
    private Check check;

    public AntLintHandler(Check check) {
        this.check = check;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() {
        this.indentLevel -= 4;
    }

    @Override
    public void endDocument() {
    }

    public void setIndentationCheck(boolean indentationCheck) {
        this.indentationCheck = indentationCheck;
    }

    public void setTabCharacterCheck(boolean tabCharacterCheck) {
        this.tabCharacterCheck = tabCharacterCheck;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        this.countSpaces();
        this.indentLevel += 4;
        this.checkIndent();
        this.currentLine = this.locator.getLineNumber();
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        this.countSpaces();
        if (this.currentLine != this.locator.getLineNumber()) {
            this.checkIndent();
        }
        this.indentLevel -= 4;
        this.textElement = false;
    }

    private void checkIndent() {
        if (this.indentationCheck && this.indentSpace != this.indentLevel && !this.textElement) {
            this.check.log(this.locator.getLineNumber() + ": Bad indentation!");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            this.strBuff.append(ch[i]);
        }
    }

    public void countSpaces() {
        int numSpaces = 0;
        block6: for (int i = 0; i < this.strBuff.length(); ++i) {
            switch (this.strBuff.charAt(i)) {
                case '\t': {
                    numSpaces += 4;
                    if (!this.tabCharacterCheck) continue block6;
                    this.check.log(this.locator.getLineNumber() + ": Tabs should not be used!");
                    continue block6;
                }
                case '\n': {
                    numSpaces = 0;
                    continue block6;
                }
                case '\r': {
                    continue block6;
                }
                case ' ': {
                    ++numSpaces;
                    continue block6;
                }
                default: {
                    this.textElement = true;
                }
            }
        }
        this.indentSpace = numSpaces;
        this.strBuff.delete(0, this.strBuff.length());
    }
}

