/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.types;

import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.interfaces.ActionListenerComponent;
import com.sardak.antform.interfaces.Requirable;
import com.sardak.antform.types.DefaultProperty;
import com.sardak.antform.util.FontStyleAttribute;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.tools.ant.Task;

public class TextProperty
extends DefaultProperty
implements Requirable,
ActionListenerComponent {
    private int columns = 34;
    private boolean password = false;
    private boolean required;
    private JTextField textField;
    private String fontName;
    private int fontSize = -1;
    private int fontStyle = 0;

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean password) {
        this.password = password;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(FontStyleAttribute fsa) {
        this.fontStyle = fsa.getFontStyle();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void addToControlPanel(ControlPanel panel) {
        this.textField = !this.isPassword() ? new JTextField(this.getColumns()) : new JPasswordField(this.getColumns());
        panel.getStylesheetHandler().addTextField(this.textField);
        this.textField.setEditable(this.isEditable());
        if (this.fontName != null || this.fontSize == -1) {
            Font f = this.textField.getFont();
            String name = this.fontName == null ? f.getFontName() : this.fontName;
            int size = this.fontSize > 0 ? this.fontSize : f.getSize();
            this.textField.setFont(new Font(name, this.fontStyle, size));
        }
        this.initComponent(this.textField, panel);
    }

    public boolean validate(Task task) {
        return super.validate(task, "TextProperty");
    }

    public void ok() {
        this.getProject().setProperty(this.getProperty(), this.textField.getText());
    }

    public void reset() {
        this.textField.setText(this.getCurrentProjectPropertyValue());
    }

    public boolean requiredStatusOk() {
        boolean ok = true;
        if (this.isRequired() && "".equals(this.textField.getText())) {
            ok = false;
            this.textField.requestFocus();
        }
        return ok;
    }

    public JComponent getFocusableComponent() {
        return this.textField;
    }
}

