/*
 * Decompiled with CFR 0.152.
 */
package fmpp;

import fmpp.DataModelBuildingException;
import fmpp.FmppFileOutputWriter;
import fmpp.FmppOutputWriter;
import fmpp.FmppTemplateLoader;
import fmpp.GenericProcessingException;
import fmpp.IllegalConfigurationException;
import fmpp.LocalDataBuilder;
import fmpp.ProcessingException;
import fmpp.ProgressListener;
import fmpp.TemplateDataModelBuilder;
import fmpp.TemplateEnvironment;
import fmpp.XmlDependentOps;
import fmpp.XmlRenderingConfiguration;
import fmpp.util.BorderedReader;
import fmpp.util.BugException;
import fmpp.util.ExceptionCC;
import fmpp.util.FileUtil;
import fmpp.util.InstallationException;
import fmpp.util.MiscUtil;
import fmpp.util.StringUtil;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class Engine {
    public static final int PMODE_NONE = 0;
    public static final int PMODE_EXECUTE = 1;
    public static final int PMODE_COPY = 2;
    public static final int PMODE_IGNORE = 3;
    public static final int PMODE_RENDER_XML = 4;
    public static final int SKIP_NONE = 0;
    public static final int SKIP_STATIC = 1;
    public static final int SKIP_ALL = 2;
    public static final String PARAMETER_VALUE_SOURCE = "source";
    public static final String PARAMETER_VALUE_OUTPUT = "output";
    public static final String PARAMETER_VALUE_HOST = "host";
    public static final String XPATH_ENGINE_DONT_SET = "dontSet";
    public static final String XPATH_ENGINE_DEFAULT = "default";
    public static final String XPATH_ENGINE_XALAN = "xalan";
    public static final String XPATH_ENGINE_JAXEN = "jaxen";
    private static final String IGNOREDIR_FILE = "ignoredir.fmpp";
    private static final Set STATIC_FILE_EXTS = new HashSet();
    private static String cachedVersion;
    private static String cachedBuildInfo;
    private File srcRoot;
    private File outRoot;
    private File dataRoot;
    private Map freemarkerLinks;
    private boolean stopOnError;
    private Map data;
    private LayeredChooser localDataBuilders;
    private TemplateDataModelBuilder tdmBuilder;
    private String outputEncoding;
    private String urlEscapingCharset;
    private LinkedList pModeChoosers;
    private LayeredChooser headerChoosers;
    private LayeredChooser footerChoosers;
    private LinkedList turnChoosers;
    private boolean csPathCmp;
    private boolean expertMode;
    private ArrayList removeExtensions;
    private ArrayList removePostfixes;
    private ArrayList replaceExtensions;
    private int skipUnchanged;
    private boolean ignoreCvsFiles;
    private boolean ignoreSvnFiles;
    private boolean ignoreTemporaryFiles;
    private String xpathEngine;
    private Object xmlEntityResolver;
    private boolean validateXml;
    private List xmlRendCfgCntrs;
    private Configuration fmCfg;
    private Perl5Matcher reMatcher;
    private Perl5Compiler reCompiler;
    private MultiProgressListener progListeners;
    private TemplateEnvironment templateEnv;
    private int maxTurn;
    private int currentTurn;
    private Map attributes;
    private XmlDependentOps xmlDependentOps;
    private Boolean chachedXmlSupportAvailable;
    private boolean parametersLocked;
    private Map ignoredDirCache;
    private Set processedFiles;
    private static final int MAX_WBLN = 64;
    static /* synthetic */ Class class$fmpp$TemplateDataModelBuilder;
    static /* synthetic */ Class class$fmpp$Engine;

    public Engine() {
        this(null);
    }

    public Engine(BeansWrapper beansWrapper) {
        String[] list = new String[]{"jpg", "jpeg", "gif", "png", "swf", "bmp", "pcx", "tga", "tiff", "ico", "zip", "gz", "tgz", "jar", "ace", "bz", "bz2", "tar", "arj", "rar", "lha", "cab", "lzh", "taz", "tz", "arc", "exe", "com", "msi", "class", "dll", "doc", "xls", "pdf", "ps", "chm", "avi", "wav", "mp3", "mpeg", "mpg", "wma", "mov", "fli"};
        for (int i = 0; i < list.length; ++i) {
            STATIC_FILE_EXTS.add(list[i]);
        }
        this.freemarkerLinks = new HashMap();
        this.stopOnError = true;
        this.data = new HashMap();
        this.localDataBuilders = new LayeredChooser();
        this.outputEncoding = PARAMETER_VALUE_SOURCE;
        this.urlEscapingCharset = PARAMETER_VALUE_OUTPUT;
        this.pModeChoosers = new LinkedList();
        this.headerChoosers = new LayeredChooser();
        this.footerChoosers = new LayeredChooser();
        this.turnChoosers = new LinkedList();
        this.csPathCmp = false;
        this.expertMode = false;
        this.removeExtensions = new ArrayList();
        this.removePostfixes = new ArrayList();
        this.replaceExtensions = new ArrayList();
        this.ignoreCvsFiles = true;
        this.ignoreSvnFiles = true;
        this.ignoreTemporaryFiles = true;
        this.xpathEngine = XPATH_ENGINE_DONT_SET;
        this.validateXml = false;
        this.xmlRendCfgCntrs = new ArrayList();
        this.reMatcher = new Perl5Matcher();
        this.reCompiler = new Perl5Compiler();
        this.progListeners = new MultiProgressListener();
        this.attributes = new HashMap();
        this.ignoredDirCache = new HashMap();
        this.processedFiles = new HashSet();
        if (beansWrapper == null) {
            beansWrapper = new BeansWrapper();
            beansWrapper.setSimpleMapWrapper(true);
        }
        this.fmCfg = new Configuration();
        this.fmCfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.fmCfg.setStrictSyntaxMode(true);
        this.fmCfg.setTemplateUpdateDelay(2147473647);
        this.fmCfg.setObjectWrapper((ObjectWrapper)beansWrapper);
        this.fmCfg.setDefaultEncoding("ISO-8859-1");
        this.fmCfg.setLocale(Locale.US);
        this.fmCfg.setNumberFormat("0.############");
        this.fmCfg.setLocalizedLookup(false);
        this.templateEnv = new TemplateEnvironment(this);
        this.clearModeChoosers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File[] sources) throws ProcessingException {
        this.progListeners.notifyProgressEvent(this, 1, null, 0, null, null);
        try {
            try {
                this.setupSession();
            }
            catch (IllegalConfigurationException e) {
                throw new ProcessingException(this, null, e);
            }
            try {
                int i;
                File[] srcs = new File[sources.length];
                for (i = 0; i < sources.length; ++i) {
                    File src = sources[i].getCanonicalFile();
                    if (!FileUtil.isInsideOrEquals(src, this.srcRoot)) {
                        throw new IOException("The source file (" + src.getPath() + ") is not inside the source root (" + this.srcRoot.getPath() + ")");
                    }
                    srcs[i] = src;
                }
                while (this.currentTurn <= this.maxTurn) {
                    for (i = 0; i < srcs.length; ++i) {
                        if (srcs[i] == null) continue;
                        File out = new File(this.outRoot, FileUtil.getRelativePath(this.srcRoot, srcs[i]));
                        boolean done = srcs[i].isDirectory() ? this.processDir(srcs[i], out) : this.processFile(srcs[i], out, true);
                        if (!done) continue;
                        srcs[i] = null;
                    }
                    ++this.currentTurn;
                }
            }
            finally {
                this.cleanupSession();
            }
        }
        catch (ProcessingException e) {
            this.progListeners.notifyProgressEvent(this, 4, null, 0, e, null);
            throw e;
        }
        catch (IOException e) {
            this.progListeners.notifyProgressEvent(this, 4, null, 0, e, null);
            throw new ProcessingException(this, null, e);
        }
        this.progListeners.notifyProgressEvent(this, 4, null, 0, null, null);
    }

    private boolean isDirMarkedWithIgnoreFile(File dir) throws IOException {
        File parentDir;
        Boolean ignore = (Boolean)this.ignoredDirCache.get(dir);
        if (ignore != null) {
            return ignore;
        }
        if (!dir.equals(this.srcRoot) && (parentDir = dir.getParentFile()) != null && this.isDirMarkedWithIgnoreFile(parentDir)) {
            this.ignoredDirCache.put(dir, Boolean.TRUE);
            return true;
        }
        boolean ign = new File(dir, IGNOREDIR_FILE).exists();
        this.ignoredDirCache.put(dir, ign ? Boolean.TRUE : Boolean.FALSE);
        return ign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File src, File out) throws ProcessingException {
        this.progListeners.notifyProgressEvent(this, 1, null, 0, null, null);
        File oldSrcRoot = this.srcRoot;
        File oldOutRoot = this.outRoot;
        try {
            try {
                if (src == null) {
                    throw new IllegalArgumentException("The source argument can't be null.");
                }
                if (out == null) {
                    throw new IllegalArgumentException("The output argument can't be null.");
                }
                if (!(src = src.getCanonicalFile()).exists()) {
                    throw new IOException("Source file not found: " + src.getPath());
                }
                if (src.isDirectory()) {
                    throw new IOException("Source file can't be a directory: " + src.getPath());
                }
                if ((out = out.getCanonicalFile()).exists() && out.isDirectory()) {
                    throw new IOException("The output file can't be a directory.");
                }
                if (this.srcRoot == null) {
                    this.setSourceRoot(src.getParentFile());
                }
                if (this.outRoot == null) {
                    this.setOutputRoot(out.getParentFile());
                }
                try {
                    this.setupSession();
                }
                catch (IllegalConfigurationException e) {
                    throw new ProcessingException(this, null, e);
                }
                try {
                    if (!FileUtil.isInsideOrEquals(src, this.srcRoot)) {
                        throw new IOException("The source file (" + src.getPath() + ") is not inside the source root (" + this.srcRoot.getPath() + ")");
                    }
                    if (!FileUtil.isInsideOrEquals(out, this.outRoot)) {
                        throw new IOException("The output file (" + out.getPath() + ") is not inside the output root (" + this.outRoot.getPath() + ")");
                    }
                    while (this.currentTurn <= this.maxTurn) {
                        this.processFile(src, out, false);
                        ++this.currentTurn;
                    }
                }
                finally {
                    this.cleanupSession();
                }
            }
            catch (ProcessingException e) {
                this.progListeners.notifyProgressEvent(this, 4, null, 0, e, null);
                throw e;
            }
            catch (IOException e) {
                this.progListeners.notifyProgressEvent(this, 4, null, 0, e, null);
                throw new ProcessingException(this, null, e);
            }
            this.progListeners.notifyProgressEvent(this, 4, null, 0, null, null);
        }
        finally {
            if (oldSrcRoot == null) {
                this.srcRoot = null;
            }
            if (oldOutRoot == null) {
                this.outRoot = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupSession() throws IOException, IllegalConfigurationException {
        if (this.srcRoot == null) {
            throw new IllegalConfigurationException("The source root directory was not set.");
        }
        if (this.outRoot == null) {
            throw new IllegalConfigurationException("The output root directory was not set.");
        }
        if (!this.srcRoot.exists()) {
            throw new IOException("Source root directory does not exists.");
        }
        if (!this.srcRoot.isDirectory()) {
            throw new IOException("Source root is not a directory.");
        }
        if (this.outRoot.exists() && !this.outRoot.isDirectory()) {
            throw new IOException("Output root is not a directory.");
        }
        boolean done = false;
        try {
            if (!this.xpathEngine.equals(XPATH_ENGINE_DONT_SET)) {
                XmlDependentOps xmlOps;
                try {
                    xmlOps = this.getXmlDependentOps("Set XPath engine.");
                }
                catch (InstallationException e) {
                    throw new IllegalConfigurationException("Can't set the XPath engine.", e);
                }
                xmlOps.setFreeMarkerXPathEngine(this.xpathEngine);
            }
            this.maxTurn = 1;
            Iterator<Object> it = this.turnChoosers.iterator();
            while (it.hasNext()) {
                int t = ((TurnChooser)it.next()).turn;
                if (t <= this.maxTurn) continue;
                this.maxTurn = t;
            }
            this.currentTurn = 1;
            this.fmCfg.setTemplateLoader((TemplateLoader)new FmppTemplateLoader(this));
            this.fmCfg.clearTemplateCache();
            this.fmCfg.clearSharedVariables();
            it = this.data.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry ent = (Map.Entry)it.next();
                try {
                    this.fmCfg.setSharedVariable((String)ent.getKey(), ent.getValue());
                }
                catch (TemplateModelException e) {
                    throw new IllegalConfigurationException("Failed to convert data " + StringUtil.jQuote((String)ent.getKey()) + " to FreeMarker variable.", e);
                }
            }
            this.processedFiles.clear();
            this.ignoredDirCache.clear();
            this.templateEnv.setupForSession();
            this.lockParameters();
            done = true;
        }
        finally {
            if (!done) {
                this.cleanupSession();
            }
        }
    }

    private void cleanupSession() {
        this.unlockParameters();
        this.templateEnv.cleanAfterSession();
        this.processedFiles.clear();
        this.ignoredDirCache.clear();
        this.fmCfg.clearTemplateCache();
        this.fmCfg.clearSharedVariables();
    }

    private boolean processDir(File srcDir, File dstDir) throws IOException, ProcessingException {
        if (this.isDirMarkedWithIgnoreFile(srcDir)) {
            return true;
        }
        File[] dir = srcDir.listFiles();
        for (int i = 0; i < dir.length; ++i) {
            File sf = dir[i];
            String fn = sf.getName();
            File df = new File(dstDir, fn);
            if (sf.isDirectory()) {
                this.processDir(sf, df);
                continue;
            }
            this.processFile(sf, df, true);
        }
        return false;
    }

    private boolean processFile(File sf, File df, boolean allowOutFAdj) throws IOException, ProcessingException {
        if (this.currentTurn != this.getTurn(sf)) {
            return false;
        }
        if (this.isDirMarkedWithIgnoreFile(sf.getParentFile().getCanonicalFile())) {
            return true;
        }
        if (!this.processedFiles.add(sf)) {
            return true;
        }
        int pmode = this.getProcessingMode(sf);
        Throwable catchedExc = null;
        try {
            if (allowOutFAdj && pmode != 3) {
                df = this.addjustOutputFileName(df);
            }
            if (!this.expertMode && pmode != 3 && sf.equals(df)) {
                throw new IOException("The input and output files are the same (" + sf.getPath() + "); if you want to allow this, " + "you should turn on expert mode.");
            }
            if (pmode != 3 && (this.skipUnchanged == 2 || this.skipUnchanged == 1 && pmode == 2)) {
                long dfl = df.lastModified();
                long sfl = sf.lastModified();
                if (df.exists() && dfl > 0L && sfl > 0L && dfl >= sfl) {
                    this.progListeners.notifyProgressEvent(this, 7, sf, pmode, null, null);
                    return true;
                }
            }
        }
        catch (Throwable e) {
            catchedExc = e;
        }
        this.progListeners.notifyProgressEvent(this, 2, sf, pmode, null, null);
        try {
            if (catchedExc != null) {
                throw catchedExc;
            }
            switch (pmode) {
                case 1: {
                    this.executeFile(sf, df);
                    break;
                }
                case 2: {
                    File dstDir = df.getParentFile();
                    if (dstDir != null) {
                        dstDir.mkdirs();
                    }
                    FileUtil.copyFile(sf, df);
                    break;
                }
                case 4: {
                    this.renderXmlFile(sf, df);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new BugException("Bad processing mode in the procModeChoosers:" + pmode);
                }
            }
        }
        catch (Throwable e) {
            catchedExc = e;
            this.progListeners.notifyProgressEvent(this, 3, sf, pmode, e, null);
        }
        if (catchedExc == null) {
            this.progListeners.notifyProgressEvent(this, 3, sf, pmode, null, null);
        } else if (this.stopOnError || catchedExc instanceof OutOfMemoryError) {
            throw new ProcessingException(this, sf, catchedExc);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeFile(File sf, File df) throws ProcessingException, DataModelBuildingException, TemplateException, IOException {
        Template template = this.fmCfg.getTemplate(FileUtil.pathToUnixStyle(FileUtil.getRelativePath(this.srcRoot, sf)));
        String outEnc = this.getOutputEncoding();
        if (this.outputEncoding.equalsIgnoreCase(PARAMETER_VALUE_SOURCE)) {
            outEnc = template.getEncoding();
        }
        FmppFileOutputWriter out = new FmppFileOutputWriter(this, df, outEnc);
        boolean done = false;
        try {
            this.templateEnv.execute(template, out, sf, null, null, null);
            done = true;
            ((FmppOutputWriter)out).close(!done);
        }
        catch (Throwable throwable) {
            ((FmppOutputWriter)out).close(!done);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renderXmlFile(File sf, File df) throws ProcessingException, DataModelBuildingException, TemplateException, IOException, InstallationException, GenericProcessingException {
        Template template;
        TemplateNodeModel wrappedDoc;
        boolean doctMustBeValidated;
        Object o;
        int xrcci;
        XmlRenderingConfiguration xrc = null;
        XmlDependentOps xops = this.getXmlDependentOps("Rendering XML file " + sf.getAbsolutePath() + ".");
        String sfPathForComparison = null;
        Object loadedDoc = null;
        boolean isLoadedDocumentValidated = false;
        int xrccln = this.xmlRendCfgCntrs.size();
        for (xrcci = 0; xrcci < xrccln; ++xrcci) {
            int i;
            XmlRenderingCfgContainer xrcc = (XmlRenderingCfgContainer)this.xmlRendCfgCntrs.get(xrcci);
            int ln = xrcc.compiledPathPatterns.length;
            if (ln != 0) {
                if (sfPathForComparison == null) {
                    sfPathForComparison = this.normalizePathForComparison(FileUtil.pathToUnixStyle(FileUtil.getRelativePath(this.srcRoot, sf)));
                }
                for (i = 0; i < ln && !this.reMatcher.matches(sfPathForComparison, xrcc.compiledPathPatterns[i]); ++i) {
                }
                if (i == ln) continue;
            }
            if ((ln = (xrc = xrcc.xmlRenderingCfg).getDocumentElementLocalNames().size()) == 0) break;
            if (loadedDoc == null) {
                o = xrc.getXmlDataLoaderOptions().get("validate");
                if (o == null) {
                    o = this.getValidateXml() ? Boolean.TRUE : Boolean.FALSE;
                }
                isLoadedDocumentValidated = Boolean.TRUE.equals(o);
                while (true) {
                    try {
                        loadedDoc = xops.loadXmlFile(this, sf, isLoadedDocumentValidated);
                    }
                    catch (Exception e) {
                        if (!isLoadedDocumentValidated) throw new DataModelBuildingException("Failed to load XML source file.", e);
                        isLoadedDocumentValidated = false;
                        continue;
                    }
                    break;
                }
            }
            List localNames = xrc.getDocumentElementLocalNames();
            List namespaces = xrc.getDocumentElementNamespaces();
            for (i = 0; i < ln && !xops.documentElementEquals(loadedDoc, (String)namespaces.get(i), (String)localNames.get(i)); ++i) {
            }
            if (i != ln) break;
        }
        if (xrcci == xrccln) {
            throw new GenericProcessingException("The source file has to be processed in \"renderXml\" mode, but there is no matching XML rendering configuration for it. (Check the if... options of the XML rendering configurations)");
        }
        if (xrc.getCopy()) {
            File dstDir = df.getParentFile();
            if (dstDir != null) {
                dstDir.mkdirs();
            }
            FileUtil.copyFile(sf, df);
            return;
        }
        o = xrc.getXmlDataLoaderOptions().get("validate");
        if (o == null) {
            Boolean bl = o = this.getValidateXml() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (isLoadedDocumentValidated != (doctMustBeValidated = Boolean.TRUE.equals(o))) {
            loadedDoc = null;
        }
        if (loadedDoc == null) {
            try {
                loadedDoc = xops.loadXmlFile(this, sf, doctMustBeValidated);
            }
            catch (Exception e) {
                throw new DataModelBuildingException("Failed to load the XML source file.", e);
            }
        }
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add("");
        args.add(xrc.getXmlDataLoaderOptions());
        try {
            wrappedDoc = xops.loadWithXmlDataLoader(this, args, loadedDoc);
        }
        catch (Exception e) {
            throw new DataModelBuildingException("Failed to load the XML source file.", e);
        }
        try {
            template = this.fmCfg.getTemplate(xrc.getTemplatePath());
        }
        catch (IOException e) {
            throw new GenericProcessingException("Failed to load the template specified by the XML rendering configuration: " + xrc.getTemplatePath(), e);
        }
        String outEnc = this.getOutputEncoding();
        if (this.outputEncoding.equalsIgnoreCase(PARAMETER_VALUE_SOURCE)) {
            outEnc = template.getEncoding();
        }
        FmppFileOutputWriter out = new FmppFileOutputWriter(this, df, outEnc);
        boolean done = false;
        try {
            this.templateEnv.execute(template, out, sf, loadedDoc, wrappedDoc, xrc.getLocalDataBuilders());
            done = true;
            ((FmppOutputWriter)out).close(!done);
        }
        catch (Throwable throwable) {
            ((FmppOutputWriter)out).close(!done);
            throw throwable;
        }
    }

    public boolean getStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.checkParameterLock();
        this.stopOnError = stopOnError;
    }

    public File getOutputRoot() {
        return this.outRoot;
    }

    public void setOutputRoot(File outputRoot) throws IOException {
        this.checkParameterLock();
        this.outRoot = outputRoot.getCanonicalFile();
    }

    public File getSourceRoot() {
        return this.srcRoot;
    }

    public void setSourceRoot(File srcRoot) throws IOException {
        this.checkParameterLock();
        this.srcRoot = srcRoot != null ? srcRoot.getCanonicalFile() : null;
    }

    public File getDataRoot() {
        if (this.dataRoot == null) {
            return this.srcRoot;
        }
        return this.dataRoot;
    }

    public void setDataRoot(File dataRoot) throws IOException {
        this.checkParameterLock();
        this.dataRoot = dataRoot == null || dataRoot.equals(PARAMETER_VALUE_SOURCE) ? null : dataRoot.getCanonicalFile();
    }

    public void addFreemarkerLink(String name, File fileOrDir) throws IOException {
        this.checkParameterLock();
        if (name == null) {
            throw new IllegalArgumentException("The \"name\" argument to the \"Engine.addIncludeDirectory\" method can't be null.");
        }
        if (name.startsWith("@")) {
            throw new IllegalArgumentException("The \"name\" argument to the \"Engine.addIncludeDirectory\" method can't start with @. The @ prefix is used only when you refer to a FreeMarker link. It is not part of the link name. For example, if the link name is \"foo\", then you can refer to it as <#include '/@foo/something.ftl'>.");
        }
        if (fileOrDir == null) {
            throw new IllegalArgumentException("The \"fileOrDir\" argument to the \"Engine.addIncludeDirectory\" method can't be null.");
        }
        fileOrDir = fileOrDir.getCanonicalFile();
        ArrayList<File> dirs = (ArrayList<File>)this.freemarkerLinks.get(name);
        if (dirs == null) {
            dirs = new ArrayList<File>();
            this.freemarkerLinks.put(name, dirs);
        }
        dirs.add(fileOrDir);
    }

    public List getFreemarkerLink(String name) {
        return (List)this.freemarkerLinks.get(name);
    }

    public void clearFreemarkerLinks() {
        this.checkParameterLock();
        this.freemarkerLinks.clear();
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkParameterLock();
        this.progListeners.addUserListener(listener);
    }

    public void clearProgressListeners() {
        this.checkParameterLock();
        this.progListeners.clearUserListeners();
    }

    public void setTemplateDataModelBuilder(TemplateDataModelBuilder tdmBuilder) {
        this.checkParameterLock();
        this.tdmBuilder = tdmBuilder;
    }

    public void setTemplateDataModelBuilder(String className) throws DataModelBuildingException {
        Class<?> clazz;
        this.checkParameterLock();
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException exc) {
            throw new DataModelBuildingException("Template data builder class not found: " + className);
        }
        if (clazz.isInterface()) {
            throw new DataModelBuildingException("Template data builder class must be a class, but this is an interface: " + clazz.getName());
        }
        if (!(class$fmpp$TemplateDataModelBuilder == null ? (class$fmpp$TemplateDataModelBuilder = Engine.class$("fmpp.TemplateDataModelBuilder")) : class$fmpp$TemplateDataModelBuilder).isAssignableFrom(clazz)) {
            throw new DataModelBuildingException("Template data builder class must implement TemplateDataModelBuilder interface, but this class doesn't implement that: " + clazz.getName());
        }
        try {
            this.setTemplateDataModelBuilder((TemplateDataModelBuilder)clazz.newInstance());
        }
        catch (InstantiationException exc) {
            throw new DataModelBuildingException("Failed to create an instance of " + clazz.getName() + ": " + exc, exc);
        }
        catch (IllegalAccessException exc) {
            throw new DataModelBuildingException("Failed to create an instance of " + clazz.getName() + ": " + exc, exc);
        }
    }

    public TemplateDataModelBuilder getTemplateDataModelBuilder() {
        return this.tdmBuilder;
    }

    public void setSourceEncoding(String encoding) {
        this.checkParameterLock();
        if (encoding == null || encoding.equals(PARAMETER_VALUE_HOST)) {
            this.fmCfg.setDefaultEncoding(System.getProperty("file.encoding"));
        } else {
            this.fmCfg.setDefaultEncoding(encoding);
        }
    }

    public String getSourceEncoding() {
        return this.fmCfg.getDefaultEncoding();
    }

    public void setLocale(Locale locale) {
        this.checkParameterLock();
        if (locale == null) {
            this.fmCfg.setLocale(Locale.getDefault());
        } else {
            this.fmCfg.setLocale(locale);
        }
    }

    public void setLocale(String locale) {
        this.checkParameterLock();
        if (locale == null || locale.equals(PARAMETER_VALUE_HOST)) {
            this.fmCfg.setLocale(Locale.getDefault());
        } else {
            String[] codes = StringUtil.split(locale + "__", '_');
            this.fmCfg.setLocale(new Locale(codes[0], codes[1], codes[2]));
        }
    }

    public Locale getLocale() {
        return this.fmCfg.getLocale();
    }

    public void setOldTemplateSyntax(boolean oldSyntax) {
        this.checkParameterLock();
        this.fmCfg.setStrictSyntaxMode(!oldSyntax);
    }

    public boolean getOldTemplateSyntax() {
        return !this.fmCfg.getStrictSyntaxMode();
    }

    public void setTagSyntax(int tagSyntax) {
        this.checkParameterLock();
        this.fmCfg.setTagSyntax(tagSyntax);
    }

    public int getTagSyntax() {
        return this.fmCfg.getTagSyntax();
    }

    public void setOutputEncoding(String outputEncoding) {
        this.checkParameterLock();
        this.outputEncoding = outputEncoding == null ? PARAMETER_VALUE_SOURCE : (outputEncoding.equals(PARAMETER_VALUE_HOST) ? System.getProperty("file.encoding") : outputEncoding);
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setUrlEscapingCharset(String urlEscapingCharset) {
        this.checkParameterLock();
        if (urlEscapingCharset == null || urlEscapingCharset.equals(PARAMETER_VALUE_OUTPUT)) {
            this.urlEscapingCharset = PARAMETER_VALUE_OUTPUT;
            this.fmCfg.setURLEscapingCharset(null);
        } else if (urlEscapingCharset.equals(PARAMETER_VALUE_HOST)) {
            this.urlEscapingCharset = System.getProperty("file.encoding");
            this.fmCfg.setURLEscapingCharset(this.urlEscapingCharset);
        } else {
            this.urlEscapingCharset = urlEscapingCharset;
            this.fmCfg.setURLEscapingCharset(this.urlEscapingCharset);
        }
    }

    public String getUrlEscapingCharset() {
        return this.urlEscapingCharset;
    }

    public void setNumberFormat(String format) {
        this.checkParameterLock();
        this.fmCfg.setNumberFormat(format);
    }

    public String getNumberFormat() {
        return this.fmCfg.getNumberFormat();
    }

    public void setDateFormat(String format) {
        this.checkParameterLock();
        this.fmCfg.setDateFormat(format);
    }

    public String getDateFormat() {
        return this.fmCfg.getDateFormat();
    }

    public void setTimeFormat(String format) {
        this.checkParameterLock();
        this.fmCfg.setTimeFormat(format);
    }

    public String getTimeFormat() {
        return this.fmCfg.getTimeFormat();
    }

    public void setDateTimeFormat(String format) {
        this.checkParameterLock();
        this.fmCfg.setDateTimeFormat(format);
    }

    public String getDateTimeFormat() {
        return this.fmCfg.getDateTimeFormat();
    }

    public void setTimeZone(TimeZone zone) {
        this.checkParameterLock();
        this.fmCfg.setTimeZone(zone);
    }

    public TimeZone getTimeZone() {
        return this.fmCfg.getTimeZone();
    }

    public void addModeChooser(String pattern, int pmode) {
        this.checkParameterLock();
        PModeChooser chooser = new PModeChooser(pattern);
        if (pmode != 1 && pmode != 4 && pmode != 2 && pmode != 3) {
            throw new IllegalArgumentException("Illegal processing mode was passed to Engine.addProcessingModeChooser: " + pmode);
        }
        chooser.pMode = pmode;
        this.pModeChoosers.add(chooser);
    }

    public void addHeaderChooser(String pattern, String header) {
        this.checkParameterLock();
        this.headerChoosers.addChooser(0, pattern, header);
    }

    public void addHeaderChooser(int layer, String pattern, String footer) {
        this.checkParameterLock();
        this.headerChoosers.addChooser(layer, pattern, footer);
    }

    public void addFooterChooser(String pattern, String footer) {
        this.checkParameterLock();
        this.footerChoosers.addChooser(0, pattern, footer);
    }

    public void addFooterChooser(int layer, String pattern, String footer) {
        this.checkParameterLock();
        this.footerChoosers.addChooser(layer, pattern, footer);
    }

    public void addTurnChooser(String pattern, int turn) {
        this.checkParameterLock();
        TurnChooser chooser = new TurnChooser(pattern);
        chooser.turn = turn;
        this.turnChoosers.add(chooser);
    }

    public void clearModeChoosers() {
        this.checkParameterLock();
        this.pModeChoosers.clear();
    }

    public void clearHeaderChoosers() {
        this.checkParameterLock();
        this.headerChoosers.clear();
    }

    public void clearFooterChoosers() {
        this.checkParameterLock();
        this.footerChoosers.clear();
    }

    public void clearTurnChoosers() {
        this.checkParameterLock();
        this.turnChoosers.clear();
    }

    public void setCaseSensitive(boolean cs) {
        this.checkParameterLock();
        if (this.csPathCmp != cs) {
            this.csPathCmp = cs;
            Iterator it = this.pModeChoosers.iterator();
            while (it.hasNext()) {
                ((Chooser)it.next()).recompile();
            }
            it = this.turnChoosers.iterator();
            while (it.hasNext()) {
                ((Chooser)it.next()).recompile();
            }
            it = this.xmlRendCfgCntrs.iterator();
            while (it.hasNext()) {
                ((XmlRenderingCfgContainer)it.next()).recompile();
            }
            this.headerChoosers.recompile();
            this.footerChoosers.recompile();
            this.localDataBuilders.recompile();
        }
    }

    public boolean getCaseSensitive() {
        return this.csPathCmp;
    }

    public void setExpertMode(boolean expertMode) {
        this.checkParameterLock();
        this.expertMode = expertMode;
    }

    public boolean getExpertMode() {
        return this.expertMode;
    }

    public void addRemovePostfix(String postfix) {
        this.checkParameterLock();
        if (postfix == null || postfix.length() == 0) {
            throw new IllegalArgumentException("engine parameter \"remove postfix\" can't be empty string");
        }
        if (postfix.indexOf(".") != -1) {
            throw new IllegalArgumentException("engine parameter \"remove postfix\" can't contain dot: " + postfix);
        }
        this.removePostfixes.add(postfix);
    }

    public void addRemoveExtension(String extension) {
        this.checkParameterLock();
        this.checkExtension("remove extension", extension);
        this.removeExtensions.add(extension);
    }

    public void addReplaceExtension(String oldExtension, String newExtension) {
        this.checkParameterLock();
        this.checkExtension("replace extension", oldExtension);
        this.checkExtension("replace extension", newExtension);
        this.replaceExtensions.add(new String[]{oldExtension, newExtension});
    }

    private void checkExtension(String paramName, String extension) {
        if (extension == null || extension.length() == 0) {
            throw new IllegalArgumentException("Problem with engine parameter \"" + paramName + "\": extension can't be empty string");
        }
        if (extension.startsWith(".")) {
            throw new IllegalArgumentException("Problem with parameter \"" + paramName + "\": extension can't start with dot: " + extension);
        }
    }

    public void clearRemovePostfixes() {
        this.checkParameterLock();
        this.removePostfixes.clear();
    }

    public void clearRemoveExtensions() {
        this.checkParameterLock();
        this.removeExtensions.clear();
    }

    public void clearReplaceExtensions() {
        this.checkParameterLock();
        this.replaceExtensions.clear();
    }

    public void setSkipUnchanged(int skipWhat) {
        this.checkParameterLock();
        this.skipUnchanged = skipWhat;
    }

    public int getSkipUnchanged() {
        return this.skipUnchanged;
    }

    public void setIgnoreCvsFiles(boolean ignoreCvsFiles) {
        this.checkParameterLock();
        this.ignoreCvsFiles = ignoreCvsFiles;
    }

    public boolean getIgnoreCvsFiles() {
        return this.ignoreCvsFiles;
    }

    public void setIgnoreSvnFiles(boolean ignoreSvnFiles) {
        this.checkParameterLock();
        this.ignoreSvnFiles = ignoreSvnFiles;
    }

    public boolean getIgnoreSvnFiles() {
        return this.ignoreSvnFiles;
    }

    public void setIgnoreTemporaryFiles(boolean ignoreTemporaryFiles) {
        this.checkParameterLock();
        this.ignoreTemporaryFiles = ignoreTemporaryFiles;
    }

    public boolean getIgnoreTemporaryFiles() {
        return this.ignoreTemporaryFiles;
    }

    public void setXpathEngine(String xpathEngine) {
        this.checkParameterLock();
        this.xpathEngine = xpathEngine;
    }

    public String getXpathEngine() {
        return this.xpathEngine;
    }

    public void setXmlEntityResolver(Object xmlEntityResolver) throws InstallationException {
        XmlDependentOps xmlOps;
        this.checkParameterLock();
        if (xmlEntityResolver != null && !(xmlOps = this.getXmlDependentOps("Set XML entity resolver.")).isEntityResolver(xmlEntityResolver)) {
            throw new IllegalArgumentException("The argument to Engine.setXmlEntiryResolver must implement org.xml.sax.EntityResolver. The class of the argument was " + xmlEntityResolver.getClass().getName() + ".");
        }
        this.xmlEntityResolver = xmlEntityResolver;
    }

    public Object getXmlEntiryResolver() {
        return this.xmlEntityResolver;
    }

    public void setValidateXml(boolean validateXml) {
        this.checkParameterLock();
        this.validateXml = validateXml;
    }

    public boolean getValidateXml() {
        return this.validateXml;
    }

    public void addXmlRenderingConfiguration(XmlRenderingConfiguration xmlRendering) {
        if (xmlRendering.getTemplatePath() == null && !xmlRendering.getCopy()) {
            throw new IllegalArgumentException("Illegal XmlRenderingConfiguration: Either \"template\" must be non-null, or \"copy\" must be true.");
        }
        this.xmlRendCfgCntrs.add(new XmlRenderingCfgContainer(xmlRendering));
        List ldbs = xmlRendering.getLocalDataBuilders();
        int ln = ldbs.size();
        for (int i = 0; i < ln; ++i) {
            Object o = ldbs.get(i);
            if (!(o instanceof ProgressListener)) continue;
            this.progListeners.addXmlLdbListener((ProgressListener)o);
        }
    }

    public void clearXmlRenderingConfigurations() {
        this.xmlRendCfgCntrs.clear();
        this.progListeners.clearXmlLdbListeners();
    }

    public void addData(String name, Object value) {
        this.checkParameterLock();
        this.data.put(name, value);
    }

    public void addData(String name, byte value) {
        this.checkParameterLock();
        this.data.put(name, new Byte(value));
    }

    public void addData(String name, short value) {
        this.checkParameterLock();
        this.data.put(name, new Short(value));
    }

    public void addData(String name, int value) {
        this.checkParameterLock();
        this.data.put(name, new Integer(value));
    }

    public void addData(String name, long value) {
        this.checkParameterLock();
        this.data.put(name, new Long(value));
    }

    public void addData(String name, float value) {
        this.checkParameterLock();
        this.data.put(name, new Float(value));
    }

    public void addData(String name, double value) {
        this.checkParameterLock();
        this.data.put(name, new Double(value));
    }

    public void addData(String name, char value) {
        this.checkParameterLock();
        this.data.put(name, new Character(value));
    }

    public void addData(String name, boolean value) {
        this.checkParameterLock();
        this.data.put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void addData(Map map) {
        this.checkParameterLock();
        this.data.putAll(map);
    }

    public void clearData() {
        this.checkParameterLock();
        this.data.clear();
    }

    public Object getData(String name) {
        return this.data.get(name);
    }

    public Object removeData(String name) {
        return this.data.remove(name);
    }

    public void clearSharedVariables() {
        this.clearData();
    }

    public void addLocalDataBuilder(int layer, String pathPattern, LocalDataBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument \"builder\" to addLocalDataBuilder can't be null.");
        }
        this.localDataBuilders.addChooser(layer, pathPattern, builder);
        if (builder instanceof ProgressListener) {
            this.progListeners.addLdbListener((ProgressListener)((Object)builder));
        }
    }

    public void clearLocalDataBuilders() {
        this.localDataBuilders.clear();
        this.progListeners.clearLdbListeners();
    }

    public static String getProgressListenerEventName(int event) {
        if (event == 2) {
            return "begin file processing";
        }
        if (event == 1) {
            return "begin processing session";
        }
        if (event == 3) {
            return "end file processing";
        }
        if (event == 4) {
            return "end processing session";
        }
        if (event == 5) {
            return "ignoring dir";
        }
        if (event == 7) {
            return "source not modified";
        }
        if (event == 6) {
            return "warning";
        }
        return "event code " + event;
    }

    public TemplateModel wrap(Object obj) throws TemplateModelException {
        return this.fmCfg.getObjectWrapper().wrap(obj);
    }

    public TemplateEnvironment getTemplateEnvironment() {
        if (this.templateEnv.isExternallyAccessible()) {
            return this.templateEnv;
        }
        throw new IllegalStateException("You can't get the TemplateEnvironment, since no template execution is in progress currently.");
    }

    public boolean isTemplateEnvironmentAvailable() {
        return this.templateEnv.isExternallyAccessible();
    }

    public Object setAttribute(String name, Object value) {
        Object oldValue = this.attributes.put(name, value);
        if (value instanceof ProgressListener) {
            this.progListeners.addAttrListener((ProgressListener)value);
        }
        if (oldValue instanceof ProgressListener && !MiscUtil.mapContainsObject(this.attributes, oldValue)) {
            this.progListeners.removeAttrListener((ProgressListener)oldValue);
        }
        return oldValue;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object removeAttribute(String name) {
        Object oldValue = this.attributes.remove(name);
        if (oldValue instanceof ProgressListener && !MiscUtil.mapContainsObject(this.attributes, oldValue)) {
            this.progListeners.removeAttrListener((ProgressListener)oldValue);
        }
        return oldValue;
    }

    public void clearAttribues() {
        this.progListeners.clearAttrListeners();
        this.attributes.clear();
    }

    public static String getVersionNumber() {
        if (cachedVersion == null) {
            Engine.loadVersionInfo();
        }
        return cachedVersion;
    }

    public static String getBuildInfo() {
        if (cachedBuildInfo == null) {
            Engine.loadVersionInfo();
        }
        return cachedBuildInfo;
    }

    public static String getFreeMarkerVersionNumber() {
        return Configuration.getVersionNumber();
    }

    public boolean isXmlSupportAvailabile() {
        if (this.chachedXmlSupportAvailable != null) {
            return this.chachedXmlSupportAvailable;
        }
        try {
            MiscUtil.checkXmlSupportAvailability(null);
        }
        catch (InstallationException e) {
            this.chachedXmlSupportAvailable = Boolean.FALSE;
            return false;
        }
        this.chachedXmlSupportAvailable = Boolean.TRUE;
        return true;
    }

    public void checkXmlSupportAvailability(String requiredForThis) throws InstallationException {
        if (this.chachedXmlSupportAvailable != null && this.chachedXmlSupportAvailable.booleanValue()) {
            return;
        }
        try {
            MiscUtil.checkXmlSupportAvailability(requiredForThis);
        }
        catch (InstallationException e) {
            this.chachedXmlSupportAvailable = Boolean.FALSE;
            throw e;
        }
        this.chachedXmlSupportAvailable = Boolean.TRUE;
    }

    void sendWarning(File srcFile, String message) {
        try {
            this.progListeners.notifyProgressEvent(this, 6, srcFile, 0, null, message);
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }

    Reader wrapReader(Reader r, File f) throws IOException {
        String footer;
        int i;
        String header;
        List headers = this.headerChoosers.choose(f);
        List footers = this.footerChoosers.choose(f);
        int hc = headers.size();
        int fc = footers.size();
        if (hc == 0 && fc == 0) {
            return r;
        }
        StringBuffer sb = null;
        if (hc != 0) {
            if (hc == 1) {
                header = (String)headers.get(0);
            } else {
                sb = new StringBuffer(40 + hc * 80);
                for (i = 0; i < hc; ++i) {
                    sb.append((String)headers.get(i));
                }
                header = sb.toString();
            }
            header = this.moveHeaderAfterTheFtlDirective(header, r);
        } else {
            header = null;
        }
        if (fc != 0) {
            if (fc == 1) {
                footer = (String)footers.get(0);
            } else {
                if (sb == null) {
                    sb = new StringBuffer(40 + fc * 80);
                } else {
                    sb.setLength(0);
                }
                for (i = fc - 1; i >= 0; --i) {
                    sb.append((String)footers.get(i));
                }
                footer = sb.toString();
            }
        } else {
            footer = null;
        }
        return new BorderedReader(header, r, footer);
    }

    List getLocalDataBuildersForFile(File sf) throws IOException {
        return this.localDataBuilders.choose(sf);
    }

    Pattern pathPatternToOroPattern(String path) {
        String originalPattern = path;
        path = FileUtil.pathToUnixStyle(path);
        if (!this.csPathCmp) {
            path = path.toLowerCase();
        }
        path = FileUtil.pathPatternToPerl5Regex(path);
        try {
            return this.reCompiler.compile(path, 32768);
        }
        catch (MalformedPatternException exc) {
            throw new BugException("Failed to parse path pattern: " + originalPattern, exc);
        }
    }

    private String moveHeaderAfterTheFtlDirective(String header, Reader r) throws IOException {
        block14: {
            int wbln;
            StringBuffer sb = new StringBuffer(64);
            char[] wb = new char[64];
            int mode = 0;
            int submode = 0;
            char quot = ' ';
            int cmpIdx = 0;
            do {
                wbln = r.read(wb);
                for (int i = 0; i < wbln; ++i) {
                    char c = wb[i];
                    if (mode == 0) {
                        if (Character.isWhitespace(c)) continue;
                        mode = 1;
                    }
                    if (mode == 1) {
                        if (cmpIdx < 5 && c == "<#ftl".charAt(cmpIdx)) {
                            ++cmpIdx;
                            continue;
                        }
                        if (cmpIdx == 5 && (Character.isWhitespace(c) || c == '>' || c == '/')) {
                            mode = 2;
                        } else {
                            mode = -1;
                            break;
                        }
                    }
                    if (mode != 2) continue;
                    if (submode == 0) {
                        if (c == '>') {
                            sb.append(wb, 0, i + 1);
                            sb.append(header);
                            if (i < wbln - 1) {
                                sb.append(wb, i + 1, wbln - (i + 1));
                            }
                            header = sb.toString();
                            break block14;
                        }
                        if (c != '\'' && c != 34) continue;
                        quot = c;
                        if (i != 0 && wb[i - 1] == 'r' || sb.length() > 0 && sb.charAt(sb.length() - 1) == 'r') {
                            submode = 2;
                            continue;
                        }
                        submode = 1;
                        continue;
                    }
                    if (submode == 1) {
                        if (c == '\\') {
                            submode = 3;
                            continue;
                        }
                        if (c != quot) continue;
                        submode = 0;
                        continue;
                    }
                    if (submode == 2) {
                        if (c != quot) continue;
                        submode = 0;
                        continue;
                    }
                    if (submode != 3) continue;
                    submode = 1;
                }
                if (wbln <= 0) continue;
                sb.append(wb, 0, wbln);
            } while (wbln >= 64 && mode != -1);
            header = header + sb.toString();
        }
        return header;
    }

    private File addjustOutputFileName(File f) throws IOException {
        int e;
        int i;
        String fn = f.getName();
        String s = null;
        String s2 = null;
        if (!this.csPathCmp) {
            s2 = fn.toLowerCase();
        }
        int ln = this.removeExtensions.size();
        for (i = 0; i < ln; ++i) {
            s = "." + (String)this.removeExtensions.get(i);
            if (this.csPathCmp ? fn.endsWith(s) : s2.endsWith(s.toLowerCase())) break;
        }
        if (i != ln) {
            fn = fn.substring(0, fn.length() - s.length());
        }
        if ((e = fn.indexOf(46)) != -1) {
            s2 = fn.substring(0, e);
        } else {
            s2 = fn;
            e = fn.length();
        }
        if (!this.csPathCmp) {
            s2 = s2.toLowerCase();
        }
        ln = this.removePostfixes.size();
        for (i = 0; i < ln; ++i) {
            s = (String)this.removePostfixes.get(i);
            if (this.csPathCmp ? s2.endsWith(s) : s2.endsWith(s.toLowerCase())) break;
        }
        if (i != ln) {
            fn = fn.substring(0, e - s.length()) + fn.substring(e);
        }
        if (!this.csPathCmp) {
            s2 = fn.toLowerCase();
        }
        String[] entry = null;
        ln = this.replaceExtensions.size();
        for (i = 0; i < ln; ++i) {
            entry = (String[])this.replaceExtensions.get(i);
            if (this.csPathCmp ? fn.endsWith("." + entry[0]) : s2.endsWith("." + entry[0].toLowerCase())) break;
        }
        if (i != ln) {
            fn = fn.substring(0, fn.length() - entry[0].length()) + entry[1];
        }
        if (fn.length() == 0) {
            throw new IOException("The deduced output file name is empty for this source file: " + FileUtil.getRelativePath(this.outRoot, f));
        }
        return new File(f.getParent(), fn).getCanonicalFile();
    }

    private Chooser findChooser(LinkedList choosers, File f) throws IOException {
        String fp = FileUtil.getRelativePath(this.srcRoot, f);
        fp = this.normalizePathForComparison(FileUtil.pathToUnixStyle(fp));
        Iterator it = choosers.iterator();
        while (it.hasNext()) {
            Chooser c = (Chooser)it.next();
            if (!this.reMatcher.matches(fp, c.oroPattern)) continue;
            return c;
        }
        return null;
    }

    private String normalizePathForComparison(String fp) {
        if (fp.endsWith("/")) {
            fp = fp.substring(0, fp.length() - 1);
        }
        if (!fp.startsWith("/")) {
            fp = "/" + fp;
        }
        if (!this.csPathCmp) {
            fp = fp.toLowerCase();
        }
        return fp;
    }

    private int getProcessingMode(File f) throws IOException {
        String fpathCisUpper;
        String fpathCisLower;
        String fnameCisLower;
        String fnameCs = f.getName();
        String fpathCs = f.getAbsolutePath();
        if (!this.csPathCmp) {
            fnameCisLower = fnameCs.toLowerCase();
            fpathCisLower = fpathCs.toLowerCase();
            fpathCisUpper = fpathCs.toUpperCase();
        } else {
            fnameCisLower = fnameCs;
            fpathCisLower = fpathCs;
            fpathCisUpper = fpathCs;
        }
        int i = fnameCs.lastIndexOf(".");
        String extLower = i == -1 ? "" : fnameCs.substring(i + 1).toLowerCase();
        if (extLower.equals("fmpp")) {
            return 3;
        }
        if (this.ignoreCvsFiles && (fnameCisLower.equals(".cvsignore") || fpathCisUpper.indexOf("/CVS/") != -1 || fpathCisUpper.indexOf(File.separatorChar + "CVS" + File.separatorChar) != -1 || fnameCs.length() > 2 && fnameCs.startsWith(".#"))) {
            return 3;
        }
        if (this.ignoreSvnFiles && (fpathCisLower.indexOf("/.svn/") != -1 || fpathCisLower.indexOf(File.separatorChar + ".svn" + File.separatorChar) != -1)) {
            return 3;
        }
        if (this.ignoreTemporaryFiles && (fnameCs.length() > 2 && (fnameCs.startsWith("#") && fnameCs.endsWith("#") || fnameCs.startsWith("%") && fnameCs.endsWith("%") || fnameCs.startsWith("._") || extLower.equals("bak")) || fnameCs.length() > 1 && (fnameCs.endsWith("~") || fnameCs.startsWith("~") || extLower.startsWith("~")))) {
            return 3;
        }
        PModeChooser pmc = (PModeChooser)this.findChooser(this.pModeChoosers, f);
        if (pmc == null) {
            if (STATIC_FILE_EXTS.contains(extLower)) {
                return 2;
            }
            if (this.xmlRendCfgCntrs.size() != 0 && extLower.equals("xml")) {
                return 4;
            }
            return 1;
        }
        return pmc.pMode;
    }

    private int getTurn(File f) throws IOException {
        TurnChooser tc = (TurnChooser)this.findChooser(this.turnChoosers, f);
        if (tc == null) {
            return 1;
        }
        return tc.turn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadVersionInfo() {
        Properties vp = new Properties();
        InputStream ins = (class$fmpp$Engine == null ? (class$fmpp$Engine = Engine.class$("fmpp.Engine")) : class$fmpp$Engine).getClassLoader().getResourceAsStream("fmpp/version.properties");
        if (ins == null) {
            throw new RuntimeException("Version file (<CLASSES>/fmpp/version.properties) is missing.");
        }
        try {
            try {
                vp.load(ins);
            }
            finally {
                ins.close();
            }
        }
        catch (IOException exc) {
            throw new RuntimeException("Error loading version file (<CLASSES>/fmpp/version.properties): " + exc);
        }
        String v = vp.getProperty("version");
        if (v == null) {
            throw new RuntimeException("Version file (<CLASSES>/fmpp/version.properties) is corrupt: version key is missing.");
        }
        String d = vp.getProperty("buildInfo");
        if (d == null) {
            throw new RuntimeException("Version file (<CLASSES>/fmpp/version.properties) is corrupt: buildInfo key is missing.");
        }
        cachedVersion = v;
        cachedBuildInfo = d;
    }

    private XmlDependentOps getXmlDependentOps(String requiredForThis) throws InstallationException {
        if (this.xmlDependentOps == null) {
            Class cl;
            this.checkXmlSupportAvailability(requiredForThis);
            try {
                cl = MiscUtil.classForName("fmpp.XmlDependentOpsImpl");
            }
            catch (ClassNotFoundException e) {
                throw new BugException("Failed to get fmpp.XmlDependentOpsImpl.", e);
            }
            catch (SecurityException e) {
                throw new BugException("Failed to get fmpp.XmlDependentOpsImpl.", e);
            }
            try {
                this.xmlDependentOps = (XmlDependentOps)cl.newInstance();
            }
            catch (IllegalArgumentException e) {
                throw new BugException("Failed to instantiate fmpp.XmlDependentOpsImpl", e);
            }
            catch (IllegalAccessException e) {
                throw new BugException("Failed to instantiate fmpp.XmlDependentOpsImpl", e);
            }
            catch (InstantiationException e) {
                throw new BugException("Failed to instantiate fmpp.XmlDependentOpsImpl", e);
            }
        }
        return this.xmlDependentOps;
    }

    private void lockParameters() {
        this.parametersLocked = true;
    }

    private void unlockParameters() {
        this.parametersLocked = false;
    }

    private void checkParameterLock() {
        if (this.parametersLocked) {
            throw new IllegalStateException("You can't change the engine parameters now. Settings can't bechanged while the processing session is runing.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class XmlRenderingCfgContainer {
        final XmlRenderingConfiguration xmlRenderingCfg;
        Pattern[] compiledPathPatterns;

        XmlRenderingCfgContainer(XmlRenderingConfiguration xmlRendering) {
            this.xmlRenderingCfg = xmlRendering;
            this.recompile();
        }

        void recompile() {
            List pathPatterns = this.xmlRenderingCfg.getPathPatterns();
            int ln = pathPatterns.size();
            this.compiledPathPatterns = new Pattern[ln];
            for (int i = 0; i < ln; ++i) {
                this.compiledPathPatterns[i] = Engine.this.pathPatternToOroPattern((String)pathPatterns.get(i));
            }
        }
    }

    private class MultiProgressListener
    implements ProgressListener {
        private ArrayList userListeners = new ArrayList();
        private ArrayList attrListeners = new ArrayList();
        private ArrayList ldbListeners = new ArrayList();
        private ArrayList xmlLdbListeners = new ArrayList();
        private boolean mergedNeedsRefresh = true;
        private ArrayList mergedListeners = new ArrayList();

        private MultiProgressListener() {
        }

        void addUserListener(ProgressListener listener) {
            if (!MiscUtil.listContainsObject(this.userListeners, listener)) {
                this.userListeners.add(listener);
            }
        }

        void clearUserListeners() {
            this.mergedNeedsRefresh = true;
            this.userListeners.clear();
        }

        void addAttrListener(ProgressListener listener) {
            if (!MiscUtil.listContainsObject(this.attrListeners, listener)) {
                this.mergedNeedsRefresh = true;
                this.attrListeners.add(listener);
            }
        }

        void removeAttrListener(ProgressListener listener) {
            int i = MiscUtil.findObject(this.attrListeners, listener);
            if (i != -1) {
                this.mergedNeedsRefresh = true;
                this.attrListeners.remove(i);
            }
        }

        void clearAttrListeners() {
            this.mergedNeedsRefresh = true;
            this.attrListeners.clear();
        }

        void addLdbListener(ProgressListener listener) {
            if (!MiscUtil.listContainsObject(this.ldbListeners, listener)) {
                this.mergedNeedsRefresh = true;
                this.ldbListeners.add(listener);
            }
        }

        void clearLdbListeners() {
            this.mergedNeedsRefresh = true;
            this.ldbListeners.clear();
        }

        void addXmlLdbListener(ProgressListener listener) {
            if (!MiscUtil.listContainsObject(this.xmlLdbListeners, listener)) {
                this.mergedNeedsRefresh = true;
                this.xmlLdbListeners.add(listener);
            }
        }

        void clearXmlLdbListeners() {
            this.mergedNeedsRefresh = true;
            this.xmlLdbListeners.clear();
        }

        public void notifyProgressEvent(Engine engine, int event, File src, int pMode, Throwable error, Object param) throws ProcessingException {
            ProgressListener lr;
            if (this.mergedNeedsRefresh) {
                this.refreshMergedListeneres();
            }
            int doneCounter = 0;
            int closingEvent = this.getClosingEvent(event);
            ProcessingException firstException = null;
            Iterator it = this.mergedListeners.iterator();
            while (it.hasNext()) {
                lr = (ProgressListener)it.next();
                try {
                    lr.notifyProgressEvent(engine, event, src, pMode, error, param);
                }
                catch (Throwable e) {
                    if (firstException == null) {
                        firstException = new ProcessingException(Engine.this, src, new ExceptionCC("A listener Java object has failed to handle event \"" + Engine.getProgressListenerEventName(event) + "\". The class of the failing " + "listener object is " + lr.getClass().getName() + ".", e));
                    }
                    if (closingEvent != Integer.MIN_VALUE) break;
                }
                ++doneCounter;
            }
            if (firstException != null) {
                if (closingEvent != Integer.MIN_VALUE) {
                    it = this.mergedListeners.iterator();
                    while (it.hasNext() && doneCounter != 0) {
                        lr = (ProgressListener)it.next();
                        try {
                            lr.notifyProgressEvent(engine, closingEvent, src, pMode, error, param);
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        --doneCounter;
                    }
                }
                throw firstException;
            }
        }

        private void refreshMergedListeneres() {
            Object o;
            int i;
            this.mergedListeners.clear();
            int ln = this.xmlLdbListeners.size();
            for (i = 0; i < ln; ++i) {
                o = this.xmlLdbListeners.get(i);
                if (MiscUtil.listContainsObject(this.mergedListeners, o)) continue;
                this.mergedListeners.add(o);
            }
            ln = this.ldbListeners.size();
            for (i = 0; i < ln; ++i) {
                o = this.ldbListeners.get(i);
                if (MiscUtil.listContainsObject(this.mergedListeners, o)) continue;
                this.mergedListeners.add(o);
            }
            ln = this.attrListeners.size();
            for (i = 0; i < ln; ++i) {
                o = this.attrListeners.get(i);
                if (MiscUtil.listContainsObject(this.mergedListeners, o)) continue;
                this.mergedListeners.add(o);
            }
            ln = this.userListeners.size();
            for (i = 0; i < ln; ++i) {
                o = this.userListeners.get(i);
                if (MiscUtil.listContainsObject(this.mergedListeners, o)) continue;
                this.mergedListeners.add(o);
            }
            this.mergedNeedsRefresh = false;
        }

        private int getClosingEvent(int event) {
            if (event == 2) {
                return 3;
            }
            if (event == 1) {
                return 4;
            }
            return Integer.MIN_VALUE;
        }
    }

    private class LayeredChooser {
        private List layers = new ArrayList();
        private int usedLayers;

        private LayeredChooser() {
        }

        private void addChooser(int layer, String pathPattern, Object value) {
            if (layer < 0) {
                throw new IllegalArgumentException("Layer index can't be negative: " + layer);
            }
            ObjectChooser chooser = new ObjectChooser(pathPattern, value);
            for (int max = this.layers.size() - 1; max < layer; ++max) {
                this.layers.add(null);
            }
            LinkedList<ObjectChooser> choosers = (LinkedList<ObjectChooser>)this.layers.get(layer);
            if (choosers == null) {
                choosers = new LinkedList<ObjectChooser>();
                this.layers.set(layer, choosers);
                ++this.usedLayers;
            }
            choosers.add(chooser);
        }

        private List choose(File f) throws IOException {
            ArrayList<Object> result = new ArrayList<Object>(this.usedLayers);
            int ln = this.layers.size();
            for (int i = 0; i < ln; ++i) {
                ObjectChooser c;
                LinkedList choosers = (LinkedList)this.layers.get(i);
                if (choosers == null || (c = (ObjectChooser)Engine.this.findChooser(choosers, f)) == null) continue;
                result.add(c.value);
            }
            return result;
        }

        private void recompile() {
            int ln = this.layers.size();
            for (int i = 0; i < ln; ++i) {
                LinkedList choosers = (LinkedList)this.layers.get(i);
                Iterator it = choosers.iterator();
                while (it.hasNext()) {
                    ((Chooser)it.next()).recompile();
                }
            }
        }

        private void clear() {
            this.layers.clear();
            this.usedLayers = 0;
        }
    }

    private class ObjectChooser
    extends Chooser {
        private final Object value;

        ObjectChooser(String pathPattern, Object value) {
            super(pathPattern);
            this.value = value;
        }
    }

    private class TurnChooser
    extends Chooser {
        private int turn;

        TurnChooser(String pathPattern) {
            super(pathPattern);
        }
    }

    private class PModeChooser
    extends Chooser {
        private int pMode;

        PModeChooser(String pathPattern) {
            super(pathPattern);
        }
    }

    private class Chooser {
        private String pathPattern;
        private Pattern oroPattern;

        private Chooser(String pathPattern) {
            this.pathPattern = pathPattern;
            this.oroPattern = Engine.this.pathPatternToOroPattern(pathPattern);
        }

        void recompile() {
            this.oroPattern = Engine.this.pathPatternToOroPattern(this.pathPattern);
        }
    }
}

