/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.signal.ant.types;

import com.nokia.helium.core.EmailDataSender;
import com.nokia.helium.core.HlmAntLibException;
import com.nokia.helium.core.PropertiesSource;
import com.nokia.helium.core.TemplateProcessor;
import com.nokia.helium.core.XMLTemplateSource;
import com.nokia.helium.signal.Notifier;
import com.nokia.helium.signal.ant.types.NotifierInput;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;

public class EMAILNotifier
extends DataType
implements Notifier {
    private Logger log = Logger.getLogger(EmailDataSender.class);
    private TemplateProcessor templateProcessor = new TemplateProcessor();
    private File defaultTemplate;
    private File templateSrc;
    private String title;
    private String smtp;
    private String ldap;
    private String rootdn;
    private String notifyWhen = "never";
    private String from;
    private String additionalRecipients;

    @Override
    public void sendData(String signalName, boolean failStatus, List<String> fileList) {
        if (this.notifyWhen != null && (this.notifyWhen.equals("always") || this.notifyWhen.equals("fail") && failStatus || this.notifyWhen.equals("pass") && !failStatus)) {
            if (this.templateSrc == null) {
                throw new HlmAntLibException("signaling", "templateSrc attribute has not been defined.");
            }
            if (this.title == null) {
                throw new HlmAntLibException("signaling", "title attribute has not been defined.");
            }
            if (this.smtp == null) {
                throw new HlmAntLibException("signaling", "smtp attribute has not been defined.");
            }
            if (this.ldap == null) {
                throw new HlmAntLibException("signaling", "ldap attribute has not been defined.");
            }
            this.log.debug((Object)"Sending data by e-mail.");
            try {
                EmailDataSender emailSender;
                File emailOutputFile = File.createTempFile("helium_", "email.html");
                emailOutputFile.deleteOnExit();
                this.log.debug((Object)("sending data by e-mail:outputDir: " + emailOutputFile.getAbsolutePath()));
                ArrayList<Object> sourceList = new ArrayList<Object>();
                sourceList.add(new PropertiesSource("ant", (Map)this.getProject().getProperties()));
                Iterator<String> iter = fileList.iterator();
                String sourceBaseName = "doc";
                int count = 0;
                while (iter.hasNext()) {
                    String srcFile = iter.next();
                    sourceList.add(new XMLTemplateSource(sourceBaseName + count, new File(srcFile)));
                    ++count;
                }
                Hashtable<String, String> signalProperties = new Hashtable<String, String>();
                signalProperties.put("signal.name", signalName);
                signalProperties.put("signal.status", "" + failStatus);
                sourceList.add(new PropertiesSource("signaling", signalProperties));
                this.templateProcessor.convertTemplate(this.templateSrc, emailOutputFile, sourceList);
                if (this.rootdn != null) {
                    String[] to = null;
                    if (this.additionalRecipients != null) {
                        to = this.additionalRecipients.split(",");
                    }
                    emailSender = new EmailDataSender(to, this.smtp, this.ldap, this.rootdn);
                } else {
                    emailSender = new EmailDataSender(this.additionalRecipients, this.smtp, this.ldap);
                }
                if (this.from != null) {
                    emailSender.setFrom(this.from);
                }
                this.log.debug((Object)("EmailNotifier:arlist: " + this.additionalRecipients));
                Project subProject = this.getProject().createSubProject();
                subProject.setProperty("signal.name", signalName);
                subProject.setProperty("signal.status", "" + failStatus);
                emailSender.addCurrentUserToAddressList();
                emailSender.sendData("signaling", emailOutputFile.getAbsolutePath(), "application/html", subProject.replaceProperties(this.title), null);
            }
            catch (Exception e) {
                this.log.debug((Object)"EmailNotifier:exception: ", (Throwable)e);
            }
        }
    }

    @Override
    public void sendData(String signalName, boolean failStatus, NotifierInput notifierInput, String message) {
        if (this.notifyWhen != null && (this.notifyWhen.equals("always") || this.notifyWhen.equals("fail") && failStatus || this.notifyWhen.equals("pass") && !failStatus)) {
            EmailDataSender emailSender;
            if (this.title == null) {
                throw new HlmAntLibException("signaling", "title attribute has not been defined.");
            }
            if (this.smtp == null) {
                throw new HlmAntLibException("signaling", "smtp attribute has not been defined.");
            }
            if (this.ldap == null) {
                throw new HlmAntLibException("signaling", "ldap attribute has not been defined.");
            }
            String smtpUpdated = this.getProject().replaceProperties(this.smtp);
            String ldapUpdated = this.getProject().replaceProperties(this.ldap);
            String rootdnUpdated = this.getProject().replaceProperties(this.rootdn);
            String additionalRecipientsUpdated = this.getProject().replaceProperties(this.additionalRecipients);
            this.log.debug((Object)"Sending data by e-mail.");
            if (rootdnUpdated != null) {
                String[] to = null;
                if (additionalRecipientsUpdated != null) {
                    to = additionalRecipientsUpdated.split(",");
                }
                emailSender = new EmailDataSender(to, smtpUpdated, ldapUpdated, rootdnUpdated);
            } else {
                emailSender = new EmailDataSender(additionalRecipientsUpdated, smtpUpdated, ldapUpdated);
            }
            if (this.from != null) {
                emailSender.setFrom(this.from);
            }
            this.log.debug((Object)("EmailNotifier:arlist: " + additionalRecipientsUpdated));
            Project subProject = this.getProject().createSubProject();
            subProject.setProperty("signal.name", signalName);
            subProject.setProperty("signal.status", "" + failStatus);
            subProject.setProperty("signal.message", "" + message);
            emailSender.addCurrentUserToAddressList();
            String filePath = "";
            File fileToSend = null;
            if (notifierInput != null && (fileToSend = notifierInput.getFile(".*.html")) != null) {
                filePath = fileToSend.toString();
            }
            if (fileToSend == null) {
                try {
                    File emailOutputFile = File.createTempFile("helium_", "email.html");
                    emailOutputFile.deleteOnExit();
                    this.log.debug((Object)("sending data by e-mail:outputDir: " + emailOutputFile.getAbsolutePath()));
                    ArrayList<PropertiesSource> sourceList = new ArrayList<PropertiesSource>();
                    sourceList.add(new PropertiesSource("ant", (Map)this.getProject().getProperties()));
                    Hashtable<String, String> signalProperties = new Hashtable<String, String>();
                    signalProperties.put("signal.name", signalName);
                    signalProperties.put("signal.status", "" + failStatus);
                    signalProperties.put("signal.message", "" + message);
                    sourceList.add(new PropertiesSource("signaling", signalProperties));
                    this.templateProcessor.convertTemplate(this.defaultTemplate, emailOutputFile, sourceList);
                    filePath = emailOutputFile.toString();
                }
                catch (Exception e) {
                    this.log.debug((Object)"EmailNotifier:exception: ", (Throwable)e);
                }
            }
            emailSender.sendData("signaling", filePath, "application/html", subProject.replaceProperties(this.title), null);
        }
    }

    public void setNotifyWhen(String ntfyWhen) {
        this.notifyWhen = ntfyWhen;
    }

    public String getNotifyWhen() {
        return this.notifyWhen;
    }

    public void setDefaultTemplate(File template) {
        this.defaultTemplate = template;
    }

    public void setTemplateSrc(File template) {
        this.templateSrc = template;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSmtp(String smtp) {
        this.smtp = smtp;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setAdditionalRecipients(String ar) {
        this.additionalRecipients = ar;
    }

    public void setLdap(String ldap) {
        this.ldap = ldap;
    }

    public void setRootdn(String rootdn) {
        this.rootdn = rootdn;
    }
}

