/*
 * Decompiled with CFR 0.152.
 */
package fmpp.util;

import freemarker.ext.util.WrapperTemplateModel;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FreemarkerUtil {
    public static Object ftlVarToCoreJavaObject(TemplateModel m) throws TemplateModelException {
        if (m instanceof TemplateHashModel) {
            Object o;
            if (m instanceof WrapperTemplateModel && (o = ((WrapperTemplateModel)m).getWrappedObject()) instanceof Map) {
                return o;
            }
            if (m instanceof TemplateHashModelEx) {
                HashMap<String, Object> res = new HashMap<String, Object>();
                TemplateHashModelEx hash = (TemplateHashModelEx)m;
                TemplateModelIterator tit = hash.keys().iterator();
                while (tit.hasNext()) {
                    String key = ((TemplateScalarModel)tit.next()).getAsString();
                    res.put(key, FreemarkerUtil.ftlVarToCoreJavaObject(hash.get(key)));
                }
                return res;
            }
            throw new TemplateModelException("Can't convert hash variable to java.util.Map, because it is not a TemplateHashModelEx, so the keys can't be enumerated.");
        }
        if (m instanceof TemplateSequenceModel) {
            Object o;
            if (m instanceof WrapperTemplateModel && (o = ((WrapperTemplateModel)m).getWrappedObject()) instanceof List) {
                return o;
            }
            TemplateSequenceModel seq = (TemplateSequenceModel)m;
            int ln = seq.size();
            ArrayList<Object> res = new ArrayList<Object>(ln);
            for (int i = 0; i < ln; ++i) {
                res.add(FreemarkerUtil.ftlVarToCoreJavaObject(seq.get(i)));
            }
            return res;
        }
        if (m instanceof TemplateCollectionModel) {
            TemplateModelIterator tit = ((TemplateCollectionModel)m).iterator();
            ArrayList<Object> res = new ArrayList<Object>();
            while (tit.hasNext()) {
                res.add(FreemarkerUtil.ftlVarToCoreJavaObject(tit.next()));
            }
            return res;
        }
        if (m instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)m).getAsNumber();
        }
        if (m instanceof TemplateDateModel) {
            return ((TemplateDateModel)m).getAsDate();
        }
        if (m instanceof TemplateBooleanModel) {
            return ((TemplateBooleanModel)m).getAsBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (m instanceof TemplateScalarModel) {
            return ((TemplateScalarModel)m).getAsString();
        }
        return m;
    }
}

