/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.jpa;

import com.nokia.helium.jpa.ORMEntityManager;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;

public final class ORMUtil {
    private static Logger log = Logger.getLogger(ORMUtil.class);
    private static final int PERSISTANCE_COUNT_LIMIT = 1000;
    private static final int READ_CACHE_LIMIT = 30000;
    private static HashMap<String, ORMEntityManager> emMap = new HashMap();

    private ORMUtil() {
    }

    public static synchronized void initializeORM(String urlPath) {
        ORMEntityManager manager = emMap.get(urlPath);
        log.debug((Object)("initializeORM: urlpath: " + urlPath));
        if (manager == null) {
            try {
                manager = new ORMEntityManager(urlPath);
                emMap.put(urlPath, manager);
                log.debug((Object)("initializeORM: manager: " + manager));
                log.debug((Object)("initializeORM: manager: " + manager.getEntityManager()));
            }
            catch (Exception ex) {
                throw new BuildException("Entity Manager creation failure");
            }
        }
    }

    public static ORMEntityManager getEntityManager(String urlPath) {
        log.debug((Object)("getEntityManager: urlpath: " + urlPath));
        ORMEntityManager manager = emMap.get(urlPath);
        if (manager != null) {
            log.debug((Object)("getEntityManager: manager: " + manager));
            log.debug((Object)("getEntityManager: manager.entityManager: " + manager.getEntityManager()));
            return manager;
        }
        log.debug((Object)"getEntityManager: manager: is null");
        throw new BuildException("ORM entity manager is null");
    }

    public static void finalizeORM(String urlPath) {
        ORMEntityManager manager = emMap.get(urlPath);
        log.debug((Object)("finalizeORM: urlpath: " + urlPath));
        if (manager != null) {
            manager.finalizeEntityManager();
            manager = null;
            log.debug((Object)("finalizeORM: manager" + manager));
            emMap.remove(urlPath);
        }
    }
}

