/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Serialization;
import com.google.common.collect.StandardSetMultimap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashMultimap<K, V>
extends StandardSetMultimap<K, V> {
    private static final long serialVersionUID = 0L;

    public HashMultimap() {
        super(new HashMap());
    }

    public HashMultimap(Multimap<? extends K, ? extends V> multimap) {
        super(new HashMap(Maps.capacity(multimap.keySet().size())));
        this.putAll(multimap);
    }

    @Override
    Set<V> createCollection() {
        return new HashSet();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultimap(this, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.setMap(new HashMap());
        Serialization.populateMultimap(this, stream);
    }
}

