/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.taskdefs;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;

public class HlmExecTask
extends ExecTask {
    private static int poolSize = Runtime.getRuntime().availableProcessors();
    private static int maxPoolSize = poolSize * 2;
    private static ExecutorService threadPool = Executors.newFixedThreadPool(maxPoolSize);
    private final Object semaphore = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        String p = this.project.getProperty("number.of.threads");
        if (p != null) {
            ((ThreadPoolExecutor)threadPool).setCorePoolSize(Integer.parseInt(p));
            ((ThreadPoolExecutor)threadPool).setMaximumPoolSize(Integer.parseInt(p));
        }
        TaskRunnable tr = new TaskRunnable();
        threadPool.submit(tr);
        try {
            Object object = this.semaphore;
            synchronized (object) {
                while (!tr.isFinished()) {
                    this.semaphore.wait();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Throwable t = tr.getException();
        if (t != null) {
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            t.printStackTrace();
        }
    }

    private class TaskRunnable
    implements Runnable {
        private Task task;
        private boolean finished;
        private volatile Thread thread;
        private Throwable exception;

        private TaskRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.thread = Thread.currentThread();
                HlmExecTask.super.execute();
            }
            catch (Throwable t) {
                this.exception = t;
            }
            finally {
                Object object = HlmExecTask.this.semaphore;
                synchronized (object) {
                    this.finished = true;
                    HlmExecTask.this.semaphore.notifyAll();
                }
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        boolean isFinished() {
            return this.finished;
        }

        void interrupt() {
            this.thread.interrupt();
        }
    }
}

