/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.structures;

import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.mappings.structures.ArrayCollectionMapping;
import org.eclipse.persistence.mappings.structures.ArrayCollectionMappingHelper;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;

public class ArrayMapping
extends AbstractCompositeDirectCollectionMapping
implements ArrayCollectionMapping {
    public void setFieldName(String fieldName) {
        this.setField(new ObjectRelationalDatabaseField(fieldName));
    }

    public String getStructureName() {
        return this.getElementDataTypeName();
    }

    public void setStructureName(String structureName) {
        this.setElementDataTypeName(structureName);
    }

    public String getElementDataTypeName() {
        return this.elementDataTypeName;
    }

    public void setElementDataTypeName(String elementDataTypeName) {
        this.elementDataTypeName = elementDataTypeName;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getStructureName().length() == 0) {
            throw DescriptorException.structureNameNotSetInMapping(this);
        }
        ObjectRelationalDatabaseField field = (ObjectRelationalDatabaseField)this.getField();
        field.setSqlType(2003);
        field.setSqlTypeName(this.getStructureName());
    }

    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        return new ArrayCollectionMappingHelper(this).compareForChange(clone, backup, owner, session);
    }

    public boolean compareObjects(Object object1, Object object2, AbstractSession session) {
        return new ArrayCollectionMappingHelper(this).compareObjects(object1, object2, session);
    }

    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        new ArrayCollectionMappingHelper(this).mergeChangesIntoObject(target, changeRecord, source, mergeManager);
    }

    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        new ArrayCollectionMappingHelper(this).mergeIntoObject(target, isTargetUnInitialized, source, mergeManager);
    }

    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        new ArrayCollectionMappingHelper(this).simpleAddToCollectionChangeRecord(referenceKey, changeSetToAdd, changeSet, session);
    }

    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        new ArrayCollectionMappingHelper(this).simpleRemoveFromCollectionChangeRecord(referenceKey, changeSetToRemove, changeSet, session);
    }
}

