/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.latex.PropertyManager;
import info.bliki.wiki.filter.AbstractParser;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.Util;
import info.bliki.wiki.filter.WPTable;
import info.bliki.wiki.filter.WikipediaScanner;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.BrTag;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.util.TagStack;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WPCell {
    public static final int ALIGN_NOT_SET = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_CENTER = 3;
    public static final int ALIGN_JUSTIFY = 4;
    int fStartPos;
    int fEndPos;
    public static final int DEFAULT = 1;
    public static final int TH = 2;
    public static final int CAPTION = 4;
    private int fType;
    private int fAlign;
    private char[] fSource;
    private TagStack fStack;
    private Map<String, String> fAttributes;

    public WPCell(int start) {
        this.fStartPos = start;
        this.fType = 1;
        this.fAlign = 0;
        this.fStack = null;
        this.fAttributes = null;
        this.fSource = null;
    }

    public int getEndPos() {
        return this.fEndPos;
    }

    public void createTagStack(WPTable parent, String src, IWikiModel wikiModel, int endPos) {
        this.fEndPos = endPos;
        if (this.fEndPos > this.fStartPos) {
            String content;
            this.fSource = src.toCharArray();
            String params = null;
            WikipediaScanner scan = new WikipediaScanner(src, this.fStartPos);
            int index = scan.indexOfAttributes();
            if (index == -1 || index >= this.fEndPos) {
                content = new String(this.fSource, this.fStartPos, this.fEndPos - this.fStartPos);
            } else {
                content = new String(this.fSource, index + 1, this.fEndPos - index - 1);
                params = new String(this.fSource, this.fStartPos, index - this.fStartPos);
            }
            this.fAttributes = Util.getAttributes(params);
            String rawWikiText = Utils.ltrimNewline(content);
            AbstractParser parser = wikiModel.createNewInstance(rawWikiText);
            this.fStack = parser.parseRecursiveInternal(rawWikiText, wikiModel, true, false);
            List<BaseToken> list = this.fStack.getNodeList();
            int i = 0;
            while (i < list.size()) {
                if (list.get(i) instanceof TagNode) {
                    ((TagNode)list.get(i)).setParent(parent);
                }
                ++i;
            }
        }
    }

    public int getStartPos() {
        return this.fStartPos;
    }

    public void setStartPos(int startPos) {
        this.fStartPos = startPos;
    }

    public void renderHTML(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        if (this.fStack != null) {
            if (this.fType == 4) {
                buf.append("\n<caption");
            } else if (this.fType == 2) {
                buf.append("\n<th");
            } else {
                buf.append("\n<td");
            }
            HTMLTag.appendEscapedAttributes(buf, this.fAttributes);
            List<BaseToken> list = this.fStack.getNodeList();
            if (list.isEmpty()) {
                buf.append(" />");
            } else {
                buf.append(">");
                converter.nodesToText(this.fStack.getNodeList(), buf, wikiModel);
                if (this.fType == 4) {
                    buf.append("</caption>");
                } else if (this.fType == 2) {
                    buf.append("</th>");
                } else {
                    buf.append("</td>");
                }
            }
        }
    }

    public void renderLaTeX(ITextConverter converter, Appendable _out, IWikiModel wikiModel) throws IOException {
        if (this.fStack != null) {
            boolean hasLBrks = false;
            List<BaseToken> list = this.fStack.getNodeList();
            int i = 0;
            while (i < list.size()) {
                if (list.get(i) instanceof BrTag) {
                    hasLBrks = true;
                    break;
                }
                ++i;
            }
            if (this.fType == 2) {
                _out.append(PropertyManager.get("Table.HeaderCell.Begin"));
            }
            if (hasLBrks) {
                _out.append(PropertyManager.get("Table.CellWithLBreaks.Begin"));
            }
            converter.nodesToText(this.fStack.getNodeList(), _out, wikiModel);
            if (hasLBrks) {
                _out.append(PropertyManager.get("Table.CellWithLBreaks.End"));
            }
            if (this.fType == 2) {
                _out.append(PropertyManager.get("Table.HeaderCell.End"));
            }
        }
    }

    public int getType() {
        return this.fType;
    }

    public int getAlign() {
        return this.fAlign;
    }

    public void setType(int type) {
        this.fType = type;
    }

    public TagStack getTagStack() {
        return this.fStack;
    }

    public Map<String, String> getNodeAttributes() {
        return this.fAttributes;
    }
}

