/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.parser;

import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.cls.Field_info;
import com.vladium.jcd.cls.IAttributeCollection;
import com.vladium.jcd.cls.IConstantCollection;
import com.vladium.jcd.cls.Method_info;
import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.ConstantValueAttribute_info;
import com.vladium.jcd.cls.constant.CONSTANT_Double_info;
import com.vladium.jcd.cls.constant.CONSTANT_Long_info;
import com.vladium.jcd.cls.constant.CONSTANT_info;
import com.vladium.jcd.cls.constant.CONSTANT_literal_info;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.util.ByteArrayIStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class ClassDefParser {
    static final boolean PARSE_SERIAL_VERSION_UID = true;
    static final String SERIAL_VERSION_UID_FIELD_NAME = "serialVersionUID";
    static final int SERIAL_VERSION_UID_FIELD_MASK = 24;

    public static ClassDef parseClass(byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new IllegalArgumentException("null input: bytes");
        }
        classParser parser = new classParser(new UDataInputStream(new ByteArrayIStream(bytes)));
        return parser.class_table();
    }

    public static ClassDef parseClass(byte[] bytes, int length) throws IOException {
        if (bytes == null) {
            throw new IllegalArgumentException("null input: bytes");
        }
        classParser parser = new classParser(new UDataInputStream(new ByteArrayIStream(bytes, length)));
        return parser.class_table();
    }

    public static ClassDef parseClass(InputStream bytes) throws IOException {
        if (bytes == null) {
            throw new IllegalArgumentException("null input: bytes");
        }
        classParser parser = new classParser(new UDataInputStream(bytes));
        return parser.class_table();
    }

    private static final class classParser {
        private final UDataInputStream m_bytes;
        private ClassDef m_table;
        private static final boolean DEBUG = false;
        private static final String s_line = "------------------------------------------------------------------------";

        classParser(UDataInputStream bytes) {
            this.m_bytes = bytes;
        }

        ClassDef class_table() throws IOException {
            this.m_table = new ClassDef();
            this.magic();
            this.version();
            this.constant_pool();
            this.access_flags();
            this.this_class();
            this.super_class();
            this.interfaces();
            this.fields();
            this.methods();
            this.attributes();
            return this.m_table;
        }

        void magic() throws IOException {
            long magic = this.m_bytes.readU4();
            this.m_table.setMagic(magic);
        }

        void version() throws IOException {
            int minor_version = this.m_bytes.readU2();
            int major_version = this.m_bytes.readU2();
            this.m_table.setVersion(new int[]{major_version, minor_version});
        }

        void constant_pool() throws IOException {
            int constant_pool_count = this.m_bytes.readU2();
            IConstantCollection constants = this.m_table.getConstants();
            for (int index = 1; index < constant_pool_count; ++index) {
                CONSTANT_info cp_info = CONSTANT_info.new_CONSTANT_info(this.m_bytes);
                constants.add(cp_info);
                if (!(cp_info instanceof CONSTANT_Long_info) && !(cp_info instanceof CONSTANT_Double_info)) continue;
                ++index;
            }
        }

        void access_flags() throws IOException {
            int _access_flags = this.m_bytes.readU2();
            this.m_table.setAccessFlags(_access_flags);
        }

        void this_class() throws IOException {
            int _class_index = this.m_bytes.readU2();
            this.m_table.setThisClassIndex(_class_index);
        }

        void super_class() throws IOException {
            int _class_index = this.m_bytes.readU2();
            this.m_table.setSuperClassIndex(_class_index);
        }

        void interfaces() throws IOException {
            int _interfaces_count = this.m_bytes.readU2();
            for (int i = 0; i < _interfaces_count; ++i) {
                int _interface_index = this.m_bytes.readU2();
                this.m_table.getInterfaces().add(_interface_index);
            }
        }

        void fields() throws IOException {
            int _fields_count = this.m_bytes.readU2();
            IConstantCollection constantPool = this.m_table.getConstants();
            for (int i = 0; i < _fields_count; ++i) {
                Field_info field_info = new Field_info(constantPool, this.m_bytes);
                this.m_table.getFields().add(field_info);
                if ((field_info.getAccessFlags() & 0x18) != 24 || !ClassDefParser.SERIAL_VERSION_UID_FIELD_NAME.equals(field_info.getName(this.m_table))) continue;
                IAttributeCollection attributes = field_info.getAttributes();
                int aLimit = attributes.size();
                for (int a = 0; a < aLimit; ++a) {
                    CONSTANT_literal_info constant_value;
                    Attribute_info attr_info = attributes.get(a);
                    if (!(attr_info instanceof ConstantValueAttribute_info) || !((constant_value = ((ConstantValueAttribute_info)attr_info).getValue(this.m_table)) instanceof CONSTANT_Long_info)) continue;
                    this.m_table.setDeclaredSUID(((CONSTANT_Long_info)constant_value).m_value);
                }
            }
        }

        void methods() throws IOException {
            int _methods_count = this.m_bytes.readU2();
            IConstantCollection constantPool = this.m_table.getConstants();
            for (int i = 0; i < _methods_count; ++i) {
                Method_info method_info = new Method_info(constantPool, this.m_bytes);
                this.m_table.getMethods().add(method_info);
            }
        }

        void attributes() throws IOException {
            int _attributes_count = this.m_bytes.readU2();
            IConstantCollection constantPool = this.m_table.getConstants();
            for (int i = 0; i < _attributes_count; ++i) {
                Attribute_info attribute_info = Attribute_info.new_Attribute_info(constantPool, this.m_bytes);
                this.m_table.getAttributes().add(attribute_info);
            }
        }
    }
}

