/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import com.sun.jna.Native;
import java.util.HashMap;
import java.util.Map;
import org.python.posix.FreeBSDPOSIX;
import org.python.posix.JavaPOSIX;
import org.python.posix.LibC;
import org.python.posix.LinuxLibC;
import org.python.posix.LinuxPOSIX;
import org.python.posix.MacOSPOSIX;
import org.python.posix.OpenBSDPOSIX;
import org.python.posix.POSIX;
import org.python.posix.POSIXHandler;
import org.python.posix.POSIXTypeMapper;
import org.python.posix.SolarisPOSIX;
import org.python.posix.WindowsLibC;
import org.python.posix.WindowsLibCFunctionMapper;
import org.python.posix.WindowsPOSIX;
import org.python.posix.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSIXFactory {
    static final String LIBC = Platform.IS_LINUX ? "libc.so.6" : "c";
    static LibC libc = null;
    static final Map<Object, Object> defaultOptions = new HashMap<Object, Object>(){
        {
            this.put("type-mapper", POSIXTypeMapper.INSTANCE);
        }
    };

    public static POSIX getPOSIX(POSIXHandler handler, boolean useNativePOSIX) {
        POSIX posix;
        block19: {
            posix = null;
            if (useNativePOSIX) {
                try {
                    if (Platform.IS_MAC) {
                        posix = POSIXFactory.loadMacOSPOSIX(handler);
                    } else if (Platform.IS_LINUX) {
                        posix = POSIXFactory.loadLinuxPOSIX(handler);
                    } else if (Platform.IS_FREEBSD) {
                        posix = POSIXFactory.loadFreeBSDPOSIX(handler);
                    } else if (Platform.IS_OPENBSD) {
                        posix = POSIXFactory.loadOpenBSDPOSIX(handler);
                    } else if (Platform.IS_32_BIT) {
                        if (Platform.IS_WINDOWS) {
                            posix = POSIXFactory.loadWindowsPOSIX(handler);
                        } else if (Platform.IS_SOLARIS) {
                            posix = POSIXFactory.loadSolarisPOSIX(handler);
                        }
                    }
                    if (handler.isVerbose()) {
                        if (posix != null) {
                            System.err.println("Successfully loaded native POSIX impl.");
                        } else {
                            System.err.println("Failed to load native POSIX impl; falling back on Java impl. Unsupported OS.");
                        }
                    }
                }
                catch (Throwable t) {
                    if (!handler.isVerbose()) break block19;
                    System.err.println("Failed to load native POSIX impl; falling back on Java impl. Stacktrace follows.");
                    t.printStackTrace();
                }
            }
        }
        if (posix == null) {
            posix = POSIXFactory.getJavaPOSIX(handler);
        }
        return posix;
    }

    public static POSIX getJavaPOSIX(POSIXHandler handler) {
        return new JavaPOSIX(handler);
    }

    public static POSIX loadLinuxPOSIX(POSIXHandler handler) {
        return new LinuxPOSIX(LIBC, POSIXFactory.loadLibC(LIBC, LinuxLibC.class, defaultOptions), handler);
    }

    public static POSIX loadMacOSPOSIX(POSIXHandler handler) {
        return new MacOSPOSIX(LIBC, POSIXFactory.loadLibC(LIBC, LibC.class, defaultOptions), handler);
    }

    public static POSIX loadSolarisPOSIX(POSIXHandler handler) {
        return new SolarisPOSIX(LIBC, POSIXFactory.loadLibC(LIBC, LibC.class, defaultOptions), handler);
    }

    public static POSIX loadFreeBSDPOSIX(POSIXHandler handler) {
        return new FreeBSDPOSIX(LIBC, POSIXFactory.loadLibC(LIBC, LibC.class, defaultOptions), handler);
    }

    public static POSIX loadOpenBSDPOSIX(POSIXHandler handler) {
        return new OpenBSDPOSIX(LIBC, POSIXFactory.loadLibC(LIBC, LibC.class, defaultOptions), handler);
    }

    public static POSIX loadWindowsPOSIX(POSIXHandler handler) {
        String name = "msvcrt";
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("function-mapper", new WindowsLibCFunctionMapper());
        return new WindowsPOSIX(name, POSIXFactory.loadLibC(name, WindowsLibC.class, options), handler);
    }

    public static LibC loadLibC(String libraryName, Class<?> libCClass, Map<Object, Object> options) {
        if (libc != null) {
            return libc;
        }
        libc = (LibC)Native.loadLibrary(libraryName, libCClass, options);
        return libc;
    }
}

