/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.taskdefs;

import com.nokia.ant.Database;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;

public class DatabaseTask
extends Task {
    private File outputFile;
    private ResourceCollection rc;
    private boolean homeFilesOnly = true;

    public DatabaseTask() {
        this.setTaskName("database");
    }

    public void setOutput(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setRefid(Reference r) {
        Object o = r.getReferencedObject();
        if (!(o instanceof ResourceCollection)) {
            throw new BuildException(r.getRefId() + " doesn't denote a ResourceCollection");
        }
        this.rc = (ResourceCollection)o;
    }

    public void setHomeFilesOnly(boolean homeFilesOnly) {
        this.homeFilesOnly = homeFilesOnly;
    }

    public void execute() {
        this.log("Building Ant project database", 4);
        try {
            Database db = new Database(this.getProject(), this.rc, this);
            db.setHomeFilesOnly(this.homeFilesOnly);
            db.createXMLFile(this.outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(e.getMessage());
        }
    }
}

