/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.synergy.command.add;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.synergy.command.SynergyCommand;
import org.apache.maven.scm.provider.synergy.repository.SynergyScmProviderRepository;
import org.apache.maven.scm.provider.synergy.util.SynergyUtil;
import org.codehaus.plexus.util.FileUtils;

public class SynergyAddCommand
extends AbstractAddCommand
implements SynergyCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScmResult executeAddCommand(ScmProviderRepository repository, ScmFileSet fileSet, String message, boolean binary) throws ScmException {
        this.getLogger().debug("executing add command...");
        SynergyScmProviderRepository repo = (SynergyScmProviderRepository)repository;
        this.getLogger().debug("basedir: " + fileSet.getBasedir());
        if (message == null || message.equals("")) {
            message = "Maven SCM Synergy provider: adding file(s) to project " + repo.getProjectSpec();
        }
        String ccmAddr = SynergyUtil.start(this.getLogger(), repo.getUser(), repo.getPassword(), null);
        try {
            int taskNum = SynergyUtil.createTask(this.getLogger(), message, repo.getProjectRelease(), true, ccmAddr);
            String projectSpec = SynergyUtil.getWorkingProject(this.getLogger(), repo.getProjectSpec(), repo.getUser(), ccmAddr);
            if (projectSpec == null) {
                throw new ScmException("You should checkout project first");
            }
            File waPath = SynergyUtil.getWorkArea(this.getLogger(), projectSpec, ccmAddr);
            File destPath = new File(waPath, repo.getProjectName());
            Iterator i = fileSet.getFileList().iterator();
            while (i.hasNext()) {
                File dest;
                File f = (File)i.next();
                File source = f;
                if (!source.equals(dest = new File(destPath, SynergyUtil.removePrefix(fileSet.getBasedir(), f)))) {
                    this.getLogger().debug("Copy file [" + source + "] to Synergy Work Area [" + dest + "].");
                    try {
                        FileUtils.copyFile((File)source, (File)dest);
                    }
                    catch (IOException e) {
                        throw new ScmException("Unable to copy file in Work Area", (Throwable)e);
                    }
                }
                SynergyUtil.create(this.getLogger(), dest, message, ccmAddr);
            }
            SynergyUtil.checkinTask(this.getLogger(), taskNum, message, ccmAddr);
        }
        finally {
            SynergyUtil.stop(this.getLogger(), ccmAddr);
        }
        return new AddScmResult("", fileSet.getFileList());
    }
}

