/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.m2.PomReader;
import org.apache.ivy.plugins.repository.Resource;

public class PomModuleDescriptorBuilder {
    public static final Configuration[] MAVEN2_CONFIGURATIONS = new Configuration[]{new Configuration("default", Configuration.Visibility.PUBLIC, "runtime dependencies and master artifact can be used with this conf", new String[]{"runtime", "master"}, true, null), new Configuration("master", Configuration.Visibility.PUBLIC, "contains only the artifact published by this module itself, with no transitive dependencies", new String[0], true, null), new Configuration("compile", Configuration.Visibility.PUBLIC, "this is the default scope, used if none is specified. Compile dependencies are available in all classpaths.", new String[0], true, null), new Configuration("provided", Configuration.Visibility.PUBLIC, "this is much like compile, but indicates you expect the JDK or a container to provide it. It is only available on the compilation classpath, and is not transitive.", new String[0], true, null), new Configuration("runtime", Configuration.Visibility.PUBLIC, "this scope indicates that the dependency is not required for compilation, but is for execution. It is in the runtime and test classpaths, but not the compile classpath.", new String[]{"compile"}, true, null), new Configuration("test", Configuration.Visibility.PRIVATE, "this scope indicates that the dependency is not required for normal use of the application, and is only available for the test compilation and execution phases.", new String[]{"runtime"}, true, null), new Configuration("system", Configuration.Visibility.PUBLIC, "this scope is similar to provided except that you have to provide the JAR which contains it explicitly. The artifact is always available and is not looked up in a repository.", new String[0], true, null), new Configuration("optional", Configuration.Visibility.PUBLIC, "contains all optional dependencies", new String[0], true, null)};
    static final Map MAVEN2_CONF_MAPPING = new HashMap();
    private static final String DEPENDENCY_MANAGEMENT = "m:dependency.management";
    private static final String PROPERTIES = "m:properties";
    private static final String EXTRA_INFO_DELIMITER = "__";
    private final DefaultModuleDescriptor ivyModuleDescriptor;
    private ModuleRevisionId mrid;

    public PomModuleDescriptorBuilder(ModuleDescriptorParser parser, Resource res) {
        this.ivyModuleDescriptor = new DefaultModuleDescriptor(parser, res);
        this.ivyModuleDescriptor.setResolvedPublicationDate(new Date(res.getLastModified()));
        for (int i = 0; i < MAVEN2_CONFIGURATIONS.length; ++i) {
            this.ivyModuleDescriptor.addConfiguration(MAVEN2_CONFIGURATIONS[i]);
        }
        this.ivyModuleDescriptor.setMappingOverride(true);
        this.ivyModuleDescriptor.addExtraAttributeNamespace("m", Ivy.getIvyHomeURL() + "maven");
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.ivyModuleDescriptor;
    }

    public void setModuleRevId(String groupId, String artifactId, String version) {
        this.mrid = ModuleRevisionId.newInstance(groupId, artifactId, version);
        this.ivyModuleDescriptor.setModuleRevisionId(this.mrid);
    }

    public void addArtifact(String artifactId, String packaging) {
        this.ivyModuleDescriptor.addArtifact("master", new DefaultArtifact(this.mrid, new Date(), artifactId, packaging, packaging));
    }

    public void addDependency(Resource res, PomReader.PomDependencyData dep) throws ParseException {
        if (!MAVEN2_CONF_MAPPING.containsKey(dep.getScope())) {
            String msg = "Unknown scope " + dep.getScope() + " for dependency " + ModuleId.newInstance(dep.getGroupId(), dep.getArtifaceId()) + " in " + res.getName();
            throw new ParseException(msg, 0);
        }
        String version = dep.getVersion();
        version = version == null || version.length() == 0 ? this.getDefaultVersion(dep) : version;
        ModuleRevisionId moduleRevId = ModuleRevisionId.newInstance(dep.getGroupId(), dep.getArtifaceId(), version);
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(this.ivyModuleDescriptor, moduleRevId, true, false, true);
        ConfMapper mapping = (ConfMapper)MAVEN2_CONF_MAPPING.get(dep.getScope());
        mapping.addMappingConfs(dd, dep.isOptional());
        HashMap<String, String> extraAtt = new HashMap<String, String>();
        if (dep.getClassifier() != null) {
            extraAtt.put("m:classifier", dep.getClassifier());
            DefaultDependencyArtifactDescriptor depArtifact = new DefaultDependencyArtifactDescriptor(dd.getDependencyId().getName(), "jar", "jar", null, extraAtt);
            String optionalizedScope = dep.isOptional() ? "optional" : dep.getScope();
            dd.addDependencyArtifact(optionalizedScope, depArtifact);
        }
        Iterator itExcl = dep.getExcludedModules().iterator();
        while (itExcl.hasNext()) {
            ModuleId excludedModule = (ModuleId)itExcl.next();
            String[] confs = dd.getModuleConfigurations();
            for (int k = 0; k < confs.length; ++k) {
                dd.addExcludeRule(confs[k], new DefaultExcludeRule(new ArtifactId(excludedModule, "*", "*", "*"), ExactPatternMatcher.INSTANCE, null));
            }
        }
        this.ivyModuleDescriptor.addDependency(dd);
    }

    public void addDependency(DependencyDescriptor descriptor) {
        this.ivyModuleDescriptor.addDependency(descriptor);
    }

    public void addDependencyMgt(PomReader.PomDependencyMgt dep) {
        String key = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKey(dep.getGroupId(), dep.getArtifaceId());
        this.ivyModuleDescriptor.addExtraInfo(key, dep.getVersion());
    }

    private String getDefaultVersion(PomReader.PomDependencyData dep) {
        String key = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKey(dep.getGroupId(), dep.getArtifaceId());
        return (String)this.ivyModuleDescriptor.getExtraInfo().get(key);
    }

    private static String getDependencyMgtExtraInfoKey(String groupId, String artifaceId) {
        return "m:dependency.management__" + groupId + EXTRA_INFO_DELIMITER + artifaceId;
    }

    private static String getPropertyExtraInfoKey(String propertyName) {
        return "m:properties__" + propertyName;
    }

    public void addExtraInfos(Map extraAttributes) {
        Iterator it = extraAttributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.addExtraInfo(key, value);
        }
    }

    private void addExtraInfo(String key, String value) {
        if (!this.ivyModuleDescriptor.getExtraInfo().containsKey(key)) {
            this.ivyModuleDescriptor.addExtraInfo(key, value);
        }
    }

    public static Map extractPomProperties(Map extraInfo) {
        HashMap r = new HashMap();
        Iterator it = extraInfo.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry extraInfoEntry = it.next();
            if (!((String)extraInfoEntry.getKey()).startsWith(PROPERTIES)) continue;
            String prop = ((String)extraInfoEntry.getKey()).substring(PROPERTIES.length() + EXTRA_INFO_DELIMITER.length());
            r.put(prop, extraInfoEntry.getValue());
        }
        return r;
    }

    public void addProperty(String propertyName, String value) {
        this.addExtraInfo(PomModuleDescriptorBuilder.getPropertyExtraInfoKey(propertyName), value);
    }

    static {
        MAVEN2_CONF_MAPPING.put("compile", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("compile", "compile(*)");
                    dd.addDependencyConfiguration("compile", "master(*)");
                    dd.addDependencyConfiguration("runtime", "runtime(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("provided", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "provided(*)");
                    dd.addDependencyConfiguration("optional", "runtime(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("provided", "compile(*)");
                    dd.addDependencyConfiguration("provided", "provided(*)");
                    dd.addDependencyConfiguration("provided", "runtime(*)");
                    dd.addDependencyConfiguration("provided", "master(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("runtime", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "provided(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("runtime", "compile(*)");
                    dd.addDependencyConfiguration("runtime", "runtime(*)");
                    dd.addDependencyConfiguration("runtime", "master(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("test", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                dd.addDependencyConfiguration("test", "runtime(*)");
                dd.addDependencyConfiguration("test", "master(*)");
            }
        });
        MAVEN2_CONF_MAPPING.put("system", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                dd.addDependencyConfiguration("system", "master(*)");
            }
        });
    }

    static interface ConfMapper {
        public void addMappingConfs(DefaultDependencyDescriptor var1, boolean var2);
    }
}

