/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.maven.scm.manager;

import com.nokia.maven.scm.command.info.InfoScmResult;
import com.nokia.maven.scm.command.pull.PullScmResult;
import com.nokia.maven.scm.command.tags.TagsScmResult;
import com.nokia.maven.scm.manager.ExtendedScmManager;
import com.nokia.maven.scm.provider.ScmProviderExt;
import java.io.File;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.manager.BasicScmManager;
import org.apache.maven.scm.repository.ScmRepository;

public class BasicExtendedScmManager
extends BasicScmManager
implements ExtendedScmManager {
    @Override
    public PullScmResult pull(ScmRepository repository, File path) throws ScmException {
        try {
            ScmProviderExt provider = (ScmProviderExt)this.getProviderByRepository(repository);
            return provider.pull(repository, path);
        }
        catch (ClassCastException exc) {
            throw new ScmException("The " + repository.getProvider().toString() + " does not support extended functionalities.");
        }
    }

    @Override
    public TagsScmResult tags(ScmRepository repository, File path) throws ScmException {
        try {
            ScmProviderExt provider = (ScmProviderExt)this.getProviderByRepository(repository);
            return provider.tags(repository, new ScmFileSet(path), new CommandParameters());
        }
        catch (ClassCastException exc) {
            throw new ScmException("The " + repository.getProvider().toString() + " does not support extended functionalities.");
        }
    }

    @Override
    public InfoScmResult info(ScmRepository repository, File path) throws ScmException {
        try {
            ScmProviderExt provider = (ScmProviderExt)this.getProviderByRepository(repository);
            return provider.info(repository, new ScmFileSet(path), new CommandParameters());
        }
        catch (ClassCastException exc) {
            throw new ScmException("The " + repository.getProvider().toString() + " does not support extended functionalities.");
        }
    }
}

