/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioGroupBox
extends JPanel {
    private List buttons = new ArrayList();
    private ButtonGroup group = new ButtonGroup();

    private RadioGroupBox() {
    }

    public RadioGroupBox(String[] values, int columns) {
        this.setLayout(new GridLayout(0, columns));
        for (int i = 0; i < values.length; ++i) {
            JRadioButton button = new JRadioButton(values[i]);
            this.add(button);
            this.buttons.add(button);
            this.group.add(button);
        }
    }

    public Font getFont() {
        Font font = null;
        if (this.buttons != null && this.buttons.size() > 0) {
            font = ((Component)this.buttons.get(0)).getFont();
        }
        return font;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.buttons != null) {
            Iterator iter = this.buttons.iterator();
            while (iter.hasNext()) {
                JRadioButton button = (JRadioButton)iter.next();
                button.setFont(font);
            }
        }
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.buttons != null) {
            Iterator iter = this.buttons.iterator();
            while (iter.hasNext()) {
                JRadioButton button = (JRadioButton)iter.next();
                button.setBackground(bg);
            }
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.buttons != null) {
            Iterator iter = this.buttons.iterator();
            while (iter.hasNext()) {
                JRadioButton button = (JRadioButton)iter.next();
                button.setForeground(fg);
            }
        }
    }

    public void setSelectedValue(String value) {
        if (this.buttons != null) {
            Iterator iter = this.buttons.iterator();
            while (iter.hasNext()) {
                JRadioButton button = (JRadioButton)iter.next();
                if (!button.getText().equals(value)) continue;
                button.setSelected(true);
            }
        }
    }

    public String getSelectedValue() {
        String local = "";
        if (this.buttons != null) {
            Iterator iter = this.buttons.iterator();
            while (iter.hasNext()) {
                JRadioButton button = (JRadioButton)iter.next();
                if (!button.isSelected()) continue;
                local = button.getText();
            }
        }
        return local;
    }

    public int getSelectedIndex() {
        int local = -1;
        if (this.buttons != null) {
            for (int i = 0; i < this.buttons.size(); ++i) {
                JRadioButton button = (JRadioButton)this.buttons.get(i);
                if (!button.isSelected()) continue;
                local = i;
            }
        }
        return local;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.buttons != null) {
            Iterator iter = this.buttons.iterator();
            while (iter.hasNext()) {
                JRadioButton button = (JRadioButton)iter.next();
                button.setEnabled(enabled);
            }
        }
    }
}

