/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.signal.ant;

import com.nokia.helium.core.LogSource;
import com.nokia.helium.signal.Notifier;
import com.nokia.helium.signal.SignalStatus;
import com.nokia.helium.signal.SignalStatusList;
import com.nokia.helium.signal.ant.types.NotifierInput;
import com.nokia.helium.signal.ant.types.SignalConfig;
import com.nokia.helium.signal.ant.types.SignalInput;
import com.nokia.helium.signal.ant.types.SignalListenerConfig;
import com.nokia.helium.signal.ant.types.SignalNotifierInput;
import com.nokia.helium.signal.ant.types.SignalNotifierList;
import com.nokia.helium.signal.ant.types.TargetCondition;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.DataType;

public class SignalList {
    public static final String DEFAULT_NOTIFIER_LIST_REFID = "defaultSignalInput";
    private Hashtable<String, SignalListenerConfig> signalListenerConfigs = new Hashtable();
    private HashMap<String, List<SignalListenerConfig>> targetsMap = new HashMap();
    private Hashtable<String, SignalConfig> signalConfigs = new Hashtable();
    private HashMap<String, List<SignalConfig>> targetsConfigMap = new HashMap();
    private Project project;
    private Logger log = Logger.getLogger(this.getClass());

    public SignalList(Project project) {
        this.project = project;
        Hashtable references = project.getReferences();
        Enumeration keyEnum = references.keys();
        while (keyEnum.hasMoreElements()) {
            DataType config;
            String key = (String)keyEnum.nextElement();
            if (references.get(key) instanceof SignalListenerConfig) {
                this.log.debug((Object)("SignalList: Found reference: " + key));
                config = (SignalListenerConfig)((Object)references.get(key));
                config.setConfigId(key);
                this.signalListenerConfigs.put(key, (SignalListenerConfig)config);
                String targetName = config.getTargetName();
                List<Object> list = this.targetsMap.get(targetName) == null ? new ArrayList<DataType>() : this.targetsMap.get(targetName);
                list.add(config);
                this.targetsMap.put(targetName, list);
            }
            if (!(references.get(key) instanceof SignalConfig)) continue;
            this.log.debug((Object)("SignalList: Found reference: " + key));
            config = (SignalConfig)((Object)references.get(key));
            config.setConfigId(key);
            this.signalConfigs.put(key, (SignalConfig)config);
            Set<String> targetNameSet = config.getTargetNameSet();
            for (String targetName : targetNameSet) {
                List<Object> list = this.targetsConfigMap.get(targetName) == null ? new ArrayList<DataType>() : this.targetsConfigMap.get(targetName);
                list.add(config);
                this.targetsConfigMap.put(targetName, list);
            }
        }
    }

    public Project getProject() {
        return this.project;
    }

    public Vector<SignalListenerConfig> getSignalListenerConfigList() {
        return new Vector<SignalListenerConfig>(this.signalListenerConfigs.values());
    }

    public boolean isTargetInSignalList(String targetName) {
        return this.targetsMap.get(targetName) != null;
    }

    public List<SignalListenerConfig> getSignalListenerConfig(String targetName) {
        return this.targetsMap.get(targetName);
    }

    protected void sendNotifications(Vector<Notifier> notifierList, String signalName) {
        this.sendNotifications(notifierList, signalName, false, null);
    }

    public void processForSignal(Project prj, SignalNotifierInput signalNotifierInput, String signalName, String targetName, String errorMessage, boolean failBuild) {
        Object obj;
        SignalInput signalInput = signalNotifierInput.getSignalInput();
        Vector<Notifier> notifierList = signalInput.getSignalNotifierList();
        if (notifierList == null && (obj = prj.getReference(DEFAULT_NOTIFIER_LIST_REFID)) instanceof SignalNotifierList) {
            notifierList = ((SignalNotifierList)((Object)obj)).getNotifierList();
        }
        NotifierInput notifierInput = signalNotifierInput.getNotifierInput();
        this.sendNotifications(notifierList, signalName, failBuild, notifierInput);
        if (failBuild) {
            String failStatus = "now";
            if (signalInput != null) {
                failStatus = signalInput.getFailBuild();
            } else {
                this.log.debug((Object)("Could not find config for signal: " + signalName));
            }
            if (failStatus == null || failStatus.equals("now")) {
                SignalStatusList.getNowSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
                throw new BuildException(new SignalStatus(signalName, errorMessage, targetName, new Date()).toString());
            }
            if (failStatus.equals("defer")) {
                this.log.debug((Object)"SignalList:adding defer signal:");
                this.log.info((Object)("Signal " + signalName + " will be deferred."));
                SignalStatusList.getDeferredSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
            } else if (failStatus.equals("never")) {
                this.log.debug((Object)"SignalList:adding never signal:");
                SignalStatusList.getNeverSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
            } else {
                if (!failStatus.equals("never")) {
                    SignalStatusList.getNowSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
                    throw new BuildException(new SignalStatus(signalName, errorMessage, targetName, new Date()).toString());
                }
                this.log.info((Object)("Signal " + signalName + " set to be ignored by the configuration."));
            }
        }
    }

    protected void sendNotifications(Vector<Notifier> notifierList, String signalName, boolean failStatus, NotifierInput notifierInput) {
        if (notifierList == null) {
            return;
        }
        for (Notifier notifier : notifierList) {
            if (notifier == null) continue;
            notifier.sendData(signalName, failStatus, notifierInput);
        }
    }

    public boolean checkAndNotifyFailure(Target target, Project prj) {
        String targetName = target.getName();
        String signalName = "unknown";
        boolean retValue = false;
        if (this.isTargetInSignalList(targetName)) {
            retValue = true;
            for (SignalListenerConfig config : this.getSignalListenerConfig(targetName)) {
                TargetCondition targetCondition = config.getTargetCondition();
                String errorMessage = null;
                this.log.debug((Object)("targetcondition:" + (Object)((Object)targetCondition)));
                Condition condition = null;
                if (targetCondition != null) {
                    condition = this.getFailureCondition(targetCondition);
                }
                errorMessage = config.getErrorMessage();
                String refid = config.getConfigId();
                this.log.debug((Object)("refid:" + refid));
                Object configCurrent = prj.getReference(refid);
                if (configCurrent != null && configCurrent instanceof SignalListenerConfig) {
                    signalName = refid;
                }
                this.processForSignal(prj, config.getSignalNotifierInput(), signalName, targetName, errorMessage, condition != null);
                this.log.debug((Object)("SignalList:fail:signalName: " + signalName));
            }
        }
        return retValue;
    }

    private Condition getFailureCondition(TargetCondition targetCondition) {
        Condition retCondition = null;
        Vector<Condition> conditionList = targetCondition.getConditions();
        for (Condition condition : conditionList) {
            this.log.debug((Object)("SignalList:getErrorMessage:" + condition.eval()));
            if (!condition.eval()) continue;
            retCondition = condition;
            break;
        }
        return retCondition;
    }

    public Vector<SignalConfig> getSignalConfigList() {
        return new Vector<SignalConfig>(this.signalConfigs.values());
    }

    public boolean isTargetInSignalConfigList(String targetName) {
        return this.targetsConfigMap.get(targetName) != null;
    }

    public List<SignalConfig> getSignalConfigs(String targetName) {
        return this.targetsConfigMap.get(targetName);
    }

    public void sendSignal(String signalName, boolean failStatus) {
        this.log.debug((Object)("Sending signal for:" + signalName));
        if (this.signalConfigs.containsKey(signalName)) {
            SignalConfig config = this.signalConfigs.get(signalName);
            this.sendNotify(config.getSignalInput().getSignalNotifierList(), signalName, failStatus, this.getFileList(this.project, config.getLogSourceList(), config.getSourceType()));
        } else if (this.project.getReference(DEFAULT_NOTIFIER_LIST_REFID) != null) {
            this.sendNotify(((SignalInput)((Object)this.project.getReference(DEFAULT_NOTIFIER_LIST_REFID))).getSignalNotifierList(), signalName, failStatus, null);
        }
    }

    protected void sendNotify(Vector<Notifier> notifierList, String signalName) {
        this.sendNotify(notifierList, signalName, false, null);
    }

    protected void sendNotify(Vector<Notifier> notifierList, String signalName, boolean failStatus, List<String> fileList) {
        if (notifierList == null) {
            return;
        }
        for (Notifier notifier : notifierList) {
            if (notifier == null) continue;
            notifier.sendData(signalName, failStatus, fileList);
        }
    }

    public void fail(String signalName, String targetName, String errorMessage) {
        String failStatus = "now";
        if (this.signalConfigs.containsKey(signalName)) {
            SignalConfig config = this.signalConfigs.get(signalName);
            SignalInput si = config.getSignalInput();
            this.log.debug((Object)("failStatus: " + (Object)((Object)si)));
            if (si != null) {
                failStatus = si.getFailBuild();
            }
        } else {
            this.log.debug((Object)("Could not find config for signal: " + signalName));
        }
        this.log.debug((Object)("failStatus: " + failStatus));
        if (failStatus == null || failStatus.equals("now")) {
            SignalStatusList.getNowSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
            throw new BuildException(new SignalStatus(signalName, errorMessage, targetName, new Date()).toString());
        }
        if (failStatus.equals("defer")) {
            this.log.debug((Object)"SignalList1:adding defer signal:");
            this.log.info((Object)("Signal " + signalName + " will be deferred."));
            SignalStatusList.getDeferredSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
        } else if (failStatus.equals("never")) {
            this.log.debug((Object)"SignalList1:adding never signal:");
            SignalStatusList.getNeverSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
        } else {
            if (!failStatus.equals("never")) {
                SignalStatusList.getNowSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
                throw new BuildException(new SignalStatus(signalName, errorMessage, targetName, new Date()).toString());
            }
            this.log.info((Object)("Signal " + signalName + " set to be ignored by the configuration."));
        }
    }

    public void checkAndNotify(Target target, Project prj) {
        String targetName = target.getName();
        String signalName = "unknown";
        if (this.isTargetInSignalConfigList(targetName)) {
            for (SignalConfig config : this.getSignalConfigs(targetName)) {
                Vector<Notifier> notifierList = null;
                TargetCondition targetCondition = config.getTargetCondition(targetName);
                String errorMessage = null;
                String failStatus = null;
                boolean buildFailed = false;
                if (targetCondition != null) {
                    Object obj;
                    List<String> fileList = this.getFileList(prj, config.getLogSourceList(), config.getSourceType());
                    this.log.debug((Object)("targetcondition:" + (Object)((Object)targetCondition)));
                    Condition condition = this.getFailureCondition(targetName, targetCondition, fileList);
                    errorMessage = targetCondition.getMessage();
                    String refid = config.getConfigId();
                    this.log.debug((Object)("refid:" + refid));
                    Object configCurrent = prj.getReference(refid);
                    if (configCurrent != null && configCurrent instanceof SignalConfig) {
                        signalName = refid;
                    }
                    this.log.debug((Object)("SignalList:fail:signalName: " + signalName));
                    notifierList = config.getSignalInput().getSignalNotifierList();
                    if (notifierList == null && (obj = prj.getReference(DEFAULT_NOTIFIER_LIST_REFID)) instanceof SignalNotifierList) {
                        notifierList = ((SignalNotifierList)((Object)obj)).getNotifierList();
                    }
                    failStatus = config.getSignalInput().getFailBuild();
                    this.log.debug((Object)("SignalList:failStatus:" + failStatus));
                    buildFailed = condition != null;
                    this.sendNotify(notifierList, signalName, buildFailed, fileList);
                }
                if (!buildFailed) continue;
                if (failStatus == null || failStatus.equals("now")) {
                    SignalStatusList.getNowSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
                    throw new BuildException(new SignalStatus(signalName, errorMessage, targetName, new Date()).toString());
                }
                if (failStatus.equals("defer")) {
                    this.log.debug((Object)"SignalList1:adding defer signal:");
                    this.log.info((Object)("Signal " + signalName + " will be deferred."));
                    SignalStatusList.getDeferredSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
                    continue;
                }
                if (failStatus.equals("never")) {
                    this.log.debug((Object)"SignalList1:adding never signal:");
                    SignalStatusList.getNeverSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
                    continue;
                }
                if (!failStatus.equals("never")) {
                    SignalStatusList.getNowSignalList().addSignalStatus(new SignalStatus(signalName, errorMessage, targetName, new Date()));
                    throw new BuildException(new SignalStatus(signalName, errorMessage, targetName, new Date()).toString());
                }
                this.log.info((Object)("Signal " + signalName + " set to be ignored by the configuration."));
            }
        }
    }

    private List<String> getFileList(Project project, Vector<LogSource> sourceList, String sourceType) {
        ArrayList<String> fileList = new ArrayList<String>();
        if (sourceList != null) {
            for (LogSource l : sourceList) {
                File file = l.getFilename();
                if (file != null && file.exists()) {
                    fileList.add(project.replaceProperties(file.toString()));
                }
                if (sourceType != null && sourceType.equals("combined")) continue;
                break;
            }
        }
        return fileList;
    }

    private Condition getFailureCondition(String targetName, TargetCondition targetCondition, List<String> fileList) {
        Condition retCondition = null;
        for (Condition condition : targetCondition.getConditions()) {
            this.log.debug((Object)("SignalList:getErrorMessage:" + condition.eval()));
            if (!condition.eval()) continue;
            retCondition = condition;
            break;
        }
        return retCondition;
    }
}

