/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:31 $
 * $Revision: 1.5 $
 */

#ifndef _MSL_STDARG_WIN32_H
#define _MSL_STDARG_WIN32_H

_MSL_BEGIN_EXTERN_C

	#define va_start(ap, parm)	ap = __va_start(parm)
	#define va_end(ap) ((void) 0)						/*- mm 011006 -*/
#if _MSL_C99											/*- mm 030719 -*/
	#define va_copy(dest, src)  dest = src				/*- mm 980824 -*/
#endif /* _MSL_C99 */									/*- mm 030719 -*/
	#define __va_start(parm) (__std(va_list)) ((long) (&parm) + ((((long) (&parm + 1) - (long) (&parm))+3)/4*4))  /*- mm 9708027 -*/
	#define _Align(type, mask) (sizeof(type) + (mask) & ~(mask))
	#define va_arg(ap, type) (* (type *) (((ap) += _Align(type, 3)) - _Align(type, 3)))

_MSL_END_EXTERN_C

#endif /* _MSL_STDARG_WIN32_H */

/* Change record:
 * JWW 011101 New file to make stdarg information platform independent
 * mm  030719 Added C99 wrappers
 */