/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/04/15 19:36:16 $
 * $Revision: 1.9.2.1 $
 */

/*
 *	Content:	Interface file to standard UNIX-style entry points ...
 *
 */


#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <utime.h>
#include <stdio.h>
#include <extras.win32.h>

static int Time2FileTime(time_t *time, FILETIME *filetime) _MSL_CANT_THROW
{
	struct tm *tm;
	SYSTEMTIME systemtime;
	FILETIME   localfiletime;
	
	if (!(tm = localtime(time))) 
		return -1;
	
	systemtime.wYear 	= tm->tm_year + 1900;
	systemtime.wMonth 	= tm->tm_mon + 1;
	systemtime.wDay 	= tm->tm_mday;
	systemtime.wHour	= tm->tm_hour;
	systemtime.wMinute	= tm->tm_min;
	systemtime.wSecond 	= tm->tm_sec;
	systemtime.wMilliseconds = 0;
	
	if (!SystemTimeToFileTime(&systemtime,&localfiletime)  ||
				!LocalFileTimeToFileTime(&localfiletime,filetime)) 
		return -1;
	return 0;
}


/*
 *	Set the file time stamps.
 */
 
int _MSL_CDECL utime(const char *path, struct utimbuf *times) _MSL_CANT_THROW
{
	int fh;
	struct utimbuf defaulttimes;
	FILETIME  lastwrite, lastaccess;
	
	if (!times) 
	{
		time(&defaulttimes.modtime);
		defaulttimes.actime = defaulttimes.modtime;
		times = &defaulttimes;
	}
	if (Time2FileTime(&times->modtime, &lastwrite) == -1 ||
				Time2FileTime(&times->actime, &lastaccess) == -1) 
	{
		/*errno = -1;*/												/*- mm 010412 -*/
		return -1;
	}
	
	if ((fh = open(path,O_RDWR | O_BINARY)) < 0) 					/*- cc 010518 -*/
	{
		/*errno = -1;*/												/*- mm 010412 -*/
		return -1;
	}
	
	if (!SetFileTime((HANDLE) _get_osfhandle(fh),NULL,&lastaccess,&lastwrite)) 
	{
		close(fh);
		/*errno = -1;*/												/*- mm 010412 -*/
		return (-1);
	}
		
	close(fh);
	return 0;
}

/*- begin mm 031217 addition -*/
int _MSL_CDECL utimes(const char * path, struct timeval buf[2]) _MSL_CANT_THROW /*- hh 980122 -*/
{
	int fh;
	struct utimbuf defaulttimes;
	FILETIME  lastwrite, lastaccess;
	struct utimbuf * times;
	
	if (!buf) 
	{
		time(&defaulttimes.modtime);
		defaulttimes.actime = defaulttimes.modtime;
	}
	else
	{
		defaulttimes.actime  = buf[0].tv_sec;
		defaulttimes.modtime = buf[1].tv_sec;
	}
	times = &defaulttimes;
	if (Time2FileTime(&times->modtime, &lastwrite) == -1 ||
				Time2FileTime(&times->actime, &lastaccess) == -1) 
		return -1;
	
	if ((fh = open(path,O_RDWR | O_BINARY)) < 0) 					/*- cc 010518 -*/
		return -1;
	
	if (!SetFileTime((HANDLE) _get_osfhandle(fh), NULL, &lastaccess, &lastwrite)) 
	{
		close(fh);
		return (-1);
	}
		
	close(fh);
	return 0;
}
/*- end mm 031217 addition -*/

/*
 *	Copies current local time into timestring buffer
 */
 
char * _MSL_CDECL strtime(char * timestring) _MSL_CANT_THROW
{
	SYSTEMTIME time;
	GetLocalTime(&time);
	sprintf(timestring,"%.2d:%.2d:%.2d",
	time.wHour,
	time.wMinute,
	time.wSecond);
	return timestring;
}

char * _MSL_CDECL _strtime(char * timestring) _MSL_CANT_THROW
{
	return strtime(timestring);
}

/* Change record:
 * hh  980122 Replaced <windows.h> with the following TWO includes because it is seriously
 *            broken.  The following 2 includes must be carefully ordered as shown, because
 *            they are broken too.
 * hh  980122 commented out unused args
 * mf  980622 cleaned up including of header files.  preventing inclusion of windows.h
 * cc  000209 changed windef.h to #define WIN32_LEAN_AND_MEAN & #include <windows.h> 
 * cc  000518 fixed #includes
 * mm  010412 Avoid setting a negative value in errno
 * cc  010518 Changed _open to open
 * cc  011203 Added _MSL_CDECL for new name mangling 
 * cc  010115 Remove extern long _get_osfhandle common prototype is in extras.win32.h
 * mm  031217 Implemented utimes()
 */