/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:50 $
 * $Revision: 1.6 $
 */

/*
 *	Content:	Interface file to standard UNIX-style entry points ...
 *
 *	NB:			This file implements some UNIX low level support.  These functions
 *				are not guaranteed to be 100% conformant.
 */

#include <utsname.h>
#include <stdio.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

/*
 *	int uname(struct utsname *name)
 *
 *		Returns information about the current system.
 */
int _MSL_CDECL uname(struct utsname *name) _MSL_CANT_THROW
{
	OSVERSIONINFO OsInfo;
	SYSTEM_INFO   SysInf;
	DWORD MachineNameSize = _UTSNAME_FIELD_LENGTH-1;
	OsInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&OsInfo);
	name->sysname[0] = '\0';
	switch(OsInfo.dwPlatformId)
	{
		case VER_PLATFORM_WIN32s:
			strcpy(name->sysname, "Win32s on Windows 3.1");
			break;
		case VER_PLATFORM_WIN32_WINDOWS:
			strcpy(name->sysname, "Win32 on Windows 95");
			break;
		case VER_PLATFORM_WIN32_NT:
			strcpy(name->sysname, "Win32 on Windows NT");
			break;
		default:
			strcpy(name->sysname, "System Info unavailable");
			break;
	}
	GetComputerName(name->nodename, &MachineNameSize);
	sprintf(name->release, "%i", OsInfo.dwMajorVersion);
	sprintf(name->version, "%i", OsInfo.dwMinorVersion);
	GetSystemInfo(&SysInf);
	name->machine[0] = '\0';
	switch(OsInfo.dwPlatformId)
	{
		case VER_PLATFORM_WIN32s:
		case VER_PLATFORM_WIN32_WINDOWS:
			switch(SysInf.dwProcessorType)
			{
				case PROCESSOR_INTEL_386:
					strcpy(name->machine, "386");
					break;
				case PROCESSOR_INTEL_486:
					strcpy(name->machine, "486");
					break;
				case PROCESSOR_INTEL_PENTIUM:
					strcpy(name->machine, "PENTIUM");
					break;
				default:
					strcpy(name->machine, "Unknown");
					break;
			}
			break;
		case VER_PLATFORM_WIN32_NT:
			switch(SysInf.wProcessorLevel)
			{
				case 3:
					strcpy(name->machine, "386");
					break;
				case 4:
					strcpy(name->machine, "486");
					break;
				case 5:
					strcpy(name->machine, "PENTIUM");
					break;
				default:
					strcpy(name->machine, "Unknown");
					break;
			}
			break;
		default:
			strcpy(name->machine, "Unknown");
			break;
	}

	return(0);
	
}

/* Change record:
 * mm  990102 First version
 * vss 990129 Should be windef.h instead of windows.h
 * cc  000209 Changed windef.h to #define WIN32_LEAN_AND_MEAN & #include <windows.h>
 * cc  000518 Fixed #includes
 * cc  010517 Changed _uname/uname
 * cc  011203 Added _MSL_CDECL for new name mangling 
 */