/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import com.oopsconsultancy.xmltask.Action;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextAction
extends Action {
    private String str = null;

    public TextAction(String str) {
        if (str == null) {
            throw new IllegalArgumentException("TextAction replacement can't be null");
        }
        this.str = str;
    }

    @Override
    public boolean apply(Node n) throws Exception {
        if (TextAction.isTextNode(n)) {
            n.setNodeValue(this.str);
        } else if (n instanceof Attr) {
            ((Attr)n).setValue(this.str);
        } else {
            this.remove(n);
            Text nn = this.doc.createTextNode(this.str);
            n.getParentNode().insertBefore(nn, n);
        }
        return true;
    }

    public static boolean isTextNode(Node n) {
        if (n == null) {
            return false;
        }
        short nodeType = n.getNodeType();
        return nodeType == 4 || nodeType == 3;
    }

    public String toString() {
        return "TextAction(" + this.str + ")";
    }
}

