/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit;

import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;

public class LogCapturer
implements BuildListener {
    public static final String REFERENCE_ID = "ant.antunit.log";
    private StringBuffer err = new StringBuffer();
    private StringBuffer warn = new StringBuffer();
    private StringBuffer info = new StringBuffer();
    private StringBuffer verbose = new StringBuffer();
    private StringBuffer debug = new StringBuffer();
    private Project p;

    public LogCapturer(Project p) {
        this.p = p;
        p.addBuildListener((BuildListener)this);
        p.addReference(REFERENCE_ID, (Object)this);
    }

    public String getErrLog() {
        return this.err.toString();
    }

    public String getWarnLog() {
        return this.warn.toString();
    }

    public String getInfoLog() {
        return this.info.toString();
    }

    public String getVerboseLog() {
        return this.verbose.toString();
    }

    public String getDebugLog() {
        return this.debug.toString();
    }

    public void buildStarted(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void buildFinished(BuildEvent event) {
        if (this.p != null && event.getProject() == this.p) {
            this.p.removeBuildListener((BuildListener)this);
            this.p.getReferences().remove(REFERENCE_ID);
            this.p = null;
        }
    }

    public void messageLogged(BuildEvent event) {
        if (event.getPriority() <= 0) {
            this.err.append(event.getMessage());
        }
        if (event.getPriority() <= 1) {
            this.warn.append(event.getMessage());
        }
        if (event.getPriority() <= 2) {
            this.info.append(event.getMessage());
        }
        if (event.getPriority() <= 3) {
            this.verbose.append(event.getMessage());
        }
        if (event.getPriority() <= 4) {
            this.debug.append(event.getMessage());
        }
    }
}

