/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.ant.data;

import com.nokia.helium.ant.data.AntFile;
import com.nokia.helium.ant.data.AntlibMeta;
import com.nokia.helium.ant.data.PackageMeta;
import com.nokia.helium.ant.data.ProjectMeta;
import com.nokia.helium.ant.data.PropertyMeta;
import com.nokia.helium.ant.data.RootAntObjectMeta;
import com.nokia.helium.freemarker.WikiMethod;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class Database {
    public static final String DEFAULT_SCOPE = "public";
    private Project rootProject;
    private Map<String, AntFile> antfilesMap;
    private Map<String, PackageMeta> packagesMap;
    private String scope;
    private HashMap<String, String> namespaceMap = new HashMap();
    private HashMap<String, List<String>> globalSignalList = new HashMap();
    private Document signaldoc;

    public Database(Project project) throws IOException {
        this(project, DEFAULT_SCOPE);
    }

    public Database(Project project, String scope) throws IOException {
        this.rootProject = project;
        this.scope = scope;
        this.antfilesMap = new HashMap<String, AntFile>();
        this.packagesMap = new HashMap<String, PackageMeta>();
        this.namespaceMap.put("hlm", "http://www.nokia.com/helium");
        if (project != null) {
            Hashtable targets = project.getTargets();
            for (Target target : targets.values()) {
                String antFilePath = new File(target.getLocation().getFileName()).getCanonicalPath();
                if (this.antfilesMap.containsKey(antFilePath)) continue;
                this.addAntFile(antFilePath);
            }
        }
        Collection<AntFile> antFiles = this.getAntFiles();
        for (AntFile antFile : antFiles) {
            this.readSignals(antFile.getFile().getCanonicalPath());
        }
    }

    private void log(String string, int level) {
        if (this.rootProject != null) {
            this.rootProject.log(string, level);
        }
    }

    public void addAntFilePaths(List<String> antFilePaths) throws IOException {
        for (String antFilePath : antFilePaths) {
            this.addAntFile(antFilePath);
        }
    }

    private void addAntFile(String antFilePath) throws IOException {
        if (!this.antfilesMap.containsKey(antFilePath)) {
            this.log("Adding project to database: " + antFilePath, 4);
            AntFile antfile = new AntFile(this, antFilePath, this.scope);
            antfile.setProject(this.rootProject);
            this.antfilesMap.put(antFilePath, antfile);
            this.checkPackageMembership(antfile);
            this.readSignals(antFilePath);
            List<AntFile> antlibFiles = antfile.getAntlibs();
            for (AntFile antFile2 : antlibFiles) {
                this.antfilesMap.put(antFile2.getFile().getCanonicalPath(), antFile2);
                this.checkPackageMembership(antFile2);
            }
        }
    }

    private void checkPackageMembership(AntFile antfile) throws IOException {
        PackageMeta packageMeta;
        RootAntObjectMeta rootObjectMeta = antfile.getRootObjectMeta();
        String packageStr = rootObjectMeta.getPackage();
        if (!this.packagesMap.containsKey(packageStr)) {
            packageMeta = new PackageMeta(packageStr);
            packageMeta.setRuntimeProject(this.rootProject);
            this.packagesMap.put(packageStr, packageMeta);
        }
        packageMeta = this.packagesMap.get(packageStr);
        packageMeta.addObject(rootObjectMeta);
    }

    private void readSignals(String antFile) throws IOException {
        Document antDoc;
        SAXReader xmlReader = new SAXReader();
        try {
            antDoc = xmlReader.read(new File(antFile));
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
        XPath xpath = DocumentHelper.createXPath((String)"//hlm:signalListenerConfig");
        xpath.setNamespaceURIs(this.namespaceMap);
        List signalNodes = xpath.selectNodes((Object)antDoc);
        Iterator iterator = signalNodes.iterator();
        while (iterator.hasNext()) {
            this.signaldoc = antDoc;
            Element propertyNode = (Element)iterator.next();
            String signalid = propertyNode.attributeValue("id");
            String signaltarget = propertyNode.attributeValue("target");
            List<String> existinglist = this.globalSignalList.get(signaltarget);
            String failbuild = this.findSignalFailMode(signalid, this.signaldoc);
            if (existinglist == null) {
                existinglist = new ArrayList<String>();
            }
            existinglist.add(signalid + "," + failbuild);
            this.globalSignalList.put(signaltarget, existinglist);
        }
    }

    public List<String> getSignals(String target) {
        return this.globalSignalList.get(target);
    }

    private String findSignalFailMode(String signalid, Document antDoc) {
        XPath xpath2 = DocumentHelper.createXPath((String)("//hlm:signalListenerConfig[@id='" + signalid + "']/signalNotifierInput/signalInput"));
        xpath2.setNamespaceURIs(this.namespaceMap);
        List signalNodes3 = xpath2.selectNodes((Object)antDoc);
        for (Element propertyNode3 : signalNodes3) {
            String signalinputid = propertyNode3.attributeValue("refid");
            XPath xpath3 = DocumentHelper.createXPath((String)("//hlm:signalInput[@id='" + signalinputid + "']"));
            xpath3.setNamespaceURIs(this.namespaceMap);
            List signalNodes4 = xpath3.selectNodes((Object)antDoc);
            Iterator iterator4 = signalNodes4.iterator();
            if (!iterator4.hasNext()) continue;
            Element propertyNode4 = (Element)iterator4.next();
            return propertyNode4.attributeValue("failbuild");
        }
        return null;
    }

    public void setScope(String scope) {
        if (!(scope.equals(DEFAULT_SCOPE) || scope.equals("protected") || scope.equals("private"))) {
            throw new IllegalArgumentException("Invalid scope value");
        }
        this.scope = scope;
    }

    public void toXML(Writer out) throws IOException {
        Configuration cfg = new Configuration();
        TemplateLoader[] loaders = null;
        ClassTemplateLoader ctl = new ClassTemplateLoader(this.getClass(), "");
        File testingDir = new File("src/com/nokia/helium/ant/data/taskdefs");
        if (testingDir.exists()) {
            FileTemplateLoader ftl1 = new FileTemplateLoader(testingDir);
            loaders = new TemplateLoader[]{ftl1, ctl};
        } else {
            loaders = new TemplateLoader[]{ctl};
        }
        MultiTemplateLoader mtl = new MultiTemplateLoader(loaders);
        cfg.setTemplateLoader((TemplateLoader)mtl);
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        ArrayList<ProjectMeta> projects = new ArrayList<ProjectMeta>();
        ArrayList<AntlibMeta> antlibs = new ArrayList<AntlibMeta>();
        for (AntFile antfile : this.antfilesMap.values()) {
            antfile.setScope(this.scope);
            RootAntObjectMeta rootObject = antfile.getRootObjectMeta();
            if (rootObject instanceof ProjectMeta) {
                projects.add((ProjectMeta)rootObject);
                continue;
            }
            antlibs.add((AntlibMeta)rootObject);
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("projects", projects);
        root.put("antlibs", antlibs);
        root.put("packages", this.getPackages());
        WikiMethod wikiMethod = new WikiMethod();
        root.put("wiki", wikiMethod);
        Template template = cfg.getTemplate("database.xml.ftl");
        try {
            template.process(root, out);
        }
        catch (TemplateException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        out.flush();
    }

    public Collection<AntFile> getAntFiles() {
        return this.antfilesMap.values();
    }

    public List<PropertyMeta> getProperties() throws IOException {
        ArrayList<PropertyMeta> propertiesList = new ArrayList<PropertyMeta>();
        for (AntFile antfile : this.antfilesMap.values()) {
            RootAntObjectMeta rootMeta = antfile.getRootObjectMeta();
            if (!(rootMeta instanceof ProjectMeta)) continue;
            propertiesList.addAll(((ProjectMeta)rootMeta).getProperties());
        }
        return propertiesList;
    }

    public List<PackageMeta> getPackages() throws IOException {
        ArrayList<PackageMeta> packages = new ArrayList<PackageMeta>();
        for (PackageMeta packageMeta : this.packagesMap.values()) {
            packages.add(packageMeta);
        }
        return packages;
    }
}

