/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.util.ASMifierCodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.util.PrintClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.util.attrs.ASMifiable;

public class ASMifierClassVisitor
extends PrintClassVisitor {
    private static final int ACCESS_CLASS = 262144;
    private static final int ACCESS_FIELD = 524288;
    private static final int ACCESS_INNER = 0x100000;

    public static void main(String[] args) throws Exception {
        if (args.length < 1 || args.length > 2) {
            ASMifierClassVisitor.printUsage();
        }
        int i = 0;
        boolean skipDebug = true;
        if (args[0].equals("-debug")) {
            i = 1;
            skipDebug = false;
            if (args.length != 2) {
                ASMifierClassVisitor.printUsage();
            }
        }
        ClassReader cr = args[i].endsWith(".class") ? new ClassReader(new FileInputStream(args[i])) : new ClassReader(args[i]);
        cr.accept(new ASMifierClassVisitor(new PrintWriter(System.out)), ASMifierClassVisitor.getDefaultAttributes(), skipDebug);
    }

    private static void printUsage() {
        System.err.println("Prints the ASM code to generate the given class.");
        System.err.println("Usage: ASMifierClassVisitor [-debug] <fully qualified class name or class file name>");
        System.exit(-1);
    }

    public ASMifierClassVisitor(PrintWriter pw) {
        super(pw);
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        int n = name.lastIndexOf("/");
        if (n > -1) {
            this.text.add("package asm." + name.substring(0, n).replace('/', '.') + ";\n");
        }
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.*;\n");
        this.text.add("import org.eclipse.persistence.internal.libraries.asm.attrs.*;\n");
        this.text.add("import java.util.*;\n\n");
        this.text.add("public class " + (n == -1 ? name : name.substring(n + 1)) + "Dump implements Constants {\n\n");
        this.text.add("public static byte[] dump () throws Exception {\n\n");
        this.text.add("ClassWriter cw = new ClassWriter(false);\n");
        this.text.add("CodeVisitor cv;\n\n");
        this.buf.setLength(0);
        this.buf.append("cw.visit(");
        switch (version) {
            case 196653: {
                this.buf.append("V1_1");
                break;
            }
            case 46: {
                this.buf.append("V1_2");
                break;
            }
            case 47: {
                this.buf.append("V1_3");
                break;
            }
            case 48: {
                this.buf.append("V1_4");
                break;
            }
            case 49: {
                this.buf.append("V1_5");
                break;
            }
            default: {
                this.buf.append(version);
            }
        }
        this.buf.append(", ");
        this.appendAccess(access | 0x40000);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, name);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, superName);
        this.buf.append(", ");
        if (interfaces != null && interfaces.length > 0) {
            this.buf.append("new String[] {");
            int i = 0;
            while (i < interfaces.length) {
                this.buf.append(i == 0 ? " " : ", ");
                ASMifierClassVisitor.appendConstant(this.buf, interfaces[i]);
                ++i;
            }
            this.buf.append(" }");
        } else {
            this.buf.append("null");
        }
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, sourceFile);
        this.buf.append(");\n\n");
        this.text.add(this.buf.toString());
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.buf.setLength(0);
        this.buf.append("cw.visitInnerClass(");
        ASMifierClassVisitor.appendConstant(this.buf, name);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, outerName);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, innerName);
        this.buf.append(", ");
        this.appendAccess(access | 0x100000);
        this.buf.append(");\n\n");
        this.text.add(this.buf.toString());
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        this.buf.setLength(0);
        int n = 1;
        if (attrs != null) {
            this.buf.append("{\n");
            this.buf.append("// FIELD ATTRIBUTES\n");
            Attribute a = attrs;
            while (a != null) {
                if (a instanceof ASMifiable) {
                    ((ASMifiable)((Object)a)).asmify(this.buf, "fieldAttrs" + n, null);
                    if (n > 1) {
                        this.buf.append("fieldAttrs" + (n - 1) + " = fieldAttrs" + n + ";\n");
                    }
                    ++n;
                } else {
                    this.buf.append("// WARNING! skipped non standard field attribute of type ");
                    this.buf.append(a.type).append("\n");
                }
                a = a.next;
            }
        }
        this.buf.append("cw.visitField(");
        this.appendAccess(access | 0x80000);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, name);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, desc);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, value);
        if (n == 1) {
            this.buf.append(", null);\n\n");
        } else {
            this.buf.append(", fieldAttrs1);\n");
            this.buf.append("}\n\n");
        }
        this.text.add(this.buf.toString());
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        this.buf.setLength(0);
        this.buf.append("{\n");
        int n = 1;
        if (attrs != null) {
            this.buf.append("// METHOD ATTRIBUTES\n");
            Attribute a = attrs;
            while (a != null) {
                if (a instanceof ASMifiable) {
                    ((ASMifiable)((Object)a)).asmify(this.buf, "methodAttrs" + n, null);
                    if (n > 1) {
                        this.buf.append("methodAttrs" + (n - 1) + ".next = methodAttrs" + n + ";\n");
                    }
                    ++n;
                } else {
                    this.buf.append("// WARNING! skipped non standard method attribute of type ");
                    this.buf.append(a.type).append("\n");
                }
                a = a.next;
            }
        }
        this.buf.append("cv = cw.visitMethod(");
        this.appendAccess(access);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, name);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, desc);
        this.buf.append(", ");
        if (exceptions != null && exceptions.length > 0) {
            this.buf.append("new String[] {");
            int i = 0;
            while (i < exceptions.length) {
                this.buf.append(i == 0 ? " " : ", ");
                ASMifierClassVisitor.appendConstant(this.buf, exceptions[i]);
                ++i;
            }
            this.buf.append(" }");
        } else {
            this.buf.append("null");
        }
        if (n == 1) {
            this.buf.append(", null);\n");
        } else {
            this.buf.append(", methodAttrs1);\n");
        }
        this.text.add(this.buf.toString());
        ASMifierCodeVisitor pcv = new ASMifierCodeVisitor();
        this.text.add(pcv.getText());
        this.text.add("}\n");
        return pcv;
    }

    public void visitAttribute(Attribute attr) {
        this.buf.setLength(0);
        if (attr instanceof ASMifiable) {
            this.buf.append("{\n");
            this.buf.append("// CLASS ATRIBUTE\n");
            ((ASMifiable)((Object)attr)).asmify(this.buf, "attr", null);
            this.buf.append("cw.visitAttribute(attr);\n");
            this.buf.append("}\n");
        } else {
            this.buf.append("// WARNING! skipped a non standard class attribute of type \"");
            this.buf.append(attr.type).append("\"\n");
        }
        this.text.add(this.buf.toString());
    }

    public void visitEnd() {
        this.text.add("cw.visitEnd();\n\n");
        this.text.add("return cw.toByteArray();\n");
        this.text.add("}\n");
        this.text.add("}\n");
        super.visitEnd();
    }

    void appendAccess(int access) {
        boolean first = true;
        if ((access & 1) != 0) {
            this.buf.append("ACC_PUBLIC");
            first = false;
        }
        if ((access & 2) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_PRIVATE");
            first = false;
        }
        if ((access & 4) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_PROTECTED");
            first = false;
        }
        if ((access & 0x10) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_FINAL");
            first = false;
        }
        if ((access & 8) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_STATIC");
            first = false;
        }
        if ((access & 0x20) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            if ((access & 0x40000) != 0) {
                this.buf.append("ACC_SUPER");
            } else {
                this.buf.append("ACC_SYNCHRONIZED");
            }
            first = false;
        }
        if ((access & 0x40) != 0 && (access & 0x80000) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_VOLATILE");
            first = false;
        }
        if ((access & 0x40) != 0 && (access & 0x40000) == 0 && (access & 0x80000) == 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_BRIDGE");
            first = false;
        }
        if ((access & 0x80) != 0 && (access & 0x40000) == 0 && (access & 0x80000) == 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_VARARGS");
            first = false;
        }
        if ((access & 0x80) != 0 && (access & 0x80000) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_TRANSIENT");
            first = false;
        }
        if ((access & 0x100) != 0 && (access & 0x40000) == 0 && (access & 0x80000) == 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_NATIVE");
            first = false;
        }
        if ((access & 0x4000) != 0 && ((access & 0x40000) != 0 || (access & 0x80000) != 0 || (access & 0x100000) != 0)) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_ENUM");
            first = false;
        }
        if ((access & 0x2000) != 0 && (access & 0x40000) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_ANNOTATION");
            first = false;
        }
        if ((access & 0x400) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_ABSTRACT");
            first = false;
        }
        if ((access & 0x200) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_INTERFACE");
            first = false;
        }
        if ((access & 0x800) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_STRICT");
            first = false;
        }
        if ((access & 0x1000) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_SYNTHETIC");
            first = false;
        }
        if ((access & 0x20000) != 0) {
            if (!first) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_DEPRECATED");
            first = false;
        }
        if (first) {
            this.buf.append("0");
        }
    }

    static void appendConstant(StringBuffer buf, Object cst) {
        if (cst == null) {
            buf.append("null");
        } else if (cst instanceof String) {
            String s = (String)cst;
            buf.append("\"");
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c == '\n') {
                    buf.append("\\n");
                } else if (c == '\r') {
                    buf.append("\\r");
                } else if (c == '\\') {
                    buf.append("\\\\");
                } else if (c == '\"') {
                    buf.append("\\\"");
                } else if (c < ' ' || c > '\u007f') {
                    buf.append("\\u");
                    if (c < '\u0010') {
                        buf.append("000");
                    } else if (c < '\u0100') {
                        buf.append("00");
                    } else if (c < '\u1000') {
                        buf.append("0");
                    }
                    buf.append(Integer.toString(c, 16));
                } else {
                    buf.append(c);
                }
                ++i;
            }
            buf.append("\"");
        } else if (cst instanceof Type) {
            buf.append("Type.getType(\"");
            buf.append(((Type)cst).getDescriptor());
            buf.append("\")");
        } else if (cst instanceof Integer) {
            buf.append("new Integer(").append(cst).append(")");
        } else if (cst instanceof Float) {
            buf.append("new Float(\"").append(cst).append("\")");
        } else if (cst instanceof Long) {
            buf.append("new Long(").append(cst).append("L)");
        } else if (cst instanceof Double) {
            buf.append("new Double(\"").append(cst).append("\")");
        }
    }
}

