/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.latex.PropertyManager;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.Util;
import info.bliki.wiki.filter.WPCell;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WPRow {
    private List<WPCell> fCells;
    private String fParams;
    private int fType;
    private Map<String, String> fAttributes;

    public WPRow(List<WPCell> cells) {
        this.fCells = cells;
        this.fParams = null;
        this.fType = 1;
        this.fAttributes = null;
    }

    public String getParams() {
        return this.fParams;
    }

    public void setParams(String params) {
        this.fParams = params;
        this.fAttributes = Util.getAttributes(params);
    }

    public boolean add(WPCell cell) {
        return this.fCells.add(cell);
    }

    public Object get(int index) {
        return this.fCells.get(index);
    }

    public int size() {
        return this.fCells.size();
    }

    public void renderHTML(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        if (this.fCells.size() > 0) {
            if (this.fType == 4) {
                if (this.fCells.size() == 1) {
                    this.fCells.get(0).renderHTML(converter, buf, wikiModel);
                }
            } else {
                buf.append("\n<tr");
                HTMLTag.appendEscapedAttributes(buf, this.fAttributes);
                buf.append(">");
                int i = 0;
                while (i < this.fCells.size()) {
                    WPCell cell = this.fCells.get(i);
                    cell.renderHTML(converter, buf, wikiModel);
                    ++i;
                }
                buf.append("</tr>");
            }
        }
    }

    public void renderLaTeX(ITextConverter converter, Appendable _out, IWikiModel wikiModel, int maxCols) throws IOException {
        if (this.fCells.size() > 0) {
            int missingCols = maxCols - this.fCells.size();
            int i = 0;
            while (i < this.fCells.size()) {
                WPCell cell = this.fCells.get(i);
                cell.renderLaTeX(converter, _out, wikiModel);
                if (i < this.fCells.size() - 1) {
                    _out.append(PropertyManager.get("Table.ColumnSep"));
                }
                ++i;
            }
            while (missingCols-- > 0) {
                _out.append(PropertyManager.get("Table.ColumnSep"));
            }
        }
    }

    public int getNumColumns() {
        return this.fCells.size();
    }

    public int getType() {
        return this.fType;
    }

    public void setType(int type) {
        this.fType = type;
    }
}

