/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import jep.Jep;
import jep.JepException;
import jep.JepScriptEngineFactory;
import jep.python.PyModule;
import jep.python.PyObject;

public class JepScriptEngine
implements ScriptEngine {
    private Jep jep = null;
    private Bindings bindings = new SimpleBindings();
    private Bindings globalBindings = new SimpleBindings();
    private ScriptContext context = null;
    private ScriptEngineFactory factory = null;

    public JepScriptEngine() throws ScriptException {
        try {
            this.jep = new Jep(true);
            this.jep.setClassLoader(Thread.currentThread().getContextClassLoader());
        }
        catch (JepException jepException) {
            throw (ScriptException)new ScriptException(jepException.getMessage()).initCause(jepException);
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    private void _setContext(ScriptContext scriptContext) throws ScriptException {
        try {
            this.jep.set("context", scriptContext);
        }
        catch (JepException jepException) {
            throw (ScriptException)new ScriptException(jepException.getMessage()).initCause(jepException);
        }
    }

    private File writeTemp(Reader reader) throws IOException {
        int n;
        File file = File.createTempFile("jep", ".py");
        FileWriter fileWriter = new FileWriter(file);
        char[] cArray = new char[1024];
        while ((n = reader.read(cArray)) > 0) {
            fileWriter.write(cArray, 0, n);
        }
        fileWriter.close();
        return file;
    }

    private Object eval(Reader reader, ScriptContext scriptContext, Bindings bindings) throws ScriptException {
        try {
            this._setContext(scriptContext);
            this.jep.setInteractive(false);
            File file = this.writeTemp(reader);
            this.jep.runScript(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            throw new ScriptException("Error writing to file: " + iOException.getMessage());
        }
        catch (JepException jepException) {
            throw (ScriptException)new ScriptException(jepException.getMessage()).initCause(jepException);
        }
        return null;
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.context, this.bindings);
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return this.eval(reader, scriptContext, this.bindings);
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        return this.eval(reader, this.context, bindings);
    }

    @Override
    public Object eval(String string) throws ScriptException {
        return this.eval(string, this.context, this.bindings);
    }

    @Override
    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        return this.eval(string, scriptContext, this.bindings);
    }

    @Override
    public Object eval(String string, Bindings bindings) throws ScriptException {
        return this.eval(string, this.context, bindings);
    }

    private Object eval(String string, ScriptContext scriptContext, Bindings bindings) throws ScriptException {
        this.jep.setInteractive(true);
        try {
            this._setContext(scriptContext);
            this.jep.eval(string);
        }
        catch (JepException jepException) {
            throw (ScriptException)new ScriptException(jepException.getMessage()).initCause(jepException);
        }
        return null;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        if (this.factory == null) {
            this.factory = new JepScriptEngineFactory();
        }
        return this.factory;
    }

    protected void setFactory(ScriptEngineFactory scriptEngineFactory) {
        this.factory = scriptEngineFactory;
    }

    @Override
    public Object get(String string) {
        try {
            PyModule pyModule = null;
            String[] stringArray = null;
            if (string.indexOf(46) > 0) {
                stringArray = string.split("\\.");
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    pyModule = pyModule == null ? this.jep.createModule(stringArray[i]) : pyModule.createModule(stringArray[i]);
                }
            }
            if (pyModule == null) {
                return this.jep.getValue(string);
            }
            return pyModule.getValue(stringArray[stringArray.length - 1]);
        }
        catch (JepException jepException) {
            return null;
        }
    }

    @Override
    public void put(String string, Object object) throws IllegalArgumentException {
        try {
            PyObject pyObject = null;
            String[] stringArray = null;
            String string2 = null;
            if (string.indexOf(46) > 0) {
                stringArray = string.split("\\.");
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    string2 = stringArray[i];
                    pyObject = pyObject == null ? this.jep.createModule(string2) : ((PyModule)pyObject).createModule(string2);
                }
            }
            if (pyObject == null) {
                this.jep.set(string, object);
            } else {
                pyObject.set(stringArray[stringArray.length - 1], object);
            }
        }
        catch (JepException jepException) {
            throw new IllegalArgumentException(jepException);
        }
    }

    @Override
    public Bindings getBindings(int n) {
        if (n == 100) {
            return this.bindings;
        }
        return this.globalBindings;
    }

    @Override
    public void setBindings(Bindings bindings, int n) {
        if (n == 100) {
            this.bindings = bindings;
        } else {
            this.globalBindings = bindings;
        }
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(ScriptContext scriptContext) {
        this.context = scriptContext;
        try {
            this._setContext(scriptContext);
        }
        catch (ScriptException scriptException) {
            throw new RuntimeException(scriptException);
        }
    }

    public void close() {
        this.jep.close();
    }
}

